/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.potion.brewingstands;

import com.stek101.projectzulu.common.api.ItemList;
import com.stek101.projectzulu.common.api.SubItemPotionList;
import com.stek101.projectzulu.common.core.ItemGenerics;
import com.stek101.projectzulu.common.potion.brewingstands.PotionIngredients;
import com.stek101.projectzulu.common.potion.subitem.SubItemPotion;
import com.stek101.projectzulu.common.potion.subitem.SubItemPotionRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntityBrewingBase
extends TileEntity
implements ISidedInventory {
    protected ItemStack[] brewingItemStacks = new ItemStack[4];
    private int brewTime;
    private int filledSlots;
    private Item ingredientID;

    public String func_145825_b() {
        return "container.brewing";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return this.brewingItemStacks.length;
    }

    public void func_145845_h() {
        if (this.brewTime > 0) {
            --this.brewTime;
            if (this.brewTime == 0) {
                this.brewPotions();
                this.func_70296_d();
            } else if (!this.canBrew()) {
                this.brewTime = 0;
                this.func_70296_d();
            } else if (this.ingredientID != this.brewingItemStacks[this.brewingItemStacks.length - 1].func_77973_b()) {
                this.brewTime = 0;
                this.func_70296_d();
            }
        } else if (this.canBrew()) {
            this.brewTime = 400;
            this.ingredientID = this.brewingItemStacks[this.brewingItemStacks.length - 1].func_77973_b();
        }
        super.func_145845_h();
    }

    public int getBrewTime() {
        return this.brewTime;
    }

    private boolean canBrew() {
        if (this.brewingItemStacks.length > 1 && this.brewingItemStacks[this.brewingItemStacks.length - 1] != null && this.brewingItemStacks[this.brewingItemStacks.length - 1].field_77994_a > 0) {
            ItemStack ingredientStack = this.brewingItemStacks[this.brewingItemStacks.length - 1];
            if (!PotionIngredients.isPotionIngredient(ingredientStack)) {
                return false;
            }
            for (int i = 0; i < this.brewingItemStacks.length - 1; ++i) {
                if (SubItemPotionRegistry.INSTANCE.isItemPotion(this.brewingItemStacks[i])) {
                    ItemStack resultPotion;
                    SubItemPotion brewingSubPotion = SubItemPotionRegistry.INSTANCE.getPotion(this.brewingItemStacks[i]);
                    ItemStack itemStack = resultPotion = brewingSubPotion != null ? brewingSubPotion.getPotionResult(ingredientStack, this.brewingItemStacks[i]) : null;
                    if (resultPotion == null) continue;
                    return true;
                }
                if (!this.isWaterBottleOverride(ingredientStack, this.brewingItemStacks[i])) continue;
                return true;
            }
        }
        return false;
    }

    private void brewPotions() {
        if (this.canBrew()) {
            ItemStack ingredientStack = this.brewingItemStacks[this.brewingItemStacks.length - 1];
            for (int i = 0; i < this.brewingItemStacks.length - 1; ++i) {
                if (SubItemPotionRegistry.INSTANCE.isItemPotion(this.brewingItemStacks[i])) {
                    ItemStack resultPotion;
                    SubItemPotion brewingSubPotion = SubItemPotionRegistry.INSTANCE.getPotion(this.brewingItemStacks[i]);
                    ItemStack itemStack = resultPotion = brewingSubPotion != null ? brewingSubPotion.getPotionResult(ingredientStack, this.brewingItemStacks[i]) : null;
                    if (resultPotion == null) continue;
                    this.brewingItemStacks[i].func_150996_a(resultPotion.func_77973_b());
                    this.brewingItemStacks[i].func_77964_b(resultPotion.func_77960_j());
                    continue;
                }
                if (!this.isWaterBottleOverride(ingredientStack, this.brewingItemStacks[i])) continue;
                this.brewingItemStacks[i].func_150996_a(SubItemPotionList.BUBBLING.get().item);
                this.brewingItemStacks[i].func_77964_b(SubItemPotionList.BUBBLING.get().subID);
            }
            if (ingredientStack.func_77973_b().hasContainerItem(ingredientStack)) {
                this.brewingItemStacks[this.brewingItemStacks.length - 1] = ingredientStack.func_77973_b().getContainerItem(this.brewingItemStacks[this.brewingItemStacks.length - 1]);
            } else {
                --this.brewingItemStacks[this.brewingItemStacks.length - 1].field_77994_a;
                if (this.brewingItemStacks[this.brewingItemStacks.length - 1].field_77994_a <= 0) {
                    this.brewingItemStacks[this.brewingItemStacks.length - 1] = null;
                }
            }
        }
    }

    private boolean isWaterBottleOverride(ItemStack ingredient, ItemStack brewingStack) {
        if (brewingStack == null || ingredient == null || !ItemList.genericCraftingItems.isPresent()) {
            return false;
        }
        return brewingStack.func_77973_b() == Items.field_151068_bn && brewingStack.func_77960_j() == 0 && ingredient.func_77973_b() == ItemList.genericCraftingItems.get() && ingredient.func_77960_j() == ItemGenerics.Properties.ShinyBauble.meta && SubItemPotionList.BUBBLING.isPresent();
    }

    public ItemStack func_70301_a(int par1) {
        return par1 >= 0 && par1 < this.brewingItemStacks.length ? this.brewingItemStacks[par1] : null;
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (par1 >= 0 && par1 < this.brewingItemStacks.length) {
            ItemStack itemstack = this.brewingItemStacks[par1];
            this.brewingItemStacks[par1] = null;
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (par1 >= 0 && par1 < this.brewingItemStacks.length) {
            ItemStack itemstack = this.brewingItemStacks[par1];
            this.brewingItemStacks[par1] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        if (par1 >= 0 && par1 < this.brewingItemStacks.length) {
            this.brewingItemStacks[par1] = par2ItemStack;
        }
    }

    public int func_70297_j_() {
        return 2;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        return par1 == 3 ? PotionIngredients.isPotionIngredient(par2ItemStack) : par2ItemStack.func_77973_b() instanceof ItemPotion || par2ItemStack.func_77973_b() == Items.field_151069_bo;
    }

    @SideOnly(value=Side.CLIENT)
    public void setBrewTime(int par1) {
        this.brewTime = par1;
    }

    public int[] func_94128_d(int side) {
        return side == 1 ? this.getIngredientSlotsForSide(side) : this.getPotionSlotsForSide(side);
    }

    private int[] getPotionSlotsForSide(int side) {
        int[] result = new int[this.brewingItemStacks.length - 1];
        for (int i = 0; i < result.length; ++i) {
            result[i] = i;
        }
        return result;
    }

    private int[] getIngredientSlotsForSide(int side) {
        return new int[]{this.brewingItemStacks.length - 1};
    }

    public boolean func_102007_a(int par1, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(par1, par2ItemStack);
    }

    public boolean func_102008_b(int par1, ItemStack par2ItemStack, int par3) {
        return true;
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList nbttaglist = par1NBTTagCompound.func_150295_c("Items", 10);
        this.brewingItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.brewingItemStacks.length) continue;
            this.brewingItemStacks[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.brewTime = par1NBTTagCompound.func_74765_d("BrewTime");
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74777_a("BrewTime", (short)this.brewTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.brewingItemStacks.length; ++i) {
            if (this.brewingItemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.brewingItemStacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public Packet func_145844_m() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.func_145841_b(var1);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 4, var1);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tagCompound = pkt.func_148857_g();
        this.func_145839_a(tagCompound);
    }
}

