/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.potion.subitem;

import com.google.common.base.Optional;
import com.stek101.projectzulu.common.api.ItemList;
import com.stek101.projectzulu.common.core.ItemGenerics;
import com.stek101.projectzulu.common.potion.EntityPZPotion;
import com.stek101.projectzulu.common.potion.PotionParser;
import com.stek101.projectzulu.common.potion.subitem.SubItemPotion;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public abstract class SubItemPotionGeneric
extends SubItemPotion {
    protected int maxLevel = 2;
    protected int maxDuration = 2;
    protected int maxPower = 2;
    protected int type = 2;
    protected int initialTicks = 0;
    protected int ticksPerLevel = 10;
    protected int durationScale = 12;
    protected int durationSpread = 10;
    protected int powerPerLevel = 1;
    protected String[] strengthPrefixes = new String[]{"", "Thickened", "Strengthened", "Fortified"};
    protected String[] durationPrefixes = new String[]{"", "Extended", "Prolonged", "Continuous"};
    protected String[] durationPostfixes = new String[]{"", "of Extended", "of Prolonged", "of Continuous"};
    protected String[] strengthPostfixes = new String[]{"", "Thickness", "Strength", "Fortification"};

    SubItemPotionGeneric(Item item, int subID, String baseName) {
        super(item, subID, baseName);
    }

    @Override
    public void register() {
    }

    @Override
    public final ItemStack getPotionResult(ItemStack ingredient, ItemStack brewingStack) {
        switch (this.getIngredientType(ingredient, brewingStack)) {
            case POWER: {
                int power = PotionParser.readPower(brewingStack.func_77960_j());
                int duration = PotionParser.readDuration(brewingStack.func_77960_j());
                int metaDamage = brewingStack.func_77960_j();
                if (power >= this.maxPower - 1) break;
                if (duration > 0) {
                    metaDamage = PotionParser.setDuration(duration - 1, metaDamage);
                }
                return new ItemStack(brewingStack.func_77973_b(), brewingStack.field_77994_a, PotionParser.setPower(power + 1, metaDamage));
            }
            case DURATION: {
                int power = PotionParser.readPower(brewingStack.func_77960_j());
                int duration = PotionParser.readDuration(brewingStack.func_77960_j());
                int metaDamage = brewingStack.func_77960_j();
                if (duration >= this.maxDuration - 1) break;
                if (power > 0) {
                    metaDamage = PotionParser.setPower(power - 1, metaDamage);
                }
                return new ItemStack(brewingStack.func_77973_b(), brewingStack.field_77994_a, PotionParser.setDuration(duration + 1, metaDamage));
            }
            case TIER: {
                int level = PotionParser.readLevel(brewingStack.func_77960_j());
                int power = PotionParser.readPower(brewingStack.func_77960_j());
                int duration = PotionParser.readDuration(brewingStack.func_77960_j());
                int metaDamage = brewingStack.func_77960_j();
                if (level >= this.maxLevel - 1) break;
                if (power > 0) {
                    metaDamage = PotionParser.setPower(power - 1, metaDamage);
                }
                if (duration > 0) {
                    metaDamage = PotionParser.setDuration(duration - 1, metaDamage);
                }
                return new ItemStack(brewingStack.func_77973_b(), brewingStack.field_77994_a, PotionParser.setLevel(level + 1, metaDamage));
            }
            case CHEMICAL: {
                return this.getChemicalPotionResult(ingredient, brewingStack);
            }
            case SPLASH: {
                if (PotionParser.isSplash(brewingStack.func_77960_j())) break;
                return new ItemStack(brewingStack.func_77973_b(), brewingStack.field_77994_a, PotionParser.setSplash(brewingStack.func_77960_j()));
            }
        }
        return super.getPotionResult(ingredient, brewingStack);
    }

    protected ItemStack getChemicalPotionResult(ItemStack ingredient, ItemStack brewingStack) {
        return null;
    }

    protected TYPE getIngredientType(ItemStack ingredient, ItemStack brewingStack) {
        if (ingredient.func_77973_b() == Items.field_151137_ax) {
            return TYPE.POWER;
        }
        if (ingredient.func_77973_b() == Items.field_151114_aO) {
            return TYPE.DURATION;
        }
        if (ingredient.func_77973_b() == Items.field_151016_H) {
            return TYPE.SPLASH;
        }
        if (ItemList.genericCraftingItems.isPresent() && ingredient.func_77973_b() == ItemList.genericCraftingItems.get() && ingredient.func_77960_j() == ItemGenerics.Properties.ShinyBauble.meta) {
            return TYPE.TIER;
        }
        return TYPE.NONE;
    }

    protected void setSubItemBounds(int maxLevel, int maxDuration, int maxPower, int type) {
        this.maxLevel = maxLevel;
        this.maxDuration = maxDuration;
        this.maxPower = maxPower;
        this.type = type;
    }

    protected void setEffectScale(int initialTicks, int ticksPerLevel, int durationScale, int durationSpread, int powerPerLevel) {
        this.initialTicks = initialTicks;
        this.ticksPerLevel = ticksPerLevel;
        this.durationScale = durationScale;
        this.durationSpread = durationSpread;
        this.powerPerLevel = powerPerLevel;
    }

    abstract Optional<? extends Potion> getPotion();

    @Override
    public String getDisplayName(ItemStack itemStack) {
        int level = PotionParser.readLevel(itemStack.func_77960_j());
        int duration = PotionParser.readDuration(itemStack.func_77960_j());
        int power = PotionParser.readPower(itemStack.func_77960_j());
        String nameBuilder = "";
        if (power <= 0 && duration > 0) {
            nameBuilder = nameBuilder + this.durationPrefixes[duration] + " ";
        } else if (power > 0 && duration <= 0) {
            nameBuilder = nameBuilder + this.strengthPrefixes[power] + " ";
        }
        nameBuilder = nameBuilder + StatCollector.func_74838_a((String)this.baseName).trim() + " Potion";
        if (power > 0 && duration > 0) {
            nameBuilder = nameBuilder + " " + this.durationPostfixes[duration] + " " + this.strengthPostfixes[power];
        }
        if (level > 0) {
            nameBuilder = nameBuilder + " ";
            for (int i = 1; i <= level; ++i) {
                nameBuilder = nameBuilder + "I";
            }
        }
        return nameBuilder;
    }

    @Override
    public boolean hasPotionEffects(ItemStack itemStack) {
        return true;
    }

    @Override
    public List<PotionEffect> getPotionEffects(int damageMeta) {
        ArrayList<PotionEffect> effectList = new ArrayList<PotionEffect>();
        if (this.getPotion().isPresent()) {
            effectList.add(new PotionEffect(((Potion)this.getPotion().get()).field_76415_H, ((Potion)this.getPotion().get()).func_76403_b() ? 1 : this.calculateDuration(damageMeta), this.calculatePower(damageMeta)));
        }
        return effectList;
    }

    protected int calculateDuration(int damageMeta) {
        int baseLevel = PotionParser.readLevel(damageMeta);
        int baseDuration = PotionParser.readDuration(damageMeta);
        int tempBase = this.initialTicks + baseLevel * this.ticksPerLevel;
        double tempBonus = Math.pow(baseDuration + 11 - this.durationSpread, 2.0) / (Math.pow(this.maxDuration - 1, 2.0) + (double)this.maxDuration - 1.0) * (double)this.durationScale;
        return (int)((double)tempBase * tempBonus);
    }

    protected int calculatePower(int damageMeta) {
        return PotionParser.readPower(damageMeta) + this.powerPerLevel * PotionParser.readLevel(damageMeta);
    }

    @Override
    public void getSubItems(Item itemID, CreativeTabs creativeTab, List<ItemStack> list) {
        int damage;
        int duration;
        int power;
        int level;
        if (!this.getPotion().isPresent()) {
            return;
        }
        if (this.type == 0 || this.type == 1) {
            for (level = 0; level < this.maxLevel; ++level) {
                for (power = 0; power < this.maxPower; ++power) {
                    for (duration = 0; duration < this.maxDuration; ++duration) {
                        damage = PotionParser.setPower(power, PotionParser.setDuration(duration, PotionParser.setLevel(level, this.subID)));
                        list.add(new ItemStack(itemID, 1, damage));
                    }
                }
            }
        }
        if (this.type == 0 || this.type == 2) {
            for (level = 0; level < this.maxLevel; ++level) {
                for (power = 0; power < this.maxPower; ++power) {
                    for (duration = 0; duration < this.maxDuration; ++duration) {
                        damage = PotionParser.setSplash(PotionParser.setPower(power, PotionParser.setDuration(duration, PotionParser.setLevel(level, this.subID))));
                        list.add(new ItemStack(itemID, 1, damage));
                    }
                }
            }
        }
    }

    @Override
    public boolean isEffectInstant(int damageMeta) {
        if (this.getPotion().isPresent()) {
            return ((Potion)this.getPotion().get()).func_76403_b();
        }
        return false;
    }

    @Override
    public void addInformation(ItemStack itemStack, EntityPlayer player, List<String> list, boolean par4) {
        List<PotionEffect> effectList = this.getPotionEffects(itemStack);
        if (effectList != null && !effectList.isEmpty()) {
            for (PotionEffect potioneffect : effectList) {
                String line1 = StatCollector.func_74838_a((String)potioneffect.func_76453_d()).trim();
                line1 = line1.concat(" - Power ").concat(Integer.toString(potioneffect.func_76458_c() + 1));
                if (potioneffect.func_76459_b() > 20 && !this.isEffectInstant(itemStack.func_77960_j())) {
                    line1 = line1 + " (" + Potion.func_76389_a((PotionEffect)potioneffect) + ")";
                }
                if (Potion.field_76425_a[potioneffect.func_76456_a()].func_76398_f()) {
                    list.add(EnumChatFormatting.RED + line1);
                    continue;
                }
                list.add(EnumChatFormatting.GRAY + line1);
            }
        } else {
            String s1 = StatCollector.func_74838_a((String)"potion.empty").trim();
            list.add(EnumChatFormatting.GRAY + s1);
        }
    }

    @Override
    protected EntityPotion getEntityPotion(ItemStack itemStack, World world, EntityPlayer player) {
        return new EntityPZPotion(world, (EntityLivingBase)player, itemStack);
    }

    static enum TYPE {
        CHEMICAL,
        POWER,
        DURATION,
        TIER,
        SPLASH,
        NONE;

    }
}

