/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world;

import java.util.Random;

public enum CellIndexDirection {
    Middle,
    Inner,
    NorthMiddle,
    SouthMiddle,
    WestMiddle,
    EastMiddle,
    NorthWestCorner,
    NorthEastCorner,
    SouthWestCorner,
    SouthEastCorner,
    NorthWall,
    SouthWall,
    WestWall,
    EastWall;


    public boolean isCorner() {
        return this == NorthWestCorner || this == NorthEastCorner || this == SouthWestCorner || this == SouthEastCorner;
    }

    public static CellIndexDirection randomCardinalDirection(Random random) {
        switch (random.nextInt(4)) {
            case 0: {
                return NorthMiddle;
            }
            case 1: {
                return SouthMiddle;
            }
            case 2: {
                return WestMiddle;
            }
            case 3: {
                return EastMiddle;
            }
        }
        return NorthMiddle;
    }

    public CellIndexDirection calcDirection(int cellIndex, int cellSize) {
        if (cellSize % 2 == 1) {
            if (cellIndex == cellSize * (cellSize - 1) / 2 + (cellSize - 1) / 2) {
                return Middle;
            }
            if (cellIndex == (cellSize - 1) / 2) {
                return WestMiddle;
            }
            if (cellIndex == cellSize * (cellSize - 1) / 2) {
                return NorthMiddle;
            }
            if (cellIndex == cellSize * (cellSize - 1) + (cellSize - 1) / 2) {
                return EastMiddle;
            }
            if (cellIndex == cellSize * (cellSize - 1) / 2 + (cellSize - 1)) {
                return SouthMiddle;
            }
        }
        if (cellIndex == 0) {
            return NorthWestCorner;
        }
        if (cellIndex == cellSize - 1) {
            return SouthWestCorner;
        }
        if (cellIndex == cellSize * cellSize - 1) {
            return SouthEastCorner;
        }
        if (cellIndex == cellSize * cellSize - cellSize) {
            return NorthEastCorner;
        }
        if (cellIndex % cellSize == 0) {
            return NorthWall;
        }
        if (cellIndex % cellSize == cellSize - 1) {
            return SouthWall;
        }
        if (cellIndex >= cellSize * (cellSize - 1) && cellIndex < cellSize * cellSize) {
            return EastWall;
        }
        if (cellIndex >= 0 && cellIndex < cellSize) {
            return WestWall;
        }
        return Inner;
    }
}

