/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world.retroGenerator;

import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.common.util.ForgeDirection;

public class Location {
    public int x;
    public int y;
    public int z;

    public Location(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Location(int xCoord, int yCoord, int zCoord, ForgeDirection dir) {
        this.x = xCoord + dir.offsetX;
        this.y = yCoord + dir.offsetY;
        this.z = zCoord + dir.offsetZ;
    }

    public Location(int[] coords) {
        if (coords.length >= 2) {
            this.x = coords[0];
            this.y = coords[1];
            this.z = coords[2];
        }
    }

    public Location(ChunkPosition pos) {
        if (pos != null) {
            this.x = pos.field_151329_a;
            this.y = pos.field_151327_b;
            this.z = pos.field_151328_c;
        }
    }

    public Location(MovingObjectPosition blockLookedAt) {
        if (blockLookedAt != null) {
            this.x = blockLookedAt.field_72311_b;
            this.y = blockLookedAt.field_72312_c;
            this.z = blockLookedAt.field_72309_d;
        }
    }

    public boolean equals(Location toTest) {
        return this.x == toTest.x && this.y == toTest.y && this.z == toTest.z;
    }

    public void setLocation(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int newX) {
        this.x = newX;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int newY) {
        this.y = newY;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int newZ) {
        this.z = newZ;
    }

    public int[] getLocation() {
        int[] ret = new int[]{this.x, this.y, this.z};
        return ret;
    }

    public void setLocation(int[] coords) {
        this.x = coords[0];
        this.y = coords[1];
        this.z = coords[2];
    }

    public int getDifference(Location otherLoc) {
        return (int)Math.sqrt(Math.pow(this.x - otherLoc.x, 2.0) + Math.pow(this.y - otherLoc.y, 2.0) + Math.pow(this.z - otherLoc.z, 2.0));
    }

    public String printLocation() {
        return "X: " + this.x + " Y: " + this.y + " Z: " + this.z;
    }

    public String printCoords() {
        return this.x + ", " + this.y + ", " + this.z;
    }

    public boolean compare(int x, int y, int z) {
        return this.x == x && this.y == y && this.z == z;
    }
}

