/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world.terrain;

import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.core.TerrainFeatureHelper;
import com.stek101.projectzulu.common.core.terrain.BiomeFeature;
import com.stek101.projectzulu.common.core.terrain.TerrainFeature;
import com.stek101.projectzulu.common.world2.buildingmanager.BuildingManagerCemetary;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class CemetaryFeature
extends BiomeFeature {
    public static final String CEMETARY = "Cemetery";

    public CemetaryFeature() {
        super(CEMETARY, TerrainFeature.Size.MEDIUM);
    }

    @Override
    protected void loadDefaultSettings() {
        this.minChunkDistance = 3;
        this.chunksPerSpawn = 100;
    }

    @Override
    protected Collection<String> getDefaultBiomeList() {
        return Arrays.asList(BiomeGenBase.field_76772_c.field_76791_y, BiomeGenBase.field_76770_e.field_76791_y, BiomeGenBase.field_76767_f.field_76791_y, BiomeGenBase.field_76792_x.field_76791_y, BiomeGenBase.field_76768_g.field_76791_y, BiomeGenBase.field_76780_h.field_76791_y, BiomeGenBase.field_76774_n.field_76791_y, BiomeGenBase.field_76782_w.field_76791_y, BiomeGenBase.field_76775_o.field_76791_y, BiomeGenBase.field_76786_s.field_76791_y, BiomeGenBase.field_76785_t.field_76791_y, BiomeGenBase.field_76784_u.field_76791_y, BiomeGenBase.field_76783_v.field_76791_y, "Birch Forest", "Forested Island", "Forested Hills", "Green Hills", "Mountain Taiga", "Pine Forest", "Rainforest", "Redwood Forest", "Lush Redwoods", "Snow Forest", "Snowy Rainforest", "Temperate Rainforest", "Woodlands");
    }

    @Override
    public ChunkCoordinates[] getGenerationCoordinates(World world, int chunkX, int chunkZ) {
        Random random = new Random(world.func_72905_C());
        long randomFactor1 = random.nextLong() / 2L * 2L + 1L;
        long randomFactor2 = random.nextLong() / 2L * 2L + 1L;
        random.setSeed((long)(chunkX * 16) * randomFactor1 + (long)(chunkZ * 16) * randomFactor2 ^ world.func_72905_C());
        int xCoord = chunkX * 16 + random.nextInt(16);
        int zCoord = chunkZ * 16 + random.nextInt(16);
        return new ChunkCoordinates[]{new ChunkCoordinates(xCoord, world.func_72825_h(xCoord, zCoord), zCoord)};
    }

    @Override
    public boolean canGenerateHere(World world, int chunkX, int chunkZ, ChunkCoordinates genBlockCoords, Random random) {
        if (super.canGenerateHere(world, chunkX, chunkZ, genBlockCoords, random) && world.func_147439_a(genBlockCoords.field_71574_a, genBlockCoords.field_71572_b, genBlockCoords.field_71573_c).func_149688_o() != Material.field_151586_h && world.func_147439_a(genBlockCoords.field_71574_a, genBlockCoords.field_71572_b - 1, genBlockCoords.field_71573_c).func_149688_o() != Material.field_151588_w && world.func_147439_a(genBlockCoords.field_71574_a, genBlockCoords.field_71572_b, genBlockCoords.field_71573_c).func_149688_o() != Material.field_151595_p && !TerrainFeatureHelper.doesTerrainFluctuate(world, genBlockCoords.field_71574_a, genBlockCoords.field_71572_b, genBlockCoords.field_71573_c, 2, 6)) {
            if (this.printToLog) {
                ProjectZuluLog.info("Generating %s at %s, %s, %s", this.getFeatureName(), genBlockCoords.field_71574_a, genBlockCoords.field_71572_b, genBlockCoords.field_71573_c);
            }
            return true;
        }
        return false;
    }

    @Override
    public void generateFeature(World world, int chunkX, int chunkZ, ChunkCoordinates genBlockCoords, Random random, TerrainFeature.FeatureDirection direction) {
        new BuildingManagerCemetary(world, new ChunkCoordinates(genBlockCoords.field_71574_a, genBlockCoords.field_71572_b - 1, genBlockCoords.field_71573_c), direction).generate();
    }
}

