/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world.terrain;

import com.stek101.projectzulu.common.api.CustomEntityList;
import com.stek101.projectzulu.common.api.CustomMobData;
import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.core.TerrainFeatureHelper;
import com.stek101.projectzulu.common.core.terrain.BiomeFeature;
import com.stek101.projectzulu.common.core.terrain.FeatureConfiguration;
import com.stek101.projectzulu.common.core.terrain.TerrainFeature;
import com.stek101.projectzulu.common.world.terrain.EntityEntry;
import com.stek101.projectzulu.common.world2.buildingmanager.BuildingManagerPyramid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IllegalFormatException;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class PyramidFeature
extends BiomeFeature {
    public static final String PYRAMID = "Pyramid";
    private List<EntityEntry> entityEntries = new ArrayList<EntityEntry>();
    public int chestLootChance;
    public int chestMaxLoot;

    public String getEntityEntry(Random rand) {
        if (this.entityEntries.isEmpty()) {
            return "EMPTY";
        }
        return ((EntityEntry)WeightedRandom.func_76271_a((Random)rand, this.entityEntries)).entityname;
    }

    public PyramidFeature() {
        super(PYRAMID, TerrainFeature.Size.LARGE);
    }

    @Override
    protected void loadDefaultSettings() {
        this.minChunkDistance = 9;
        this.chunksPerSpawn = 100;
        this.chestLootChance = 15;
        this.chestMaxLoot = -1;
        if (CustomEntityList.MUMMY.modData.isPresent()) {
            this.entityEntries.add(new EntityEntry("ProjectZulu|Core".concat(".").concat(((CustomMobData)CustomEntityList.MUMMY.modData.get()).mobName), 4));
        }
        if (this.entityEntries.isEmpty()) {
            this.entityEntries.add(new EntityEntry("Zombie", 4));
        }
    }

    @Override
    protected Collection<String> getDefaultBiomeList() {
        return Arrays.asList(BiomeGenBase.field_76769_d.field_76791_y, "Mountainous Desert");
    }

    @Override
    protected void loadSettings(FeatureConfiguration config) {
        super.loadSettings(config);
        this.chestMaxLoot = config.getFeatureProperty((TerrainFeature)this, "general", "Chest Max Loot", this.chestMaxLoot).getInt(this.chestMaxLoot);
        this.chestLootChance = config.getFeatureProperty((TerrainFeature)this, "general", "Chest Loot Chance", this.chestLootChance).getInt(this.chestLootChance);
        String entries = "";
        Iterator<EntityEntry> iterator = this.entityEntries.iterator();
        while (iterator.hasNext()) {
            EntityEntry entityEntry = iterator.next();
            entries = entries.concat(entityEntry.entityname).concat("-").concat(Integer.toString(entityEntry.field_76292_a));
            if (!iterator.hasNext()) continue;
            entries = entries.concat(",");
        }
        entries = config.getFeatureProperty((TerrainFeature)this, "general", "SpawnerEntities", entries, "Entities that appear in Spawner. Format: Entityname-Weight,").getString();
        this.entityEntries.clear();
        for (String entry : entries.split(",")) {
            if (entry.trim().equals("")) continue;
            String[] pair = entry.trim().split("-");
            if (pair.length != 2) {
                ProjectZuluLog.severe("Skipping Entity parsing for TF %s. %s has Invalid Number of Arguments.", this.getFeatureName(), entries);
            }
            try {
                EntityEntry entityEntry = new EntityEntry(pair[0].trim(), Integer.parseInt(pair[1]));
                this.entityEntries.add(entityEntry);
            }
            catch (IllegalFormatException e) {
                ProjectZuluLog.severe("Skipping Entity parsing for TF %s. %s has invalid format.", this.getFeatureName(), entries);
            }
            catch (IllegalArgumentException e) {
                ProjectZuluLog.severe("Skipping Entity parsing for TF %s. %s has invalid format.", this.getFeatureName(), entries);
            }
        }
    }

    @Override
    public ChunkCoordinates[] getGenerationCoordinates(World world, int chunkX, int chunkZ) {
        Random random = new Random(world.func_72905_C());
        long randomFactor1 = random.nextLong() / 2L * 2L + 1L;
        long randomFactor2 = random.nextLong() / 2L * 2L + 1L;
        random.setSeed((long)(chunkX * 16) * randomFactor1 + (long)(chunkZ * 16) * randomFactor2 ^ world.func_72905_C());
        int xCoord = chunkX * 16 + random.nextInt(16);
        int zCoord = chunkZ * 16 + random.nextInt(16);
        return new ChunkCoordinates[]{new ChunkCoordinates(xCoord, world.func_72825_h(xCoord, zCoord), zCoord)};
    }

    @Override
    public boolean canGenerateHere(World world, int chunkX, int chunkZ, ChunkCoordinates genBlockCoords, Random random) {
        if (super.canGenerateHere(world, chunkX, chunkZ, genBlockCoords, random) && world.func_147439_a(genBlockCoords.field_71574_a, genBlockCoords.field_71572_b, genBlockCoords.field_71573_c).func_149688_o() != Material.field_151586_h && !TerrainFeatureHelper.doesTerrainFluctuate(world, genBlockCoords.field_71574_a, genBlockCoords.field_71572_b, genBlockCoords.field_71573_c, 5, 12)) {
            if (this.printToLog) {
                ProjectZuluLog.info("Generating %s at %s, %s, %s", this.getFeatureName(), genBlockCoords.field_71574_a, genBlockCoords.field_71572_b, genBlockCoords.field_71573_c);
            }
            return true;
        }
        return false;
    }

    @Override
    public void generateFeature(World world, int chunkX, int chunkZ, ChunkCoordinates genBlockCoords, Random random, TerrainFeature.FeatureDirection direction) {
        new BuildingManagerPyramid(world, new ChunkCoordinates(genBlockCoords.field_71574_a, genBlockCoords.field_71572_b - 1, genBlockCoords.field_71573_c), direction).generate();
    }
}

