/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world2.architect;

import com.stek101.projectzulu.common.world2.Direction;
import com.stek101.projectzulu.common.world2.MazeCell;
import com.stek101.projectzulu.common.world2.architect.Architect;
import com.stek101.projectzulu.common.world2.architect.BlueprintSetStockpile;
import java.awt.Point;
import java.util.Random;
import net.minecraft.world.World;

public abstract class ArchitectBase
implements Architect {
    protected BlueprintSetStockpile stockpile;
    protected Random random;

    public ArchitectBase(World world) {
        this.random = world.field_73012_v;
        this.stockpile = new BlueprintSetStockpile(world.field_73012_v);
    }

    public static Boolean isDeadEnd(MazeCell[][] allCells, Point buildCoords, int ... rawState) {
        int wallsNearby = 0;
        block0: for (Direction direction : Direction.getCardinals()) {
            int neighbourX = buildCoords.x + direction.x;
            int neighbourZ = buildCoords.y + direction.z;
            if (ArchitectBase.isCellOutOfBounds(allCells, neighbourX, neighbourZ)) continue;
            for (int state : rawState) {
                if (allCells[neighbourX][neighbourZ].rawState != state) continue;
                ++wallsNearby;
                continue block0;
            }
        }
        return wallsNearby == 3;
    }

    public static Boolean isTouchingAmount(MazeCell[][] allCells, Point buildCoords, int minTouching, int maxTouching, boolean countEdges, int ... rawState) {
        int wallsNearby = 0;
        block0: for (Direction direction : Direction.getCardinals()) {
            int neighbourX = buildCoords.x + direction.x;
            int neighbourZ = buildCoords.y + direction.z;
            if (ArchitectBase.isCellOutOfBounds(allCells, neighbourX, neighbourZ)) {
                if (!countEdges) continue;
                ++wallsNearby;
                continue;
            }
            for (int state : rawState) {
                if (allCells[neighbourX][neighbourZ].rawState != state) continue;
                ++wallsNearby;
                continue block0;
            }
        }
        return wallsNearby >= minTouching && wallsNearby <= maxTouching;
    }

    public static boolean isCellOutOfBounds(MazeCell[][] allCells, int currentX, int currentZ) {
        return currentX < 0 || currentX >= allCells.length || currentZ < 0 || currentZ >= allCells[0].length;
    }
}

