/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world2.blueprint;

import com.stek101.projectzulu.common.world.CellIndexDirection;
import com.stek101.projectzulu.common.world.dataobjects.BlockWithMeta;
import com.stek101.projectzulu.common.world2.MazeCell;
import com.stek101.projectzulu.common.world2.blueprint.Blueprint;
import com.stek101.projectzulu.common.world2.blueprint.BlueprintSet;
import java.awt.Point;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;

public class BPSetDoorway
implements BlueprintSet,
Blueprint {
    private boolean hasBeenApplied = false;

    @Override
    public boolean isApplicable(MazeCell[][] cells, Point buildCoords, Random random) {
        if (random.nextInt(10) != 0) {
            return false;
        }
        if (this.isWestWall(cells, buildCoords) && cells[buildCoords.x + 2][buildCoords.y].rawState == 0 && cells[buildCoords.x + 2][buildCoords.y + 1].rawState == 0) {
            boolean applied = this.hasBeenApplied;
            this.hasBeenApplied = true;
            return !applied;
        }
        if (this.isEastWall(cells, buildCoords) && cells[buildCoords.x - 2][buildCoords.y].rawState == 0 && cells[buildCoords.x - 2][buildCoords.y + 1].rawState == 0) {
            boolean applied = this.hasBeenApplied;
            this.hasBeenApplied = true;
            return !applied;
        }
        if (this.isNorthWall(cells, buildCoords) && cells[buildCoords.x][buildCoords.y + 2].rawState == 0 && cells[buildCoords.x + 1][buildCoords.y + 2].rawState == 0) {
            boolean applied = this.hasBeenApplied;
            this.hasBeenApplied = true;
            return !applied;
        }
        if (this.isSouthWall(cells, buildCoords) && cells[buildCoords.x][buildCoords.y - 2].rawState == 0 && cells[buildCoords.x + 1][buildCoords.y - 2].rawState == 0) {
            boolean applied = this.hasBeenApplied;
            this.hasBeenApplied = true;
            return !applied;
        }
        return false;
    }

    @Override
    public boolean assignCellsWithBlueprints(MazeCell[][] cells, Point buildCoords, Random random) {
        if (this.isWestWall(cells, buildCoords)) {
            cells[buildCoords.x][buildCoords.y].setBuildingProperties(this.getIdentifier(), CellIndexDirection.NorthWall);
            cells[buildCoords.x][buildCoords.y].rawState = -1;
            cells[buildCoords.x][buildCoords.y + 1].setBuildingProperties(this.getIdentifier(), CellIndexDirection.SouthWall);
            cells[buildCoords.x][buildCoords.y + 1].rawState = -1;
            cells[buildCoords.x + 1][buildCoords.y].setBuildingProperties(this.getIdentifier(), CellIndexDirection.NorthWall);
            cells[buildCoords.x + 1][buildCoords.y].rawState = -1;
            cells[buildCoords.x + 1][buildCoords.y + 1].setBuildingProperties(this.getIdentifier(), CellIndexDirection.SouthWall);
            cells[buildCoords.x + 1][buildCoords.y + 1].rawState = -1;
        } else if (this.isEastWall(cells, buildCoords)) {
            cells[buildCoords.x][buildCoords.y].setBuildingProperties(this.getIdentifier(), CellIndexDirection.NorthWall);
            cells[buildCoords.x][buildCoords.y].rawState = -1;
            cells[buildCoords.x][buildCoords.y + 1].setBuildingProperties(this.getIdentifier(), CellIndexDirection.SouthWall);
            cells[buildCoords.x][buildCoords.y + 1].rawState = -1;
            cells[buildCoords.x - 1][buildCoords.y].setBuildingProperties(this.getIdentifier(), CellIndexDirection.NorthWall);
            cells[buildCoords.x - 1][buildCoords.y].rawState = -1;
            cells[buildCoords.x - 1][buildCoords.y + 1].setBuildingProperties(this.getIdentifier(), CellIndexDirection.SouthWall);
            cells[buildCoords.x - 1][buildCoords.y + 1].rawState = -1;
        } else if (this.isNorthWall(cells, buildCoords)) {
            cells[buildCoords.x][buildCoords.y].setBuildingProperties(this.getIdentifier(), CellIndexDirection.EastWall);
            cells[buildCoords.x][buildCoords.y].rawState = -1;
            cells[buildCoords.x][buildCoords.y + 1].setBuildingProperties(this.getIdentifier(), CellIndexDirection.EastWall);
            cells[buildCoords.x][buildCoords.y + 1].rawState = -1;
            cells[buildCoords.x + 1][buildCoords.y].setBuildingProperties(this.getIdentifier(), CellIndexDirection.WestWall);
            cells[buildCoords.x + 1][buildCoords.y].rawState = -1;
            cells[buildCoords.x + 1][buildCoords.y + 1].setBuildingProperties(this.getIdentifier(), CellIndexDirection.WestWall);
            cells[buildCoords.x + 1][buildCoords.y + 1].rawState = -1;
        } else if (this.isSouthWall(cells, buildCoords)) {
            cells[buildCoords.x][buildCoords.y].setBuildingProperties(this.getIdentifier(), CellIndexDirection.EastWall);
            cells[buildCoords.x][buildCoords.y].rawState = -1;
            cells[buildCoords.x][buildCoords.y - 1].setBuildingProperties(this.getIdentifier(), CellIndexDirection.EastWall);
            cells[buildCoords.x][buildCoords.y - 1].rawState = -1;
            cells[buildCoords.x + 1][buildCoords.y].setBuildingProperties(this.getIdentifier(), CellIndexDirection.WestWall);
            cells[buildCoords.x + 1][buildCoords.y].rawState = -1;
            cells[buildCoords.x + 1][buildCoords.y - 1].setBuildingProperties(this.getIdentifier(), CellIndexDirection.WestWall);
            cells[buildCoords.x + 1][buildCoords.y - 1].rawState = -1;
        }
        return true;
    }

    private boolean isWestWall(MazeCell[][] cells, Point buildCoords) {
        return buildCoords.x == 0 && buildCoords.y > 2 && buildCoords.y < cells[0].length - 3;
    }

    private boolean isEastWall(MazeCell[][] cells, Point buildCoords) {
        return buildCoords.x == cells.length - 1 && buildCoords.y > 2 && buildCoords.y < cells[0].length - 3;
    }

    private boolean isNorthWall(MazeCell[][] cells, Point buildCoords) {
        return buildCoords.y == 0 && buildCoords.x > 2 && buildCoords.x < cells.length - 3;
    }

    private boolean isSouthWall(MazeCell[][] cells, Point buildCoords) {
        return buildCoords.y == cells[0].length - 1 && buildCoords.x > 2 && buildCoords.x < cells.length - 3;
    }

    @Override
    public BlockWithMeta getBlockFromBlueprint(ChunkCoordinates piecePos, int cellSize, int cellHeight, CellIndexDirection cellIndexDirection, Random random, String buildingID) {
        if (cellIndexDirection == CellIndexDirection.SouthWall) {
            if (piecePos.field_71572_b == 0) {
                return new BlockWithMeta(Blocks.field_150322_A);
            }
            if (piecePos.field_71573_c == cellSize - 1) {
                return new BlockWithMeta(Blocks.field_150322_A);
            }
            if (piecePos.field_71572_b == cellHeight - 1) {
                return new BlockWithMeta(Blocks.field_150372_bz, 6);
            }
            return new BlockWithMeta(Blocks.field_150350_a);
        }
        if (cellIndexDirection == CellIndexDirection.NorthWall) {
            if (piecePos.field_71572_b == 0) {
                return new BlockWithMeta(Blocks.field_150322_A);
            }
            if (piecePos.field_71573_c == 0) {
                return new BlockWithMeta(Blocks.field_150322_A);
            }
            if (piecePos.field_71572_b == cellHeight - 1) {
                return new BlockWithMeta(Blocks.field_150372_bz, 7);
            }
            return new BlockWithMeta(Blocks.field_150350_a);
        }
        if (cellIndexDirection == CellIndexDirection.WestWall) {
            if (piecePos.field_71572_b == 0) {
                return new BlockWithMeta(Blocks.field_150322_A);
            }
            if (piecePos.field_71574_a == cellSize - 1) {
                return new BlockWithMeta(Blocks.field_150322_A);
            }
            if (piecePos.field_71572_b == cellHeight - 1) {
                return new BlockWithMeta(Blocks.field_150372_bz, 4);
            }
            return new BlockWithMeta(Blocks.field_150350_a);
        }
        if (cellIndexDirection == CellIndexDirection.EastWall) {
            if (piecePos.field_71572_b == 0) {
                return new BlockWithMeta(Blocks.field_150322_A);
            }
            if (piecePos.field_71574_a == 0) {
                return new BlockWithMeta(Blocks.field_150322_A);
            }
            if (piecePos.field_71572_b == cellHeight - 1) {
                return new BlockWithMeta(Blocks.field_150372_bz, 5);
            }
            return new BlockWithMeta(Blocks.field_150350_a);
        }
        return new BlockWithMeta(Blocks.field_150340_R);
    }

    @Override
    public String getIdentifier() {
        return "Pyramid_Door";
    }

    @Override
    public int getWeight() {
        return 0;
    }

    @Override
    public BlockWithMeta getBlockFromBlueprint(ChunkCoordinates piecePos, int cellSize, int cellHeight, Random random, CellIndexDirection cellIndexDirection) {
        return null;
    }
}

