/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world2.blueprint;

import com.stek101.projectzulu.common.world.CellIndexDirection;
import com.stek101.projectzulu.common.world.dataobjects.BlockWithMeta;
import com.stek101.projectzulu.common.world2.MazeCell;
import com.stek101.projectzulu.common.world2.blueprint.Blueprint;
import com.stek101.projectzulu.common.world2.blueprint.BlueprintSet;
import java.awt.Point;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;

public class BPSetPyramidEdge
implements BlueprintSet {
    final OuterEdge outerWall = new OuterEdge();
    final InnerEdge innerWall = new InnerEdge();

    @Override
    public boolean assignCellsWithBlueprints(MazeCell[][] cells, Point buildCoords, Random random) {
        String buildName = this.getIdentifier();
        buildName = buildCoords.x == 0 || buildCoords.y == 0 || buildCoords.x == cells.length - 1 || buildCoords.y == cells[0].length - 1 ? buildName.concat("-").concat(this.outerWall.getIdentifier()) : buildName.concat("-").concat(this.innerWall.getIdentifier());
        cells[buildCoords.x][buildCoords.y].setBuildingProperties(buildName, this.getDirection(cells, buildCoords));
        cells[buildCoords.x][buildCoords.y].rawState = -1;
        return true;
    }

    private CellIndexDirection getDirection(MazeCell[][] cells, Point buildCoords) {
        if (buildCoords.x == 0 && buildCoords.y == 0 || buildCoords.x == 1 && buildCoords.y == 1) {
            return CellIndexDirection.NorthWestCorner;
        }
        if (buildCoords.x == cells.length - 1 && buildCoords.y == 0 || buildCoords.x == cells.length - 2 && buildCoords.y == 1) {
            return CellIndexDirection.NorthEastCorner;
        }
        if (buildCoords.x == 0 && buildCoords.y == cells[0].length - 1 || buildCoords.x == 1 && buildCoords.y == cells[0].length - 2) {
            return CellIndexDirection.SouthWestCorner;
        }
        if (buildCoords.x == cells.length - 1 && buildCoords.y == cells[0].length - 1 || buildCoords.x == cells.length - 2 && buildCoords.y == cells[0].length - 2) {
            return CellIndexDirection.SouthEastCorner;
        }
        if (buildCoords.x == 0) {
            return CellIndexDirection.WestWall;
        }
        if (buildCoords.x == cells.length - 1) {
            return CellIndexDirection.EastWall;
        }
        if (buildCoords.y == 0) {
            return CellIndexDirection.NorthWall;
        }
        if (buildCoords.y == cells[0].length - 1) {
            return CellIndexDirection.SouthWall;
        }
        if (buildCoords.x == 1) {
            return CellIndexDirection.WestWall;
        }
        if (buildCoords.x == cells.length - 2) {
            return CellIndexDirection.EastWall;
        }
        if (buildCoords.y == 1) {
            return CellIndexDirection.NorthWall;
        }
        if (buildCoords.y == cells[0].length - 2) {
            return CellIndexDirection.SouthWall;
        }
        if (buildCoords.x <= 1) {
            return CellIndexDirection.WestWall;
        }
        if (buildCoords.x >= cells.length - 2) {
            return CellIndexDirection.EastWall;
        }
        if (buildCoords.y <= 1) {
            return CellIndexDirection.NorthWall;
        }
        if (buildCoords.y >= cells[0].length - 2) {
            return CellIndexDirection.SouthWall;
        }
        return null;
    }

    @Override
    public BlockWithMeta getBlockFromBlueprint(ChunkCoordinates piecePos, int cellSize, int cellHeight, CellIndexDirection cellIndexDirection, Random random, String buildingID) {
        String blueprintID = buildingID.split("-")[1];
        if (blueprintID.equals(this.outerWall.getIdentifier())) {
            return this.outerWall.getBlockFromBlueprint(piecePos, cellSize, cellHeight, random, cellIndexDirection);
        }
        if (blueprintID.equals(this.innerWall.getIdentifier())) {
            return this.innerWall.getBlockFromBlueprint(piecePos, cellSize, cellHeight, random, cellIndexDirection);
        }
        throw new IllegalArgumentException("Blueprint ID parsed from " + buildingID + " does not exist.");
    }

    @Override
    public boolean isApplicable(MazeCell[][] cells, Point buildCoords, Random random) {
        if (buildCoords.x <= 1 || buildCoords.y <= 1 || buildCoords.x >= cells.length - 2 || buildCoords.y >= cells[0].length - 2) {
            return cells[buildCoords.x][buildCoords.y].rawState >= 0;
        }
        return false;
    }

    @Override
    public String getIdentifier() {
        return "PyramidEdge";
    }

    @Override
    public int getWeight() {
        return 0;
    }

    private class InnerEdge
    implements Blueprint {
        private InnerEdge() {
        }

        @Override
        public BlockWithMeta getBlockFromBlueprint(ChunkCoordinates piecePos, int cellSize, int cellHeight, Random random, CellIndexDirection cellIndexDirection) {
            int index = 1;
            if (cellIndexDirection.isCorner()) {
                int posX = piecePos.field_71574_a;
                if (cellIndexDirection != CellIndexDirection.NorthWestCorner && cellIndexDirection != CellIndexDirection.SouthWestCorner) {
                    posX = cellSize - 1 - piecePos.field_71574_a;
                }
                int posZ = piecePos.field_71573_c;
                if (cellIndexDirection != CellIndexDirection.NorthWestCorner && cellIndexDirection != CellIndexDirection.NorthEastCorner) {
                    posZ = cellSize - 1 - piecePos.field_71573_c;
                }
                if (piecePos.field_71572_b > posZ + index * cellSize || piecePos.field_71572_b > posX + index * cellSize) {
                    return new BlockWithMeta(Blocks.field_150350_a);
                }
                if (piecePos.field_71572_b == posZ + index * cellSize || piecePos.field_71572_b == posX + index * cellSize) {
                    return new BlockWithMeta(Blocks.field_150322_A);
                }
            } else {
                int pos = -1;
                switch (cellIndexDirection) {
                    case NorthWall: {
                        pos = piecePos.field_71573_c;
                        break;
                    }
                    case SouthWall: {
                        pos = cellSize - 1 - piecePos.field_71573_c;
                        break;
                    }
                    case WestWall: {
                        pos = piecePos.field_71574_a;
                        break;
                    }
                    case EastWall: {
                        pos = cellSize - 1 - piecePos.field_71574_a;
                        break;
                    }
                    default: {
                        pos = -1;
                    }
                }
                if (pos > -1) {
                    if (piecePos.field_71572_b > pos + index * cellSize) {
                        return new BlockWithMeta(Blocks.field_150350_a);
                    }
                    if (piecePos.field_71572_b == pos + index * cellSize) {
                        return new BlockWithMeta(Blocks.field_150322_A);
                    }
                }
            }
            return new BlockWithMeta(Blocks.field_150322_A);
        }

        @Override
        public int getWeight() {
            return 1;
        }

        @Override
        public String getIdentifier() {
            return "InnerWall";
        }
    }

    private class OuterEdge
    implements Blueprint {
        private OuterEdge() {
        }

        @Override
        public BlockWithMeta getBlockFromBlueprint(ChunkCoordinates piecePos, int cellSize, int cellHeight, Random random, CellIndexDirection cellIndexDirection) {
            int index = 0;
            if (cellIndexDirection.isCorner()) {
                int posX = piecePos.field_71574_a;
                if (cellIndexDirection != CellIndexDirection.NorthWestCorner && cellIndexDirection != CellIndexDirection.SouthWestCorner) {
                    posX = cellSize - 1 - piecePos.field_71574_a;
                }
                int posZ = piecePos.field_71573_c;
                if (cellIndexDirection != CellIndexDirection.NorthWestCorner && cellIndexDirection != CellIndexDirection.NorthEastCorner) {
                    posZ = cellSize - 1 - piecePos.field_71573_c;
                }
                if (piecePos.field_71572_b > posZ + index * cellSize || piecePos.field_71572_b > posX + index * cellSize) {
                    return new BlockWithMeta(Blocks.field_150350_a);
                }
                if (piecePos.field_71572_b == posZ + index * cellSize || piecePos.field_71572_b == posX + index * cellSize) {
                    return new BlockWithMeta(Blocks.field_150322_A);
                }
            } else {
                int pos = -1;
                switch (cellIndexDirection) {
                    case NorthWall: {
                        pos = piecePos.field_71573_c;
                        break;
                    }
                    case SouthWall: {
                        pos = cellSize - 1 - piecePos.field_71573_c;
                        break;
                    }
                    case WestWall: {
                        pos = piecePos.field_71574_a;
                        break;
                    }
                    case EastWall: {
                        pos = cellSize - 1 - piecePos.field_71574_a;
                        break;
                    }
                    default: {
                        pos = -1;
                    }
                }
                if (pos > -1) {
                    if (piecePos.field_71572_b > pos + index * cellSize) {
                        return new BlockWithMeta(Blocks.field_150350_a);
                    }
                    if (piecePos.field_71572_b == pos + index * cellSize) {
                        return new BlockWithMeta(Blocks.field_150322_A);
                    }
                }
            }
            return new BlockWithMeta(Blocks.field_150322_A);
        }

        @Override
        public int getWeight() {
            return 1;
        }

        @Override
        public String getIdentifier() {
            return "OuterWall";
        }
    }
}

