/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world2.blueprint;

import com.stek101.projectzulu.common.world.CellIndexDirection;
import com.stek101.projectzulu.common.world.dataobjects.BlockWithMeta;
import com.stek101.projectzulu.common.world2.MazeCell;
import com.stek101.projectzulu.common.world2.blueprint.Blueprint;
import com.stek101.projectzulu.common.world2.blueprint.BlueprintSet;
import java.awt.Point;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;

public class BPSetStairs
implements BlueprintSet,
Blueprint {
    BlockWithMeta floorblock = new BlockWithMeta(Blocks.field_150322_A);

    @Override
    public String getIdentifier() {
        return "stairs";
    }

    @Override
    public int getWeight() {
        return 0;
    }

    public boolean attemptAssignBlueprint(MazeCell[][] bottomFloor, MazeCell[][] topFloor, Point buildCoords, Random rand) {
        if (topFloor[buildCoords.x][buildCoords.y].rawState == 0 && topFloor[buildCoords.x][buildCoords.y + 1].rawState >= 0) {
            Point botCoords = this.convertCellCoords(buildCoords.x, buildCoords.y, topFloor, bottomFloor);
            if (bottomFloor[botCoords.x][botCoords.y - 1].rawState == 0 && bottomFloor[botCoords.x][botCoords.y].rawState == 1 && bottomFloor[botCoords.x][botCoords.y + 1].rawState == 1 && rand.nextInt(1) == 0) {
                topFloor[buildCoords.x][buildCoords.y].setBuildingProperties(this.getIdentifier() + "-top_1", CellIndexDirection.Middle);
                topFloor[buildCoords.x][buildCoords.y].rawState = -1;
                topFloor[buildCoords.x][buildCoords.y + 1].setBuildingProperties(this.getIdentifier() + "-top_2", CellIndexDirection.Middle);
                topFloor[buildCoords.x][buildCoords.y + 1].rawState = -1;
                bottomFloor[botCoords.x][botCoords.y].setBuildingProperties(this.getIdentifier() + "-bottom_1", CellIndexDirection.Middle);
                bottomFloor[botCoords.x][botCoords.y].rawState = -1;
                bottomFloor[botCoords.x][botCoords.y + 1].setBuildingProperties(this.getIdentifier() + "-bottom_2", CellIndexDirection.Middle);
                bottomFloor[botCoords.x][botCoords.y + 1].rawState = -1;
                return true;
            }
        }
        return false;
    }

    private Point convertCellCoords(int originX, int originY, MazeCell[][] originCells, MazeCell[][] destinCells) {
        ChunkCoordinates chunkCoords = originCells[originX][originY].initialPos;
        for (int i = 0; i < destinCells.length; ++i) {
            for (int j = 0; j < destinCells[0].length; ++j) {
                if (chunkCoords.field_71574_a != destinCells[i][j].initialPos.field_71574_a || chunkCoords.field_71573_c != destinCells[i][j].initialPos.field_71573_c) continue;
                return new Point(i, j);
            }
        }
        return new Point(-1, -1);
    }

    @Override
    public BlockWithMeta getBlockFromBlueprint(ChunkCoordinates piecePos, int cellSize, int cellHeight, CellIndexDirection cellIndexDirection, Random random, String buildingID) {
        String[] subIndex = buildingID.split("-")[1].split("_");
        if (subIndex[0].equalsIgnoreCase("bottom")) {
            return this.getBottomStairBlock(piecePos, cellSize, cellHeight, cellIndexDirection, random, Integer.parseInt(subIndex[1]));
        }
        if (subIndex[0].equalsIgnoreCase("top")) {
            return this.getTopStairBlock(piecePos, cellSize, cellHeight, cellIndexDirection, random, Integer.parseInt(subIndex[1]));
        }
        return new BlockWithMeta(Blocks.field_150350_a);
    }

    public BlockWithMeta getBottomStairBlock(ChunkCoordinates piecePos, int cellSize, int cellHeight, CellIndexDirection cellIndexDirection, Random random, int index) {
        --index;
        if (piecePos.field_71572_b == 0) {
            return new BlockWithMeta(Blocks.field_150322_A);
        }
        if (piecePos.field_71574_a == 0) {
            if (piecePos.field_71572_b > piecePos.field_71573_c + 1 + index * cellSize) {
                return new BlockWithMeta(Blocks.field_150350_a);
            }
            if (piecePos.field_71572_b == piecePos.field_71573_c + 1 + index * cellSize) {
                return new BlockWithMeta(Blocks.field_150372_bz, 2);
            }
            return new BlockWithMeta(Blocks.field_150322_A);
        }
        return new BlockWithMeta(Blocks.field_150350_a);
    }

    public BlockWithMeta getTopStairBlock(ChunkCoordinates piecePos, int cellSize, int cellHeight, CellIndexDirection cellIndexDirection, Random random, int index) {
        boolean requiresStairs = index != 1;
        index += cellSize - cellHeight - 2;
        if (piecePos.field_71572_b == 0) {
            if (piecePos.field_71574_a != 0) {
                return new BlockWithMeta(Blocks.field_150322_A);
            }
            if (requiresStairs && piecePos.field_71572_b == piecePos.field_71573_c + 1 + index) {
                return new BlockWithMeta(Blocks.field_150372_bz, 2);
            }
            if (requiresStairs && piecePos.field_71572_b < piecePos.field_71573_c + 1 + index) {
                return new BlockWithMeta(Blocks.field_150322_A);
            }
        }
        return new BlockWithMeta(Blocks.field_150350_a);
    }

    @Override
    public boolean assignCellsWithBlueprints(MazeCell[][] cells, Point buildCoords, Random random) {
        return false;
    }

    @Override
    public boolean isApplicable(MazeCell[][] cells, Point buildCoords, Random random) {
        return false;
    }

    @Override
    public BlockWithMeta getBlockFromBlueprint(ChunkCoordinates piecePos, int cellSize, int cellHeight, Random random, CellIndexDirection cellIndexDirection) {
        throw new UnsupportedOperationException();
    }
}

