/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world2.blueprint;

import com.stek101.projectzulu.common.ProjectZulu_Core;
import com.stek101.projectzulu.common.world.CellIndexDirection;
import com.stek101.projectzulu.common.world.dataobjects.BlockWithMeta;
import com.stek101.projectzulu.common.world.dataobjects.ChestWithMeta;
import com.stek101.projectzulu.common.world.dataobjects.MimicWithMeta;
import com.stek101.projectzulu.common.world.terrain.PyramidFeature;
import com.stek101.projectzulu.common.world2.MazeCell;
import com.stek101.projectzulu.common.world2.architect.ArchitectBase;
import com.stek101.projectzulu.common.world2.blueprint.Blueprint;
import com.stek101.projectzulu.common.world2.blueprint.BlueprintSet;
import java.awt.Point;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ChunkCoordinates;

public class BPSetTreasureDeadEnd
implements BlueprintSet,
Blueprint {
    BlockWithMeta floorblock = new BlockWithMeta(Blocks.field_150322_A);

    @Override
    public String getIdentifier() {
        return "deadend";
    }

    @Override
    public int getWeight() {
        return 50;
    }

    @Override
    public boolean assignCellsWithBlueprints(MazeCell[][] cells, Point buildCoords, Random random) {
        cells[buildCoords.x][buildCoords.y].setBuildingProperties(this.getIdentifier(), CellIndexDirection.Middle);
        cells[buildCoords.x][buildCoords.y].rawState = 2;
        return true;
    }

    @Override
    public boolean isApplicable(MazeCell[][] cells, Point buildCoords, Random random) {
        return cells[buildCoords.x][buildCoords.y].rawState == 0 && ArchitectBase.isDeadEnd(cells, buildCoords, 1, -1) != false;
    }

    @Override
    public BlockWithMeta getBlockFromBlueprint(ChunkCoordinates piecePos, int cellSize, int cellHeight, CellIndexDirection cellIndexDirection, Random random, String buildingID) {
        return this.getBlockFromBlueprint(piecePos, cellSize, cellHeight, random, cellIndexDirection);
    }

    @Override
    public BlockWithMeta getBlockFromBlueprint(ChunkCoordinates piecePos, int cellSize, int cellHeight, Random random, CellIndexDirection cellIndexDirection) {
        if (piecePos.field_71572_b == 0) {
            return this.floorblock;
        }
        if (piecePos.field_71572_b == 1) {
            if (random.nextInt(5) == 0) {
                PyramidFeature terrainFeature = (PyramidFeature)ProjectZulu_Core.featureGenerator.getRegisteredStructure("Pyramid");
                return new ChestWithMeta((Block)Blocks.field_150486_ae, 0, new TileEntityChest(), terrainFeature.chestLootChance, terrainFeature.chestMaxLoot);
            }
            if (random.nextInt(4) == 0) {
                return new MimicWithMeta();
            }
        }
        return new BlockWithMeta(Blocks.field_150350_a);
    }
}

