/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world2.buildingmanager;

import com.stek101.projectzulu.common.core.terrain.TerrainFeature;
import com.stek101.projectzulu.common.world2.MazeCell;
import com.stek101.projectzulu.common.world2.architect.ArchitectOasis;
import com.stek101.projectzulu.common.world2.buildingmanager.BuildingManagerBase;
import com.stek101.projectzulu.common.world2.randomizer.EdgeRandomizer;
import com.stek101.projectzulu.common.world2.randomizer.Randomizer;
import java.awt.Point;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class BuildingManagerOasis
extends BuildingManagerBase {
    public ArchitectOasis architect;
    public Randomizer randomizer;
    MazeCell[][] oasis;

    public BuildingManagerOasis(World world, TerrainFeature.FeatureDirection direction, ChunkCoordinates startingPos, int xCells, int zCells, int cellSize) {
        super(world);
        int cellHeight = 4;
        this.randomizer = new EdgeRandomizer(world, 2);
        this.architect = new ArchitectOasis(world);
        startingPos = this.calcTranslatedPosition(direction, startingPos, xCells * cellSize, zCells * cellSize, cellHeight);
        this.oasis = new MazeCell[xCells][zCells];
        for (int i = 0; i < this.oasis.length; ++i) {
            for (int j = 0; j < this.oasis[0].length; ++j) {
                this.oasis[i][j] = new MazeCell(cellSize, cellHeight, new ChunkCoordinates(startingPos.field_71574_a + cellSize * i, startingPos.field_71572_b, startingPos.field_71573_c + cellSize * j));
            }
        }
    }

    @Override
    protected void randomizeCells() {
        this.randomizer.randomize(this.oasis);
    }

    @Override
    protected void assignBlueprints(int pass, int maxPass) {
        if (pass == maxPass) {
            for (int cellX = 0; cellX < this.oasis.length; ++cellX) {
                for (int cellZ = 0; cellZ < this.oasis[0].length; ++cellZ) {
                    this.architect.assignBlueprint(this.oasis, new Point(cellX, cellZ), pass, maxPass);
                }
            }
        }
    }

    @Override
    protected void construct() {
        for (int cellX = 0; cellX < this.oasis.length; ++cellX) {
            for (int cellZ = 0; cellZ < this.oasis[0].length; ++cellZ) {
                MazeCell currentCell = this.oasis[cellX][cellZ];
                this.processCellPieces(currentCell, this.architect);
            }
        }
    }
}

