/*
 * Decompiled with CFR 0.152.
 */
package com.supercat765.MazeMod;

import com.supercat765.MazeMod.Biomes.BiomeGenMaze;
import com.supercat765.MazeMod.Blocks.BlockLight;
import com.supercat765.MazeMod.Blocks.BlockSunLight;
import com.supercat765.MazeMod.Blocks.TileEntityBlockLight;
import com.supercat765.MazeMod.Items.ItemMazeLocationeer;
import com.supercat765.MazeMod.Items.ItemMazeTransporter;
import com.supercat765.MazeMod.Items.ItemMobSpawner;
import com.supercat765.MazeMod.MazeModEventHandler;
import com.supercat765.MazeMod.Mobs.EntityMiniDragon;
import com.supercat765.MazeMod.Mobs.EntityMiniWither;
import com.supercat765.MazeMod.Mobs.SpawnEntityInfo;
import com.supercat765.MazeMod.RandomDimID;
import com.supercat765.MazeMod.WorldGen.GenMaze;
import com.supercat765.MazeMod.WorldGen.WorldProviderMaze;
import com.supercat765.MazeMod.proxy.CommonProxy;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="mazemod", name="Maze Mod", version="1.1.0")
public class MazeMod {
    public static final String MODID = "mazemod";
    public static final String VERSION = "1.1.0";
    public static Configuration config;
    public static int MazeLayers;
    public static int SchunkSize;
    public static int[] DimIDs;
    public static List<WeightedRandom.Item> ListDimIDs;
    @Mod.Instance(value="MazeMod")
    public static MazeMod instance;
    public static SpawnEntityInfo[] MobSpawns;
    @SidedProxy(clientSide="com.supercat765.MazeMod.proxy.ClientProxy", serverSide="com.supercat765.MazeMod.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static Item MobSpawner;
    public static int DimID;
    public static int BiomeID;
    public static HashMap<String, BiomeGenMaze> Biomes;
    public static Item Transporter;
    public static Item Locationeer;
    public static Block CarpetLight;
    public static Block[] CarpetSunLights;

    @Mod.EventHandler
    public void load(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        MazeMod.syncConfig();
        MazeMod.addBiome("Bedrock Maze");
        MazeMod.addBiome("Dungeon Maze");
        MazeMod.addBiome("Stronghold Maze");
        MazeMod.addBiome("Quartz Maze");
        MazeMod.addBiome("Cave Maze");
        MazeMod.addBiome("Flooded Maze");
        MazeMod.addBiome("Peaceful Maze");
        MazeMod.addBiome("Rainbow Maze");
        MazeMod.addBiome("Mesa Maze");
        MazeMod.addBiome("Desert Maze");
        MazeMod.addBiome("Ice Maze");
        MazeMod.addBiome("Firey Maze");
        MazeMod.addBiome("Withering Maze");
        MazeMod.addBiome("Ender Maze");
        MazeMod.addBiome("Precious Maze");
        MazeMod.addBiome("Forest Maze");
        MazeMod.addBiome("Village Maze");
        MazeMod.addBiome("Swampy Maze");
        MinecraftForge.EVENT_BUS.register((Object)new MazeModEventHandler());
        Transporter = new ItemMazeTransporter().func_77655_b("Transporter");
        GameRegistry.registerItem((Item)Transporter, (String)"Transporter");
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Transporter), (Object[])new Object[]{"prp", "ipi", "pdp", Character.valueOf('p'), Items.field_151079_bi, Character.valueOf('d'), Items.field_151045_i, Character.valueOf('i'), Items.field_151042_j, Character.valueOf('r'), Items.field_151137_ax});
        Locationeer = new ItemMazeLocationeer().func_77655_b("Locationeer");
        GameRegistry.registerItem((Item)Locationeer, (String)"Locationeer");
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Locationeer), (Object[])new Object[]{"ere", "gMg", "pTp", Character.valueOf('e'), Items.field_151166_bC, Character.valueOf('p'), Items.field_151079_bi, Character.valueOf('M'), Items.field_151148_bJ, Character.valueOf('g'), Items.field_151043_k, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('T'), Transporter});
        MobSpawner = new ItemMobSpawner().func_77655_b("ItemMobSpawner");
        GameRegistry.registerItem((Item)MobSpawner, (String)"ItemMobSpawner");
        GameRegistry.registerWorldGenerator((IWorldGenerator)new GenMaze(), (int)8);
        DimensionManager.registerProviderType((int)DimID, WorldProviderMaze.class, (boolean)true);
        DimensionManager.registerDimension((int)DimID, (int)DimID);
        CarpetLight = new BlockLight();
        GameRegistry.registerBlock((Block)CarpetLight, (String)"Light");
        CarpetLight.func_149647_a(CreativeTabs.field_78031_c);
        CarpetSunLights = new Block[2];
        MazeMod.CarpetSunLights[0] = new BlockSunLight(0);
        GameRegistry.registerBlock((Block)CarpetSunLights[0], (String)"SunLight");
        MazeMod.CarpetSunLights[1] = new BlockSunLight(15);
        GameRegistry.registerBlock((Block)CarpetSunLights[1], (String)"SunLight_Lit");
        CarpetSunLights[0].func_149647_a(CreativeTabs.field_78031_c);
        GameRegistry.registerTileEntity(TileEntityBlockLight.class, (String)"TEBlockLight");
        MazeMod.getBiome("Ender Maze").clearSpawns();
        MazeMod.getBiome("Ender Maze").AddSpawns(BiomeGenBase.field_76779_k);
        MazeMod.getBiome("Ender Maze").AddSpawnMonster(EntityEnderman.class, 100, 5, 10);
        MazeMod.getBiome("Ender Maze").AddSpawnCreature(EntityEnderman.class, 100, 5, 10);
        MazeMod.getBiome("Ender Maze").AddSpawnMonster(EntityMiniDragon.class, 1, 5, 10);
        MazeMod.getBiome("Firey Maze").clearSpawns();
        MazeMod.getBiome("Firey Maze").AddSpawns(BiomeGenBase.field_76778_j);
        MazeMod.getBiome("Flooded Maze").AddSpawns(BiomeGenBase.field_150575_M);
        MazeMod.getBiome("Flooded Maze").AddSpawnWater(EntitySquid.class, 100, 5, 10);
        MazeMod.getBiome("Peaceful Maze").clearSpawns();
        MazeMod.getBiome("Peaceful Maze").AddSpawnCreature(EntityCow.class, 100, 2, 4);
        MazeMod.getBiome("Peaceful Maze").AddSpawnCreature(EntityPig.class, 100, 2, 4);
        MazeMod.getBiome("Peaceful Maze").AddSpawnCreature(EntitySheep.class, 100, 2, 4);
        MazeMod.getBiome("Peaceful Maze").AddSpawnCreature(EntityChicken.class, 100, 5, 10);
        MazeMod.getBiome("Peaceful Maze").AddSpawnCreature(EntityHorse.class, 20, 1, 3);
        MazeMod.getBiome("Village Maze").AddSpawnCreature(EntityVillager.class, 20, 1, 3);
        MazeMod.getBiome("Swampy Maze").AddSpawnMonster(EntitySlime.class, 100, 3, 6);
        MazeMod.getBiome("Swampy Maze").AddSpawnMonster(EntityWitch.class, 100, 3, 6);
        MazeMod.getBiome("Forest Maze").AddSpawnMonster(EntitySpider.class, 100, 3, 6);
        MazeMod.getBiome("Forest Maze").AddSpawnMonster(EntityCaveSpider.class, 100, 8, 10);
        MazeMod.getBiome("Withering Maze").clearSpawns();
        MazeMod.getBiome("Withering Maze").AddSpawnMonster(EntitySkeleton.class, 100, 3, 6);
        MazeMod.getBiome("Withering Maze").AddSpawnCreature(EntitySkeleton.class, 100, 3, 6);
        MazeMod.getBiome("Withering Maze").AddSpawnMonster(EntityMiniWither.class, 1, 3, 6);
        this.addMob(0, 0, EntityMiniDragon.class, "MiniEnderDragon", MazeMod.RGBtoInt(255, 255, 255), MazeMod.RGBtoInt(255, 200, 200), 0);
        this.addMob(1, 0, EntityMiniWither.class, "MiniWither", MazeMod.RGBtoInt(255, 255, 255), MazeMod.RGBtoInt(255, 200, 200), 1);
        proxy.registerRenderers();
    }

    public static int RGBtoInt(int R, int G, int B) {
        return (R << 16) + (G << 8) + B;
    }

    public void addMob(int id, int biome, Class EntityClass, String Name, int ColorA, int ColorB, int Eggtype) {
        EntityRegistry.registerModEntity((Class)EntityClass, (String)Name, (int)id, (Object)this, (int)80, (int)3, (boolean)true);
        if (biome != -1) {
            MazeMod.MobSpawns[id] = new SpawnEntityInfo(EntityClass, Name, biome, ColorA, ColorB, Eggtype);
        }
    }

    public static void addBiome(String name) {
        Biomes.put(name, (BiomeGenMaze)new BiomeGenMaze(MazeMod.getNextBiomeID(name)).func_76735_a(name));
    }

    private static int getNextBiomeID(String name) {
        int out = config.get("BiomeIDs", name, BiomeID).getInt();
        ++BiomeID;
        if (config.hasChanged()) {
            config.save();
        }
        return out;
    }

    public static BiomeGenMaze getBiome(String name) {
        return Biomes.get(name);
    }

    public static void syncConfig() {
        DimID = config.get("general", "MazeDimID", 2).getInt();
        MazeLayers = config.getInt("Layers", "general", 6, 2, 40, "Layers in Maze");
        SchunkSize = config.getInt("SchunkSize", "general", 90, 1, 600, "Super Chunk size(measured in chunks)");
        DimIDs = config.get("general", "Travelable Dimensions", new int[]{0, 100, -1, 30, 1, 10}, "DimID and then weight").getIntList();
        ListDimIDs = new ArrayList<WeightedRandom.Item>();
        int a = 0;
        while (a + 1 < DimIDs.length) {
            ListDimIDs.add(new RandomDimID(DimIDs[a], DimIDs[a + 1]));
            ++a;
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        ListDimIDs = new ArrayList<WeightedRandom.Item>();
        MobSpawns = new SpawnEntityInfo[255];
        DimID = 2;
        BiomeID = 40;
        Biomes = new HashMap();
    }
}

