/*
 * Decompiled with CFR 0.152.
 */
package com.supercat765.MazeMod.WorldGen;

import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class MazeSegmentInfo {
    int x;
    int z;
    int y;
    float numba;
    float numbx;
    float numbz;
    float numbx2;
    float numbz2;
    float distx;
    float distz;
    float distx2;
    float distz2;
    boolean stairsUP;
    boolean stairsDN;
    BiomeGenBase Biome;
    World world;
    int layer;
    int chunkX;
    int chunkZ;
    BiomeGenBase BiomeX;
    BiomeGenBase BiomeZ;
    BiomeGenBase BiomeX2;
    BiomeGenBase BiomeZ2;

    public MazeSegmentInfo(World world, int chunkX, int chunkZ, int layer) {
        this.world = world;
        this.layer = layer;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.x = chunkX * 8;
        this.z = chunkZ * 8;
        this.y = 4 + 6 * layer;
        this.numba = this.GetNum(world, chunkX, chunkZ, layer);
        this.numbx = this.GetNum(world, chunkX + 1, chunkZ, layer);
        this.numbz = this.GetNum(world, chunkX, chunkZ + 1, layer);
        this.numbx2 = this.GetNum(world, chunkX - 1, chunkZ, layer);
        this.numbz2 = this.GetNum(world, chunkX, chunkZ - 1, layer);
        this.distx = Math.max(this.numba, this.numbx) - Math.min(this.numba, this.numbx);
        this.distz = Math.max(this.numba, this.numbz) - Math.min(this.numba, this.numbz);
        this.distx2 = Math.max(this.numba, this.numbx2) - Math.min(this.numba, this.numbx2);
        this.distz2 = Math.max(this.numba, this.numbz2) - Math.min(this.numba, this.numbz2);
        int walls = 0;
        if ((double)this.distx < 0.2) {
            ++walls;
        }
        if ((double)this.distz < 0.2) {
            ++walls;
        }
        if ((double)this.distx2 < 0.2) {
            ++walls;
        }
        if ((double)this.distz2 < 0.2) {
            ++walls;
        }
        if (walls == 3) {
            Random random = this.getRandomiser(new long[]{world.func_72905_C(), chunkX, 38645L, chunkZ, 42870L, layer, 98712L});
            this.stairsUP = random.nextInt(10) == 0;
            this.stairsDN = random.nextInt(10) == 0;
        } else if (walls == 4) {
            this.stairsUP = true;
            this.stairsDN = true;
        } else {
            this.stairsUP = false;
            this.stairsDN = false;
        }
        this.Biome = this.getBiome(world, chunkX, chunkZ, layer);
        this.BiomeX = this.getBiome(world, chunkX + 1, chunkZ, layer);
        this.BiomeZ = this.getBiome(world, chunkX, chunkZ + 1, layer);
        this.BiomeX2 = this.getBiome(world, chunkX - 1, chunkZ, layer);
        this.BiomeZ2 = this.getBiome(world, chunkX, chunkZ - 1, layer);
    }

    private float GetNum(World world, int chunkX, int chunkZ, int layer) {
        Random random = this.getRandomiser(new long[]{world.func_72905_C(), chunkX, 38645L, chunkZ, 42870L, layer, 98712L});
        return random.nextFloat();
    }

    private Random getRandomiser(long[] n) {
        Random random = new Random();
        random.setSeed(n[0]);
        for (int a = 1; a < n.length; a += 2) {
            random.setSeed(random.nextLong() + n[a] * n[a + 1]);
        }
        return random;
    }

    private BiomeGenBase getBiome(World world, int chunkX, int chunkZ, int layer) {
        Random random = this.getRandomiser(new long[]{world.func_72905_C(), chunkX, 44556L, chunkZ, 991149L, layer, 22488L});
        int x = chunkX * 8 + 1;
        int z = chunkZ * 8 + 1;
        return world.func_72807_a(x + random.nextInt(8), z + random.nextInt(8));
    }
}

