/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import net.malisis.core.IMalisisMod;
import net.malisis.core.MalisisCommand;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.configuration.ConfigurationGui;
import net.malisis.core.configuration.Settings;
import net.malisis.core.network.MalisisNetwork;
import net.malisis.core.tileentity.MultiBlockTileEntity;
import net.malisis.core.util.chunkblock.ChunkBlockHandler;
import net.malisis.core.util.finiteliquid.FiniteLiquid;
import net.malisis.core.util.finiteliquid.FiniteLiquidRenderer;
import net.malisis.core.util.replacement.ReplacementTool;
import net.malisis.core.util.syncer.Syncer;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Logger;

@Mod(modid="malisiscore", name="Malisis Core", version="1.7.10-0.12.9")
public class MalisisCore
implements IMalisisMod {
    public static final String modid = "malisiscore";
    public static final String modname = "Malisis Core";
    public static final String version = "1.7.10-0.12.9";
    public static final String url = "";
    public static File coremodLocation;
    public static MalisisCore instance;
    public static Logger log;
    public static MalisisNetwork network;
    private HashMap<String, IMalisisMod> registeredMods = new HashMap();
    public static boolean isObfEnv;

    public MalisisCore() {
        instance = this;
        network = new MalisisNetwork(this);
    }

    @Override
    public String getModId() {
        return modid;
    }

    @Override
    public String getName() {
        return modname;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Settings getSettings() {
        return null;
    }

    public static void registerMod(IMalisisMod mod) {
        MalisisCore.instance.registeredMods.put(mod.getModId(), mod);
    }

    public static IMalisisMod getMod(String id) {
        return MalisisCore.instance.registeredMods.get(id);
    }

    public static Set<String> listModId() {
        return MalisisCore.instance.registeredMods.keySet();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)instance);
        MinecraftForge.EVENT_BUS.register((Object)ReplacementTool.instance());
        MinecraftForge.EVENT_BUS.register((Object)ChunkBlockHandler.get());
        log = event.getModLog();
        GameRegistry.registerTileEntity(MultiBlockTileEntity.class, (String)"MalisisCoreMultiBlockTileEntity");
        MalisisNetwork.createMessages(event.getAsmData());
        Syncer.get().discover(event.getAsmData());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ClientCommandHandler.instance.func_71560_a((ICommand)new MalisisCommand());
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            new FiniteLiquidRenderer().registerFor(FiniteLiquid.class);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onGuiClose(GuiOpenEvent event) {
        if (!MalisisGui.cancelClose || event.gui != null) {
            return;
        }
        MalisisGui.cancelClose = false;
        event.setCanceled(true);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean openConfigurationGui(IMalisisMod mod) {
        Settings settings = mod.getSettings();
        if (settings == null) {
            return false;
        }
        new ConfigurationGui(settings).display(true);
        return true;
    }

    public static void message(Object text) {
        MalisisCore.message(text, new Object[]{null});
    }

    public static void message(Object text, Object ... data) {
        if (text == null) {
            return;
        }
        String txt = text.toString();
        if (text instanceof Object[]) {
            txt = Arrays.deepToString((Object[])text);
        }
        ChatComponentText msg = new ChatComponentText(StatCollector.func_74837_a((String)txt, (Object[])data));
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            MinecraftServer server = MinecraftServer.func_71276_C();
            if (server != null) {
                server.func_71203_ab().func_148539_a((IChatComponent)msg);
            }
        } else {
            if (Minecraft.func_71410_x() == null || Minecraft.func_71410_x().field_71439_g == null) {
                return;
            }
            ChatStyle cs = new ChatStyle();
            cs.func_150217_b(Boolean.valueOf(true));
            cs.func_150238_a(EnumChatFormatting.GRAY);
            msg.func_150255_a(cs);
            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)msg);
        }
    }

    static {
        isObfEnv = false;
    }
}

