/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IBoundingBox;
import net.malisis.core.util.Point;
import net.malisis.core.util.Ray;
import net.malisis.core.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RaytraceBlock {
    private static RaytraceBlock instance = new RaytraceBlock();
    private WeakReference<World> world;
    private int x;
    private int y;
    private int z;
    private Block block;
    private Point src;
    private Point dest;
    private Ray ray;
    List<Point> points = new ArrayList<Point>();

    private RaytraceBlock() {
    }

    private void _set(World world, Ray ray, int x, int y, int z) {
        this.world = new WeakReference<World>(world);
        this.src = ray.origin;
        this.ray = ray;
        this.x = x;
        this.y = y;
        this.z = z;
        this.block = this.world().func_147439_a(x, y, z);
    }

    public static RaytraceBlock set(World world, Ray ray, int x, int y, int z) {
        instance._set(world, ray, x, y, z);
        return instance;
    }

    public static RaytraceBlock set(World world, Point src, Vector v, int x, int y, int z) {
        instance._set(world, new Ray(src, v), x, y, z);
        return instance;
    }

    public static RaytraceBlock set(World world, Point src, Point dest, int x, int y, int z) {
        RaytraceBlock.instance.dest = dest;
        instance._set(world, new Ray(src, new Vector(src, dest)), x, y, z);
        return instance;
    }

    public static RaytraceBlock set(World world, Vec3 src, Vec3 dest, int x, int y, int z) {
        RaytraceBlock.instance.dest = new Point(dest);
        instance._set(world, new Ray(src, dest), x, y, z);
        return instance;
    }

    public World world() {
        return (World)this.world.get();
    }

    public Vector direction() {
        return this.ray.direction;
    }

    public double distance() {
        return this.ray.direction.length();
    }

    public MovingObjectPosition trace() {
        this.points.clear();
        if (!(this.block instanceof IBoundingBox)) {
            return this.block.func_149731_a(this.world(), this.x, this.y, this.z, this.ray.origin.toVec3(), this.dest.toVec3());
        }
        IBoundingBox block = (IBoundingBox)this.block;
        AxisAlignedBB[] aabbs = block.getBoundingBox((IBlockAccess)this.world(), this.x, this.y, this.z, BoundingBoxType.RAYTRACE);
        double maxDist = Point.distanceSquared(this.src, this.dest);
        for (AxisAlignedBB aabb : aabbs) {
            if (aabb == null) continue;
            aabb.func_72317_d((double)this.x, (double)this.y, (double)this.z);
            for (Point p : this.ray.intersect(aabb)) {
                if (!(Point.distanceSquared(this.src, p) < maxDist)) continue;
                this.points.add(p);
            }
        }
        if (this.points.size() == 0) {
            return null;
        }
        Point closest = this.getClosest(this.points);
        ForgeDirection side = this.getSide(aabbs, closest);
        return new MovingObjectPosition(this.x, this.y, this.z, side.ordinal(), closest.toVec3());
    }

    private Point getClosest(List<Point> points) {
        double distance = Double.MAX_VALUE;
        Point ret = null;
        for (Point p : points) {
            double d = Point.distanceSquared(this.src, p);
            if (!(distance > d)) continue;
            distance = d;
            ret = p;
        }
        return ret;
    }

    private ForgeDirection getSide(AxisAlignedBB[] aabbs, Point point) {
        for (AxisAlignedBB aabb : aabbs) {
            if (aabb == null) continue;
            if (point.x == aabb.field_72340_a) {
                return ForgeDirection.WEST;
            }
            if (point.x == aabb.field_72336_d) {
                return ForgeDirection.EAST;
            }
            if (point.y == aabb.field_72338_b) {
                return ForgeDirection.DOWN;
            }
            if (point.y == aabb.field_72337_e) {
                return ForgeDirection.UP;
            }
            if (point.z == aabb.field_72339_c) {
                return ForgeDirection.NORTH;
            }
            if (point.z != aabb.field_72334_f) continue;
            return ForgeDirection.SOUTH;
        }
        return ForgeDirection.UNKNOWN;
    }
}

