/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.chunkcollision;

import java.util.List;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.BlockPos;
import net.malisis.core.util.BlockState;
import net.malisis.core.util.Point;
import net.malisis.core.util.RaytraceBlock;
import net.malisis.core.util.chunkblock.ChunkBlockHandler;
import net.malisis.core.util.chunkcollision.IChunkCollidable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class ChunkCollision {
    private static ChunkCollision instance = new ChunkCollision();
    private Point src;
    private Point dest;

    public void getCollisionBoundingBoxes(World world, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity entity) {
        CollisionProcedure procedure = new CollisionProcedure(mask, list);
        for (Chunk chunk : ChunkBlockHandler.getAffectedChunks(world, mask)) {
            ChunkBlockHandler.get().callProcedure(chunk, procedure);
        }
    }

    public void setRayTraceInfos(Vec3 src, Vec3 dest) {
        if (src == null || dest == null) {
            return;
        }
        this.setRayTraceInfos(new Point(src), new Point(dest));
    }

    public void setRayTraceInfos(Point src, Point dest) {
        this.src = src;
        this.dest = dest;
    }

    public MovingObjectPosition getRayTraceResult(World world, MovingObjectPosition mop) {
        if (this.src == null || this.dest == null) {
            return mop;
        }
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)this.src.x, (double)this.src.y, (double)this.src.z, (double)this.dest.x, (double)this.dest.y, (double)this.dest.z);
        AABBUtils.fix(aabb);
        RayTraceProcedure procedure = new RayTraceProcedure(this.src, this.dest, mop);
        for (Chunk chunk : ChunkBlockHandler.getAffectedChunks(world, aabb)) {
            ChunkBlockHandler.get().callProcedure(chunk, procedure);
        }
        return procedure.mop;
    }

    private MovingObjectPosition getClosest(Point src, MovingObjectPosition mop1, MovingObjectPosition mop2) {
        if (mop1 == null) {
            return mop2;
        }
        if (mop2 == null) {
            return mop1;
        }
        if (mop1.field_72313_a == MovingObjectPosition.MovingObjectType.MISS && mop2.field_72313_a != MovingObjectPosition.MovingObjectType.MISS) {
            return mop2;
        }
        if (mop1.field_72313_a != MovingObjectPosition.MovingObjectType.MISS && mop2.field_72313_a == MovingObjectPosition.MovingObjectType.MISS) {
            return mop1;
        }
        Point point = new Point(mop1.field_72307_f);
        Point point2 = new Point(mop2.field_72307_f);
        if (Point.distanceSquared(src, point) > Point.distanceSquared(src, point2)) {
            return mop2;
        }
        return mop1;
    }

    public boolean canPlaceBlockAt(ItemStack itemStack, EntityPlayer player, World world, Block block, int x, int y, int z, int side) {
        AxisAlignedBB[] aabbs = block instanceof IChunkCollidable ? ((IChunkCollidable)block).getPlacedBoundingBox((IBlockAccess)world, x, y, z, side, player, itemStack) : AABBUtils.getCollisionBoundingBoxes(world, block, x, y, z);
        if (aabbs == null) {
            return true;
        }
        AABBUtils.offset(x, y, z, aabbs);
        if (block instanceof IChunkCollidable) {
            for (AxisAlignedBB aabb : aabbs) {
                for (BlockPos pos : BlockPos.getAllInBox(aabb)) {
                    boolean b = false;
                    b |= !world.func_147439_a(pos.getX(), pos.getY(), pos.getZ()).isReplaceable((IBlockAccess)world, pos.getX(), pos.getY(), pos.getZ());
                    if (!(b &= AABBUtils.isColliding(aabb, AABBUtils.getCollisionBoundingBoxes(world, new BlockState((IBlockAccess)world, pos), true)))) continue;
                    return false;
                }
            }
        }
        CheckCollisionProcedure procedure = new CheckCollisionProcedure(aabbs);
        for (Chunk chunk : ChunkBlockHandler.getAffectedChunks(world, aabbs)) {
            ChunkBlockHandler.get().callProcedure(chunk, procedure);
        }
        return !procedure.collide;
    }

    public void replaceBlocks(World world, BlockState state) {
        AxisAlignedBB[] aabbs;
        for (AxisAlignedBB aabb : aabbs = AABBUtils.getCollisionBoundingBoxes(world, state, true)) {
            for (BlockPos pos : BlockPos.getAllInBox(aabb)) {
                if (!world.func_147439_a(pos.getX(), pos.getY(), pos.getZ()).isReplaceable((IBlockAccess)world, pos.getX(), pos.getY(), pos.getZ())) continue;
                world.func_147468_f(pos.getX(), pos.getY(), pos.getZ());
            }
        }
    }

    public void updateBlocks(World world, BlockState state) {
        AxisAlignedBB[] aabbs;
        for (AxisAlignedBB aabb : aabbs = AABBUtils.getCollisionBoundingBoxes(world, state, true)) {
            for (BlockPos pos : BlockPos.getAllInBox(aabb)) {
                world.func_147444_c(pos.getX(), pos.getY(), pos.getZ(), state.getBlock());
            }
        }
    }

    public static ChunkCollision get() {
        return instance;
    }

    private static class CheckCollisionProcedure
    extends ChunkBlockHandler.ChunkProcedure {
        private AxisAlignedBB[] aabbs;
        private boolean collide = false;

        public CheckCollisionProcedure(AxisAlignedBB[] aabbs) {
            this.aabbs = aabbs;
        }

        public boolean execute(long coord) {
            if (!this.check(coord)) {
                return true;
            }
            AxisAlignedBB[] blockBounds = AABBUtils.getCollisionBoundingBoxes(this.world, this.state);
            AABBUtils.offset(this.state.getX(), this.state.getY(), this.state.getZ(), blockBounds);
            this.collide = AABBUtils.isColliding(this.aabbs, blockBounds);
            return !this.collide;
        }

        @Override
        protected void clean() {
            super.clean();
            this.aabbs = null;
            this.collide = false;
        }
    }

    private static class RayTraceProcedure
    extends ChunkBlockHandler.ChunkProcedure {
        private Point src;
        private Point dest;
        private MovingObjectPosition mop;

        public RayTraceProcedure(Point src, Point dest, MovingObjectPosition mop) {
            this.src = src;
            this.dest = dest;
            this.mop = mop;
        }

        public boolean execute(long coord) {
            if (!this.check(coord)) {
                return true;
            }
            RaytraceBlock rt = RaytraceBlock.set(this.world, this.src, this.dest, this.state.getX(), this.state.getY(), this.state.getZ());
            this.mop = ChunkCollision.get().getClosest(this.src, rt.trace(), this.mop);
            return true;
        }

        @Override
        protected void clean() {
            super.clean();
            this.src = null;
            this.dest = null;
            this.mop = null;
        }
    }

    private static class CollisionProcedure
    extends ChunkBlockHandler.ChunkProcedure {
        private AxisAlignedBB mask;
        private List<AxisAlignedBB> list;

        public CollisionProcedure(AxisAlignedBB mask, List<AxisAlignedBB> list) {
            this.mask = mask;
            this.list = list;
        }

        public boolean execute(long coord) {
            if (!this.check(coord)) {
                return true;
            }
            if (this.state.getBlock() instanceof IChunkCollidable) {
                AxisAlignedBB[] aabbs;
                for (AxisAlignedBB aabb : aabbs = ((IChunkCollidable)this.state.getBlock()).getBoundingBox((IBlockAccess)this.world, this.state.getX(), this.state.getY(), this.state.getZ(), BoundingBoxType.CHUNKCOLLISION)) {
                    if (this.mask == null || aabb == null || !this.mask.func_72326_a(aabb.func_72317_d((double)this.state.getX(), (double)this.state.getY(), (double)this.state.getZ()))) continue;
                    this.list.add(aabb);
                }
            }
            return true;
        }

        @Override
        protected void clean() {
            super.clean();
            this.mask = null;
            this.list = null;
        }
    }
}

