/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.finiteliquid;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.util.BlockPos;
import net.malisis.core.util.BlockState;
import net.malisis.core.util.RaytraceBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;

public abstract class FiniteLiquid
extends BlockDynamicLiquid {
    public static int renderId = -1;
    protected String name;
    private static ForgeDirection[] dirs = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST};
    private int delay = 5;

    public FiniteLiquid(Material material) {
        super(material);
    }

    public Block func_149663_c(String name) {
        this.name = name;
        if (this.field_149768_d == null) {
            this.field_149768_d = name;
        }
        super.func_149658_d(name);
        super.func_149663_c(name);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void register() {
        GameRegistry.registerBlock((Block)this, (String)this.getName());
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            world.func_147464_a(x, y, z, (Block)this, this.delay);
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        this.setAmount(world, new BlockState((IBlockAccess)world, x, y, z), 16);
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        if (!world.field_72995_K) {
            world.func_147464_a(x, y, z, (Block)this, this.delay);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!world.field_72995_K) {
            this.spreadLiquid(world, x, y, z);
        }
    }

    public int getAmount(BlockState state) {
        if (state.getBlock() == Blocks.field_150350_a) {
            return 0;
        }
        if (state.getBlock() != this) {
            return -1;
        }
        return state.getMetadata() + 1;
    }

    public void setAmount(World world, BlockState state, int amount) {
        if (amount <= 0) {
            world.func_147468_f(state.getX(), state.getY(), state.getZ());
        } else {
            if (this.getAmount(state) == amount) {
                return;
            }
            world.func_147465_d(state.getX(), state.getY(), state.getZ(), (Block)this, amount - 1, 2);
            world.func_147464_a(state.getX(), state.getY(), state.getZ(), (Block)this, this.delay);
        }
    }

    public int addAmount(World world, BlockState state, int amount) {
        int current = this.getAmount(state);
        if (current == -1) {
            return amount;
        }
        int newAmount = Math.min(16 - current, amount);
        this.setAmount(world, state, current + newAmount);
        return amount - newAmount;
    }

    private void spreadLiquid(World world, int x, int y, int z) {
        BlockState state = new BlockState((IBlockAccess)world, x, y, z);
        FloodFill ff = new FloodFill(this, world, state);
        ff.parse();
    }

    public AxisAlignedBB[] getBoundingBox(IBlockAccess world, int x, int y, int z, BoundingBoxType type) {
        int metadata = world.func_72805_g(x, y, z);
        return new AxisAlignedBB[]{AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)((double)metadata / 16.0), (double)1.0)};
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity entity) {
        for (AxisAlignedBB aabb : this.getBoundingBox((IBlockAccess)world, x, y, z, BoundingBoxType.COLLISION)) {
            if (aabb == null || !mask.func_72326_a(aabb.func_72317_d((double)x, (double)y, (double)z))) continue;
            list.add(aabb);
        }
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 src, Vec3 dest) {
        return RaytraceBlock.set(world, src, dest, x, y, z).trace();
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        Object[] aabbs = this.getBoundingBox((IBlockAccess)world, x, y, z, BoundingBoxType.SELECTION);
        if (ArrayUtils.isEmpty((Object[])aabbs)) {
            return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        }
        return aabbs[0].func_72317_d((double)x, (double)y, (double)z);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess worldIn, int x, int y, int z, int side) {
        Material material = worldIn.func_147439_a(x, y, z).func_149688_o();
        return material == this.field_149764_J ? false : (side == 1 ? true : super.func_149646_a(worldIn, x, y, z, side));
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean canRenderInPass(int pass) {
        return pass == this.func_149701_w();
    }

    public int func_149701_w() {
        return 1;
    }

    public int func_149645_b() {
        return renderId;
    }

    public static class SpreadData {
        BlockPos pos;
        int amount;

        public SpreadData(BlockPos pos, int amount) {
            this.pos = pos;
            this.amount = amount;
        }
    }

    public static class FloodFill {
        FiniteLiquid fl;
        Set<BlockPos> parsed = new HashSet<BlockPos>();
        LinkedList<BlockPos> toParse = new LinkedList();
        World world;
        BlockPos origin;
        int amount = 0;

        public FloodFill(FiniteLiquid fl, World world, BlockState state) {
            this.fl = fl;
            this.world = world;
            this.origin = state.getPos();
            this.amount = fl.getAmount(state);
            this.toParse.add(state.getPos());
        }

        public boolean shouldParse(BlockPos pos) {
            if (!this.origin.isInRange(pos, 16)) {
                return false;
            }
            if (this.toParse.contains(pos)) {
                return false;
            }
            BlockState state = new BlockState((IBlockAccess)this.world, pos);
            return state.getBlock() == this.fl || state.getBlock() == Blocks.field_150350_a;
        }

        public void parse() {
            BlockState state;
            while (this.toParse.size() > 0 && this.process(state = new BlockState((IBlockAccess)this.world, this.toParse.removeFirst()))) {
                this.parse(state);
            }
            this.fl.setAmount(this.world, new BlockState((IBlockAccess)this.world, this.origin), this.amount);
        }

        public boolean process(BlockState state) {
            BlockState down = new BlockState((IBlockAccess)this.world, state.getPos().down());
            int da = this.fl.getAmount(down);
            if (da != -1 && da != 16) {
                int transfered = Math.min(this.amount, 4);
                transfered = Math.min(transfered, 16 - da);
                this.fl.setAmount(this.world, down, da + transfered);
                this.amount -= transfered;
                return this.amount > 0;
            }
            if (state.getPos().equals(this.origin)) {
                return true;
            }
            int a = this.fl.getAmount(state);
            if (a < this.amount - 1) {
                this.fl.setAmount(this.world, state, a + 1);
                --this.amount;
            }
            return this.amount > 1;
        }

        public void parse(BlockState state) {
            BlockPos pos = state.getPos();
            if (state.getBlock() == this.fl) {
                for (ForgeDirection dir : dirs) {
                    BlockPos newPos = pos.offset(dir);
                    if (this.parsed.contains(newPos) || !this.shouldParse(newPos)) continue;
                    this.toParse.add(newPos);
                }
            }
            this.parsed.add(state.getPos());
        }
    }
}

