/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import squeek.applecore.api.food.FoodValues;
import squeek.spiceoflife.ModConfig;
import squeek.spiceoflife.compat.IByteIO;
import squeek.spiceoflife.foodtracker.FoodEaten;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroup;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroupRegistry;
import squeek.spiceoflife.foodtracker.foodqueue.FixedHungerQueue;
import squeek.spiceoflife.foodtracker.foodqueue.FixedSizeQueue;
import squeek.spiceoflife.foodtracker.foodqueue.FixedTimeQueue;
import squeek.spiceoflife.foodtracker.foodqueue.FoodQueue;
import squeek.spiceoflife.helpers.FoodHelper;
import squeek.spiceoflife.interfaces.IPackable;
import squeek.spiceoflife.interfaces.ISaveable;
import squeek.spiceoflife.items.ItemFoodJournal;

public class FoodHistory
implements IExtendedEntityProperties,
ISaveable,
IPackable {
    public static final String TAG_KEY = "SpiceOfLifeHistory";
    public final EntityPlayer player;
    protected FoodQueue history = FoodHistory.getNewFoodQueue();
    public int totalFoodsEatenAllTime = 0;
    public boolean wasGivenFoodJournal = false;
    public long ticksActive = 0L;

    public FoodHistory() {
        this(null);
    }

    public FoodHistory(EntityPlayer player) {
        this.player = player;
        if (player != null) {
            player.registerExtendedProperties(TAG_KEY, (IExtendedEntityProperties)this);
        }
    }

    public void onHistoryTypeChanged() {
        FoodQueue oldHistory = this.history;
        this.history = FoodHistory.getNewFoodQueue();
        this.history.addAll(oldHistory);
    }

    public static FoodQueue getNewFoodQueue() {
        if (ModConfig.USE_HUNGER_QUEUE) {
            return new FixedHungerQueue(ModConfig.FOOD_HISTORY_LENGTH);
        }
        if (ModConfig.USE_TIME_QUEUE) {
            return new FixedTimeQueue(ModConfig.FOOD_HISTORY_LENGTH * 24000);
        }
        return new FixedSizeQueue(ModConfig.FOOD_HISTORY_LENGTH);
    }

    public void deltaTicksActive(long delta) {
        this.ticksActive += delta;
    }

    public boolean addFood(FoodEaten foodEaten) {
        return this.addFood(foodEaten, true);
    }

    public boolean addFood(FoodEaten foodEaten, boolean countsTowardsAllTime) {
        boolean isAtThreshold;
        if (countsTowardsAllTime) {
            ++this.totalFoodsEatenAllTime;
        }
        boolean bl = isAtThreshold = countsTowardsAllTime && this.totalFoodsEatenAllTime == ModConfig.FOOD_EATEN_THRESHOLD;
        if (this.player != null && !this.player.field_70170_p.field_72995_K) {
            if (ModConfig.GIVE_FOOD_JOURNAL_ON_DIMINISHING_RETURNS && !this.wasGivenFoodJournal && isAtThreshold) {
                ItemFoodJournal.giveToPlayer(this.player);
                this.wasGivenFoodJournal = true;
            }
            if (ModConfig.CLEAR_HISTORY_ON_FOOD_EATEN_THRESHOLD && isAtThreshold) {
                this.history.clear();
                return true;
            }
        }
        return this.history.add(foodEaten);
    }

    public int getFoodCount(ItemStack food) {
        int count = 0;
        FoodGroup foodGroup = FoodGroupRegistry.getFoodGroupForFood(food);
        for (FoodEaten foodEaten : this.history) {
            if (foodEaten.itemStack == null || !food.func_77969_a(foodEaten.itemStack) && (foodGroup == null || !foodGroup.equals(foodEaten.foodGroup))) continue;
            ++count;
        }
        return count;
    }

    public FoodValues getTotalFoodValues(ItemStack food) {
        int totalHunger = 0;
        float totalSaturation = 0.0f;
        FoodGroup foodGroup = FoodGroupRegistry.getFoodGroupForFood(food);
        for (FoodEaten foodEaten : this.history) {
            if (foodEaten.itemStack == null || !food.func_77969_a(foodEaten.itemStack) && (foodGroup == null || !foodGroup.equals(foodEaten.foodGroup))) continue;
            totalHunger += foodEaten.foodValues.hunger;
            totalSaturation += foodEaten.foodValues.getSaturationIncrement();
        }
        if (totalHunger == 0) {
            return new FoodValues(0, 0.0f);
        }
        return new FoodValues(totalHunger, totalSaturation);
    }

    public FoodQueue getHistory() {
        return this.history;
    }

    public int getHistoryLengthInRelevantUnits() {
        return ModConfig.USE_HUNGER_QUEUE ? ((FixedHungerQueue)this.history).hunger() : this.history.size();
    }

    public FoodEaten getLastEatenFood() {
        return (FoodEaten)this.history.peekLast();
    }

    public void reset() {
        this.history.clear();
        this.totalFoodsEatenAllTime = 0;
        this.wasGivenFoodJournal = false;
        this.ticksActive = 0L;
    }

    public void validate() {
        ArrayList<FoodEaten> invalidFoods = new ArrayList<FoodEaten>();
        for (FoodEaten foodEaten : this.history) {
            if (FoodHelper.isValidFood(foodEaten.itemStack)) continue;
            invalidFoods.add(foodEaten);
        }
        this.history.removeAll(invalidFoods);
        this.totalFoodsEatenAllTime -= invalidFoods.size();
    }

    public static FoodHistory get(EntityPlayer player) {
        FoodHistory foodHistory = (FoodHistory)player.getExtendedProperties(TAG_KEY);
        if (foodHistory == null) {
            foodHistory = new FoodHistory(player);
        }
        return foodHistory;
    }

    @Override
    public void pack(IByteIO data) {
        data.writeLong(this.ticksActive);
        data.writeShort(this.getHistory().size());
        for (FoodEaten foodEaten : this.getHistory()) {
            foodEaten.pack(data);
        }
    }

    @Override
    public void unpack(IByteIO data) {
        this.ticksActive = data.readLong();
        int historySize = data.readShort();
        for (int i = 0; i < historySize; ++i) {
            FoodEaten foodEaten = new FoodEaten();
            foodEaten.unpack(data);
            this.addFood(foodEaten);
        }
    }

    @Override
    public void writeToNBTData(NBTTagCompound data) {
        NBTTagCompound rootPersistentCompound = this.player.getEntityData().func_74775_l("PlayerPersisted");
        NBTTagCompound nonPersistentCompound = new NBTTagCompound();
        NBTTagCompound persistentCompound = new NBTTagCompound();
        if (this.history.size() > 0 && (data != null || ModConfig.FOOD_HISTORY_PERSISTS_THROUGH_DEATH)) {
            NBTTagCompound nbtHistory = new NBTTagCompound();
            this.history.writeToNBTData(nbtHistory);
            if (ModConfig.FOOD_HISTORY_PERSISTS_THROUGH_DEATH) {
                persistentCompound.func_74782_a("History", (NBTBase)nbtHistory);
            } else {
                nonPersistentCompound.func_74782_a("History", (NBTBase)nbtHistory);
            }
        }
        if (this.totalFoodsEatenAllTime > 0) {
            persistentCompound.func_74768_a("Total", this.totalFoodsEatenAllTime);
        }
        if (this.wasGivenFoodJournal) {
            persistentCompound.func_74757_a("FoodJournal", this.wasGivenFoodJournal);
        }
        if (this.ticksActive > 0L) {
            persistentCompound.func_74772_a("Ticks", this.ticksActive);
        }
        if (data != null && !nonPersistentCompound.func_82582_d()) {
            data.func_74782_a(TAG_KEY, (NBTBase)nonPersistentCompound);
        }
        if (!persistentCompound.func_82582_d()) {
            rootPersistentCompound.func_74782_a(TAG_KEY, (NBTBase)persistentCompound);
        }
        if (!this.player.getEntityData().func_74764_b("PlayerPersisted")) {
            this.player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)rootPersistentCompound);
        }
    }

    @Override
    public void readFromNBTData(NBTTagCompound data) {
        NBTTagCompound rootPersistentCompound = this.player.getEntityData().func_74775_l("PlayerPersisted");
        if (data != null && data.func_74764_b(TAG_KEY) || rootPersistentCompound.func_74764_b(TAG_KEY)) {
            NBTTagCompound nonPersistentCompound = data != null ? data.func_74775_l(TAG_KEY) : new NBTTagCompound();
            NBTTagCompound persistentCompound = rootPersistentCompound.func_74775_l(TAG_KEY);
            NBTTagCompound nbtHistory = ModConfig.FOOD_HISTORY_PERSISTS_THROUGH_DEATH ? persistentCompound.func_74775_l("History") : nonPersistentCompound.func_74775_l("History");
            this.history.readFromNBTData(nbtHistory);
            this.totalFoodsEatenAllTime = persistentCompound.func_74762_e("Total");
            this.wasGivenFoodJournal = persistentCompound.func_74767_n("FoodJournal");
            this.ticksActive = persistentCompound.func_74763_f("Ticks");
        }
    }

    public void saveNBTData(NBTTagCompound compound) {
        this.writeToNBTData(compound);
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.readFromNBTData(compound);
    }

    public void init(Entity entity, World world) {
    }
}

