/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker.foodqueue;

import squeek.spiceoflife.foodtracker.FoodEaten;
import squeek.spiceoflife.foodtracker.foodqueue.FixedSizeQueue;

public class FixedHungerQueue
extends FixedSizeQueue {
    private static final long serialVersionUID = -1347372098150405272L;
    protected int hunger;
    protected int hungerOverflow;

    public FixedHungerQueue(int limit) {
        super(limit);
    }

    @Override
    public boolean add(FoodEaten foodEaten) {
        boolean added = super.add(foodEaten);
        if (added) {
            this.hunger += foodEaten.foodValues.hunger;
            this.trimToMaxSize();
        }
        return added;
    }

    @Override
    public void clear() {
        super.clear();
        this.hungerOverflow = 0;
        this.hunger = 0;
    }

    public int hunger() {
        return this.hunger;
    }

    @Override
    protected void trimToMaxSize() {
        while (this.hunger > this.limit && this.peekFirst() != null) {
            --this.hunger;
            ++this.hungerOverflow;
            while (this.hungerOverflow >= ((FoodEaten)this.peekFirst()).foodValues.hunger) {
                this.hungerOverflow -= ((FoodEaten)this.removeFirst()).foodValues.hunger;
            }
        }
    }
}

