/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.client;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class CustomFont {
    private int texID;
    private int[] xPos;
    private int[] yPos;
    private int startChar;
    private int endChar;
    private FontMetrics metrics;

    public CustomFont(Minecraft mc, Object font, int size) {
        this(mc, font, size, 0, 4000);
    }

    public CustomFont(Minecraft mc, Object font, int size, int startChar, int endChar) {
        this.startChar = startChar;
        this.endChar = endChar;
        this.xPos = new int[endChar - startChar];
        this.yPos = new int[endChar - startChar];
        BufferedImage img = new BufferedImage(256, 256, 2);
        Graphics g = img.getGraphics();
        try {
            if (font instanceof String) {
                String fontName = (String)font;
                if (fontName.contains("/")) {
                    g.setFont(Font.createFont(0, new File(fontName)).deriveFont((float)size));
                } else {
                    g.setFont(new Font(fontName, 0, size));
                }
            } else if (font instanceof InputStream) {
                g.setFont(Font.createFont(0, (InputStream)font).deriveFont((float)size));
            } else if (font instanceof File) {
                g.setFont(Font.createFont(0, (File)font).deriveFont((float)size));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        g.setColor(new Color(255, 255, 255, 0));
        g.fillRect(0, 0, 256, 256);
        g.setColor(Color.white);
        this.metrics = g.getFontMetrics();
        int x = 2;
        int y = 2;
        for (int i = startChar; i < endChar; ++i) {
            g.drawString("" + (char)i, x, y + g.getFontMetrics().getAscent());
            this.xPos[i - startChar] = x;
            this.yPos[i - startChar] = y - this.metrics.getMaxDescent();
            if ((x += this.metrics.stringWidth("" + (char)i) + 2) < 250 - this.metrics.getMaxAdvance()) continue;
            x = 2;
            y += this.metrics.getMaxAscent() + this.metrics.getMaxDescent() + size / 2;
        }
    }

    public void drawStringS(Gui gui, String text, int x, int y, int color) {
        int l = color & 0xFF000000;
        int shade = (color & 0xFCFCFC) >> 2;
        this.drawString(gui, text, x + 1, y + 1, shade += l);
        this.drawString(gui, text, x, y, color);
    }

    public void drawString(Gui gui, String text, int x, int y, int color) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glBindTexture((int)3553, (int)this.texID);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
        int startX = x;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\\') {
                char type = text.charAt(i + 1);
                if (type == 'n') {
                    y += this.metrics.getAscent() + 2;
                    x = startX;
                }
                ++i;
                continue;
            }
            this.drawChar(gui, c, x, y);
            x = (int)((double)x + this.metrics.getStringBounds("" + c, null).getWidth());
        }
    }

    public FontMetrics getMetrics() {
        return this.metrics;
    }

    public int getStringWidth(String text) {
        return (int)this.getBounds(text).getWidth();
    }

    public int getStringHeight(String text) {
        return (int)this.getBounds(text).getHeight();
    }

    private Rectangle getBounds(String text) {
        int w = 0;
        int h = 0;
        int tw = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\\') {
                char type = text.charAt(i + 1);
                if (type == 'n') {
                    h += this.metrics.getAscent() + 2;
                    if (tw > w) {
                        w = tw;
                    }
                    tw = 0;
                }
                ++i;
                continue;
            }
            tw += this.metrics.stringWidth("" + c);
        }
        if (tw > w) {
            w = tw;
        }
        return new Rectangle(0, 0, w, h += this.metrics.getAscent());
    }

    private void drawChar(Gui gui, char c, int x, int y) {
        Rectangle2D bounds = this.metrics.getStringBounds("" + c, null);
        this.drawTexturedModalRect(x, y, this.xPos[(byte)c - this.startChar], this.yPos[(byte)c - this.startChar], (int)bounds.getWidth(), (int)bounds.getHeight() + this.metrics.getMaxDescent());
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height) {
        float offsetWidth = 0.00390625f;
        float offsetHeight = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), 0.0, (double)((float)(u + 0) * offsetWidth), (double)((float)(v + height) * offsetHeight));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), 0.0, (double)((float)(u + width) * offsetWidth), (double)((float)(v + height) * offsetHeight));
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), 0.0, (double)((float)(u + width) * offsetWidth), (double)((float)(v + 0) * offsetHeight));
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), 0.0, (double)((float)(u + 0) * offsetWidth), (double)((float)(v + 0) * offsetHeight));
        tessellator.func_78381_a();
    }
}

