/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweaks;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import iguanaman.iguanatweaks.config.IguanaConfig;
import iguanaman.iguanatweaks.config.IguanaConfigHandler;
import iguanaman.iguanatweaks.data.EntityData;
import iguanaman.iguanatweaks.data.IguanaPotion;
import iguanaman.iguanatweaks.events.IguanaEventHook;
import iguanaman.iguanatweaks.events.IguanaKeyHandler;
import iguanaman.iguanatweaks.events.IguanaPlayerHandler;
import iguanaman.iguanatweaks.events.IguanaTickHandler;
import iguanaman.iguanatweaks.proxy.CommonProxy;
import iguanaman.iguanatweaks.util.RecipeRemover;
import iguanaman.iguanatweaks.util.StackSizeTweaks;
import java.io.File;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.logging.log4j.Logger;

@Mod(modid="IguanaTweaks", name="Iguana Tweaks", version="2B", dependencies="required-after:Forge@[10.13.2.1291,);", guiFactory="iguanaman.iguanatweaks.config.IguanaGuiFactory")
public class IguanaTweaks {
    @Mod.Instance(value="IguanaTweaks")
    public static IguanaTweaks instance;
    @SidedProxy(clientSide="iguanaman.iguanatweaks.proxy.ClientProxy", serverSide="iguanaman.iguanatweaks.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static Logger log;
    public static Potion poisonNew;
    public static Potion slowdownNew;
    public static ConcurrentHashMap<UUID, EntityData> entityDataMap;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        log = event.getModLog();
        File configFolder = new File(event.getModConfigurationDirectory().getAbsolutePath() + File.separator + "IguanaTweaks" + File.separator);
        new IguanaConfigHandler(configFolder);
        FMLCommonHandler.instance().bus().register((Object)new IguanaConfig());
        slowdownNew = new IguanaPotion(IguanaConfig.damageSlowdownPotionId, true, 5926017);
        if (IguanaConfig.lessObviousSilverfish) {
            log.info("Hiding silverfish");
            Blocks.field_150418_aU.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(Block.field_149769_e);
            Blocks.field_150418_aU.setHarvestLevel("pickaxe", 0);
        }
        if (IguanaConfig.alterPoison) {
            log.info("Altering poison");
            Potion.field_76425_a[19] = null;
            poisonNew = new IguanaPotion(19, true, 5149489).func_76390_b("potion.poison");
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        if (IguanaConfig.torchesPerCoal != 4) {
            log.info("Changing torch recipe output");
            RecipeRemover.removeAnyRecipe(new ItemStack(Blocks.field_150478_aa, 4));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.field_150478_aa, IguanaConfig.torchesPerCoal), new Object[]{"c", "s", Character.valueOf('c'), new ItemStack(Items.field_151044_h), Character.valueOf('s'), new ItemStack(Items.field_151055_y)}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.field_150478_aa, IguanaConfig.torchesPerCoal), new Object[]{"c", "s", Character.valueOf('c'), new ItemStack(Items.field_151044_h, 1, 1), Character.valueOf('s'), new ItemStack(Items.field_151055_y)}));
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        StackSizeTweaks.init();
        if (IguanaConfig.hideExperience) {
            proxy.disableExperienceHud();
        }
        if (IguanaConfig.maxCarryWeight > 0) {
            log.info("Starting weight watcher");
        }
        MinecraftForge.EVENT_BUS.register((Object)new IguanaEventHook());
        FMLCommonHandler.instance().bus().register((Object)new IguanaPlayerHandler());
        FMLCommonHandler.instance().bus().register((Object)new IguanaTickHandler());
        FMLCommonHandler.instance().bus().register((Object)new IguanaKeyHandler());
    }

    static {
        entityDataMap = new ConcurrentHashMap();
    }
}

