/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.renderer;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.AnimationRenderer;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.face.NorthFace;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.util.MultiBlock;
import net.malisis.doors.door.tileentity.ForcefieldTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class ForcefieldRenderer
extends MalisisRenderer {
    protected static ResourceLocation[] rl;
    protected MalisisModel model;
    protected ForcefieldTileEntity tileEntity;
    protected AnimationRenderer ar = new AnimationRenderer();
    protected ForgeDirection direction;

    protected void initialize() {
        rl = new ResourceLocation[50];
        for (int i = 0; i < 50; ++i) {
            ForcefieldRenderer.rl[i] = new ResourceLocation(String.format("malisisdoors:textures/blocks/forcefield%02d.png", i));
        }
        Shape shape = new Shape(new Face[]{new NorthFace()});
        shape.scale(1.0f, 1.0f, 0.0f);
        this.model = new MalisisModel();
        this.model.addShape(shape);
        this.model.storeState();
        this.rp = new RenderParameters();
        this.rp.interpolateUV.set((Object)false);
        this.rp.useBlockBounds.set((Object)false);
        this.rp.calculateAOColor.set((Object)false);
        this.rp.setBrightness(0xF000F0);
        this.rp.useEnvironmentBrightness.set((Object)false);
        this.rp.calculateBrightness.set((Object)false);
        this.rp.applyTexture.set((Object)false);
        this.rp.alpha.set((Object)50);
    }

    public void render() {
        this.tileEntity = (ForcefieldTileEntity)MultiBlock.getOriginProvider(ForcefieldTileEntity.class, (IBlockAccess)this.world, (int)this.x, (int)this.y, (int)this.z);
        if (this.tileEntity == null || this.tileEntity.isOpened() || !MultiBlock.isOrigin((IBlockAccess)this.world, (int)this.x, (int)this.y, (int)this.z)) {
            return;
        }
        this.enableBlending();
        this.tileEntity = (ForcefieldTileEntity)((MalisisRenderer)this).tileEntity;
        this.direction = ForgeDirection.getOrientation((int)this.tileEntity.getDirection());
        this.model.resetState();
        if (this.tileEntity.getMovement() == null) {
            return;
        }
        AxisAlignedBB aabb = this.tileEntity.getMovement().getBoundingBox(this.tileEntity, false, BoundingBoxType.COLLISION);
        if (aabb == null) {
            return;
        }
        aabb.func_72317_d((double)(-this.x), (double)(-this.y), (double)(-this.z));
        this.rp.renderBounds.set((Object)aabb);
        this.direction = ForgeDirection.NORTH;
        if ((int)aabb.field_72338_b == (int)aabb.field_72337_e) {
            this.direction = ForgeDirection.UP;
            this.model.rotate(90.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        } else if ((int)aabb.field_72340_a == (int)aabb.field_72336_d) {
            this.direction = ForgeDirection.EAST;
            this.model.rotate(90.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        this.setTextureMatrix();
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glDisable((int)2884);
        this.model.render((MalisisRenderer)this, this.rp);
        this.next();
        GL11.glEnable((int)2884);
        GL11.glMatrixMode((int)5890);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glDisable((int)3042);
    }

    private void setTextureMatrix() {
        long elapsed = this.ar.getElapsedTime() / 50L;
        int n = (int)(elapsed % 50L);
        this.func_147499_a(rl[n]);
        GL11.glMatrixMode((int)5890);
        GL11.glLoadIdentity();
        AxisAlignedBB aabb = this.tileEntity.getMultiBlock().getBounds();
        double scaleX = 1.0;
        double scaleY = 1.0;
        if (this.direction == ForgeDirection.UP) {
            scaleX = aabb.field_72336_d - aabb.field_72340_a;
            scaleY = aabb.field_72334_f - aabb.field_72339_c;
            if (aabb.field_72334_f - aabb.field_72339_c > aabb.field_72336_d - aabb.field_72340_a) {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        } else {
            scaleY = aabb.field_72337_e - aabb.field_72338_b;
            if (this.direction == ForgeDirection.EAST) {
                scaleX = aabb.field_72334_f - aabb.field_72339_c;
            } else if (this.direction == ForgeDirection.NORTH) {
                scaleX = aabb.field_72336_d - aabb.field_72340_a;
            }
        }
        GL11.glScaled((double)(scaleX / 3.0), (double)(scaleY / 3.0), (double)1.0);
        GL11.glMatrixMode((int)5888);
    }
}

