/*
 * Decompiled with CFR 0.152.
 */
package toast.deadlyWorld;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.storage.SaveHandler;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import toast.deadlyWorld.Properties;
import toast.deadlyWorld._DeadlyWorld;

public class EventHandler {
    private static final byte ADJUST_BREAK_SPEED;

    public EventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onChunkPopulate(PopulateChunkEvent.Populate event) {
        if (_DeadlyWorld.generation && event.type == PopulateChunkEvent.Populate.EventType.DUNGEON && !event.world.field_72995_K && event.world.field_73011_w.field_76574_g == 0) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.block == Blocks.field_150418_aU) {
            if (ADJUST_BREAK_SPEED == 1) {
                Block posingBlock = event.metadata == 1 ? Blocks.field_150347_e : (event.metadata == 2 ? Blocks.field_150417_aV : Blocks.field_150348_b);
                float hardness = posingBlock.func_149712_f(event.entityPlayer.field_70170_p, 0, 0, 0) / event.block.func_149712_f(event.entityPlayer.field_70170_p, 0, 0, 0);
                event.newSpeed = ForgeHooks.canHarvestBlock((Block)posingBlock, (EntityPlayer)event.entityPlayer, (int)event.metadata) ? event.entityPlayer.getBreakSpeed(posingBlock, false, 0, 0, -1, 0) : 0.3f;
                event.newSpeed = ForgeEventFactory.getBreakSpeed((EntityPlayer)event.entityPlayer, (Block)posingBlock, (int)0, (float)(event.newSpeed / hardness), (int)0, (int)-1, (int)0);
            } else if (ADJUST_BREAK_SPEED == 2) {
                event.newSpeed = Float.POSITIVE_INFINITY;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.world != null && !event.world.field_72995_K && event.world.field_73011_w.field_76574_g == 0) {
            EventHandler.checkWorld(event.world);
        }
    }

    public static void checkWorld(World world) {
        boolean canDisable = Properties.getBoolean("_general", "automatic_disable");
        if (world.func_72860_G() instanceof SaveHandler) {
            if (world.func_82737_E() == 0L) {
                try {
                    File worldDirectory = ((SaveHandler)world.func_72860_G()).func_75765_b();
                    File worldFile = new File(worldDirectory, "deadlyWorld.bin");
                    worldDirectory.mkdirs();
                    worldFile.createNewFile();
                    _DeadlyWorld.generation = true;
                    return;
                }
                catch (Exception ex) {
                    _DeadlyWorld.console("Failed to initialize generation! Disabling world generation...");
                    ex.printStackTrace();
                }
            } else {
                try {
                    File worldFile = new File(((SaveHandler)world.func_72860_G()).func_75765_b(), "deadlyWorld.bin");
                    boolean bl = _DeadlyWorld.generation = !canDisable || worldFile.exists();
                    if (!_DeadlyWorld.generation) {
                        _DeadlyWorld.console("Detected world not created with this mod! Disabling world generation...");
                    }
                    return;
                }
                catch (Exception ex) {
                    _DeadlyWorld.console("Failed generation check! Disabling world generation...");
                    ex.printStackTrace();
                }
            }
        }
        _DeadlyWorld.generation = !canDisable;
    }

    static {
        String breakSpeed = Properties.getString("_general", "modify_break_speed");
        ADJUST_BREAK_SPEED = breakSpeed.equalsIgnoreCase("true") ? (byte)1 : (breakSpeed.equalsIgnoreCase("instant") ? (byte)2 : (byte)0);
    }
}

