/*
 * Decompiled with CFR 0.152.
 */
package toast.deadlyWorld.feature;

import java.util.Random;
import net.minecraft.world.World;
import toast.deadlyWorld.feature.Mine;
import toast.deadlyWorld.feature.SpawnerItem;
import toast.deadlyWorld.feature.WorldFeature;
import toast.deadlyWorld.feature.WorldFeatureItem;

public class FireTrap
implements WorldFeature {
    public static final WorldFeatureItem item = SpawnerItem.buildSpawner("fire", 0);
    public final double frequency;

    public FireTrap(double freq) {
        this.frequency = freq;
    }

    @Override
    public void generate(World world, Random random, int x, int z) {
        if (this.frequency <= random.nextDouble()) {
            return;
        }
        x += random.nextInt(16);
        z += random.nextInt(16);
        int state = 0;
        for (int y = random.nextInt(50) + 11; y > 5; --y) {
            if (world.func_147445_c(x, y, z, true)) {
                if (state != 0) continue;
                if (this.canBePlaced(world, random, x, y, z)) {
                    this.place(world, random, x, y, z);
                    return;
                }
                state = -1;
                continue;
            }
            state = 0;
        }
    }

    @Override
    public boolean canBePlaced(World world, Random random, int x, int y, int z) {
        ++y;
        for (int x1 = -1; x1 < 2; ++x1) {
            for (int z1 = -1; z1 < 2; ++z1) {
                if (!world.func_147445_c(x + x1, y, z + z1, true)) continue;
                return false;
            }
        }
        return world.func_147437_c(x, --y + 2, z) && world.func_147445_c(x, y - 1, z, false) && world.func_147445_c(x - 1, y, z, false) && world.func_147445_c(x + 1, y, z, false) && world.func_147445_c(x, y, z - 1, false) && world.func_147445_c(x, y, z + 1, false);
    }

    @Override
    public void place(World world, Random random, int x, int y, int z) {
        item.place(world, random, x, y, z);
        Mine.coverTrap(world, random, x, y, z);
    }
}

