/*
 * Decompiled with CFR 0.152.
 */
package toast.deadlyWorld.feature;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import toast.deadlyWorld.ChestBuilder;
import toast.deadlyWorld.Properties;
import toast.deadlyWorld.feature.SpawnerItem;
import toast.deadlyWorld.feature.WorldFeature;
import toast.deadlyWorld.feature.WorldFeatureItem;
import toast.deadlyWorld.feature.WorldGenerator;

public class RogueSpawner
implements WorldFeature {
    public static final WorldFeatureItem[] items = SpawnerItem.buildItems("spawner_rogue");
    public static final int totalWeight = WorldGenerator.getTotalWeight(items);
    public static final double armorChance = Properties.getDouble("spawners", "_armor_chance");
    public static final double chestChance = Properties.getDouble("spawners", "_chest_chance");
    public static final double trickChance = Properties.getDouble("spawners", "_trick_chance");
    public final double frequency;

    public RogueSpawner(double freq) {
        this.frequency = freq;
    }

    @Override
    public void generate(World world, Random random, int x, int z) {
        if (this.frequency <= random.nextDouble()) {
            return;
        }
        x += random.nextInt(16);
        z += random.nextInt(16);
        int state = 0;
        for (int y = random.nextInt(50) + 11; y > 4; --y) {
            if (world.func_147445_c(x, y, z, true)) {
                if (state != 0) continue;
                if (this.canBePlaced(world, random, x, y + 1, z)) {
                    this.place(world, random, x, y + 1, z);
                    return;
                }
                state = -1;
                continue;
            }
            state = 0;
        }
    }

    @Override
    public boolean canBePlaced(World world, Random random, int x, int y, int z) {
        return world.func_147437_c(x, y, z) && world.func_147437_c(x, y + 1, z);
    }

    @Override
    public void place(World world, Random random, int x, int y, int z) {
        if (random.nextDouble() < armorChance) {
            boolean trick = false;
            int[][] positions = new int[][]{};
            if (random.nextDouble() < chestChance) {
                positions = new int[][]{{0, 1, 0}, {-1, 0, 0}, {1, 0, 0}, {0, 0, -1}, {0, 0, 1}, {-1, -1, 0}, {1, -1, 0}, {0, -1, -1}, {0, -1, 1}, {0, -2, 0}};
                ChestBuilder.place(world, random, x, y - 1, z, "DeadlyWorld.spawnerChestArmored");
            } else {
                positions = new int[][]{{0, 1, 0}, {-1, 0, 0}, {1, 0, 0}, {0, 0, -1}, {0, 0, 1}, {0, -1, 0}};
                trick = random.nextDouble() < trickChance;
            }
            for (int[] pos : positions) {
                world.func_147465_d(x + pos[0], y + pos[1], z + pos[2], Blocks.field_150343_Z, 0, 2);
            }
            if (trick) {
                ChestBuilder.place(world, random, x, y, z, "DeadlyWorld.spawnerChest");
                return;
            }
        } else if (random.nextDouble() < chestChance && world.func_147445_c(x, y - 2, z, false)) {
            ChestBuilder.place(world, random, x, y - 1, z, "DeadlyWorld.spawnerChest");
        }
        WorldGenerator.choose(random, totalWeight, items).place(world, random, x, y, z);
    }
}

