/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ArcFurnaceRecipe {
    public final Object input;
    public final ItemStack output;
    public final ItemStack slag;
    public final Object[] additives;
    public final int time;
    public final int energyPerTick;
    public static ArrayList<ArcFurnaceRecipe> recipeList = new ArrayList();

    public ArcFurnaceRecipe(ItemStack output, Object input, ItemStack slag, int time, int energyPerTick, Object ... additives) {
        this.output = output;
        this.input = ApiUtils.convertToValidRecipeInput(input);
        this.slag = slag;
        this.time = time;
        this.energyPerTick = energyPerTick;
        if (additives == null) {
            this.additives = new Object[0];
        } else {
            this.additives = new Object[additives.length];
            for (int i = 0; i < additives.length; ++i) {
                this.additives[i] = ApiUtils.convertToValidRecipeInput(additives[i]);
            }
        }
    }

    public static void addRecipe(ItemStack output, Object input, ItemStack slag, int time, int energyPerTick, Object ... additives) {
        ArcFurnaceRecipe recipe = new ArcFurnaceRecipe(output, input, slag, time, energyPerTick, additives);
        if (recipe.input != null) {
            recipeList.add(recipe);
        }
    }

    public static ArcFurnaceRecipe findRecipe(ItemStack input, ItemStack[] additives) {
        for (ArcFurnaceRecipe recipe : recipeList) {
            if (recipe == null || !ApiUtils.stackMatchesObject(input, recipe.input)) continue;
            boolean b0 = true;
            for (Object add : recipe.additives) {
                if (add == null) continue;
                boolean b1 = false;
                for (ItemStack stack : additives) {
                    if (stack == null || !ApiUtils.stackMatchesObject(stack, add) || add instanceof ItemStack && ((ItemStack)add).field_77994_a > stack.field_77994_a) continue;
                    b1 = true;
                }
                if (b1) continue;
                b0 = false;
                break;
            }
            if (!b0) continue;
            return recipe;
        }
        return null;
    }

    public static List<ArcFurnaceRecipe> removeRecipes(ItemStack stack) {
        ArrayList<ArcFurnaceRecipe> list = new ArrayList<ArcFurnaceRecipe>();
        Iterator<ArcFurnaceRecipe> it = recipeList.iterator();
        while (it.hasNext()) {
            ArcFurnaceRecipe ir = it.next();
            if (!OreDictionary.itemMatches((ItemStack)ir.output, (ItemStack)stack, (boolean)true)) continue;
            list.add(ir);
            it.remove();
        }
        return list;
    }

    public static boolean isValidInput(ItemStack stack) {
        for (ArcFurnaceRecipe recipe : recipeList) {
            if (!ApiUtils.stackMatchesObject(stack, recipe.input)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidAdditive(ItemStack stack) {
        for (ArcFurnaceRecipe recipe : recipeList) {
            if (recipe == null) continue;
            for (Object add : recipe.additives) {
                if (!ApiUtils.stackMatchesObject(stack, add)) continue;
                return true;
            }
        }
        return false;
    }
}

