/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.common.IEContent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class DieselHandler {
    static HashMap<String, Integer> dieselGenBurnTime = new HashMap();
    public static ArrayList<SqueezerRecipe> squeezerList = new ArrayList();
    public static ArrayList<FermenterRecipe> fermenterList = new ArrayList();
    public static ArrayList<RefineryRecipe> refineryList = new ArrayList();

    public static void registerFuel(Fluid fuel, int time) {
        if (fuel != null) {
            dieselGenBurnTime.put(fuel.getName(), time);
        }
    }

    public static int getBurnTime(Fluid fuel) {
        if (fuel != null) {
            return dieselGenBurnTime.get(fuel.getName());
        }
        return 0;
    }

    public static boolean isValidFuel(Fluid fuel) {
        if (fuel != null) {
            return dieselGenBurnTime.containsKey(fuel.getName());
        }
        return false;
    }

    public static HashMap<String, Integer> getFuelValues() {
        return dieselGenBurnTime;
    }

    public static Map<String, Integer> getFuelValuesSorted(boolean inverse) {
        return ApiUtils.sortMap(dieselGenBurnTime, inverse);
    }

    public static void addSqueezerRecipe(Object input, int time, FluidStack fluid, ItemStack itemOutput) {
        if (input instanceof String && !OreDictionary.doesOreNameExist((String)((String)input))) {
            return;
        }
        squeezerList.add(new SqueezerRecipe(input, time, fluid, itemOutput));
    }

    public static SqueezerRecipe findSqueezerRecipe(ItemStack input) {
        for (SqueezerRecipe recipe : squeezerList) {
            if (recipe.input instanceof ItemStack && OreDictionary.itemMatches((ItemStack)((ItemStack)recipe.input), (ItemStack)input, (boolean)false)) {
                return recipe;
            }
            if (!(recipe.input instanceof String) || !ApiUtils.compareToOreName(input, (String)recipe.input)) continue;
            return recipe;
        }
        return null;
    }

    public static List<SqueezerRecipe> removeSqueezerRecipes(ItemStack stack) {
        ArrayList<SqueezerRecipe> list = new ArrayList<SqueezerRecipe>();
        Iterator<SqueezerRecipe> it = squeezerList.iterator();
        while (it.hasNext()) {
            SqueezerRecipe ir = it.next();
            if (!OreDictionary.itemMatches((ItemStack)ir.output, (ItemStack)stack, (boolean)true)) continue;
            list.add(ir);
            it.remove();
        }
        return list;
    }

    public static Map<String, Integer> getPlantoilValuesSorted(boolean inverse) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (SqueezerRecipe recipe : squeezerList) {
            if (recipe.fluid == null || recipe.fluid.getFluid() != IEContent.fluidPlantoil) continue;
            if (recipe.input instanceof String) {
                map.put((String)recipe.input, recipe.fluid.amount);
                continue;
            }
            if (!(recipe.input instanceof ItemStack)) continue;
            map.put(((ItemStack)recipe.input).func_82833_r(), recipe.fluid.amount);
        }
        return ApiUtils.sortMap(map, inverse);
    }

    public static void addFermenterRecipe(Object input, int time, FluidStack fluid, ItemStack itemOutput) {
        if (input instanceof String && !OreDictionary.doesOreNameExist((String)((String)input))) {
            return;
        }
        fermenterList.add(new FermenterRecipe(input, time, fluid, itemOutput));
    }

    public static FermenterRecipe findFermenterRecipe(ItemStack input) {
        for (FermenterRecipe recipe : fermenterList) {
            if (recipe.input instanceof ItemStack && OreDictionary.itemMatches((ItemStack)((ItemStack)recipe.input), (ItemStack)input, (boolean)false)) {
                return recipe;
            }
            if (!(recipe.input instanceof String) || !ApiUtils.compareToOreName(input, (String)recipe.input)) continue;
            return recipe;
        }
        return null;
    }

    public static List<FermenterRecipe> removeFermenterRecipes(ItemStack stack) {
        ArrayList<FermenterRecipe> list = new ArrayList<FermenterRecipe>();
        Iterator<FermenterRecipe> it = fermenterList.iterator();
        while (it.hasNext()) {
            FermenterRecipe ir = it.next();
            if (!OreDictionary.itemMatches((ItemStack)ir.output, (ItemStack)stack, (boolean)true)) continue;
            list.add(ir);
            it.remove();
        }
        return list;
    }

    public static Map<String, Integer> getEthanolValuesSorted(boolean inverse) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (FermenterRecipe recipe : fermenterList) {
            if (recipe.fluid == null || recipe.fluid.getFluid() != IEContent.fluidEthanol) continue;
            if (recipe.input instanceof String) {
                map.put((String)recipe.input, recipe.fluid.amount);
                continue;
            }
            if (!(recipe.input instanceof ItemStack)) continue;
            map.put(((ItemStack)recipe.input).func_82833_r(), recipe.fluid.amount);
        }
        return ApiUtils.sortMap(map, inverse);
    }

    public static void addRefineryRecipe(FluidStack input0, FluidStack input1, FluidStack output) {
        refineryList.add(new RefineryRecipe(input0, input1, output));
    }

    public static RefineryRecipe findIncompleteRefineryRecipe(FluidStack input0, FluidStack input1) {
        if (input0 == null && input1 == null) {
            return null;
        }
        for (RefineryRecipe recipe : refineryList) {
            if (!(input0 != null && input1 == null ? input0.isFluidEqual(recipe.input0) || input0.isFluidEqual(recipe.input1) : (input0 == null && input1 != null ? input1.isFluidEqual(recipe.input0) || input1.isFluidEqual(recipe.input1) : input0.isFluidEqual(recipe.input0) && input1.isFluidEqual(recipe.input1) || input0.isFluidEqual(recipe.input1) && input1.isFluidEqual(recipe.input0)))) continue;
            return recipe;
        }
        return null;
    }

    public static RefineryRecipe findRefineryRecipe(FluidStack input0, FluidStack input1) {
        if (input0 == null || input1 == null) {
            return null;
        }
        for (RefineryRecipe recipe : refineryList) {
            if ((!input0.isFluidEqual(recipe.input0) || !input1.isFluidEqual(recipe.input1)) && (!input0.isFluidEqual(recipe.input1) || !input1.isFluidEqual(recipe.input0))) continue;
            return recipe;
        }
        return null;
    }

    public static class RefineryRecipe {
        public final FluidStack input0;
        public final FluidStack input1;
        public final FluidStack output;

        public RefineryRecipe(FluidStack input0, FluidStack input1, FluidStack output) {
            this.input0 = input0;
            this.input1 = input1;
            this.output = output;
        }
    }

    public static class FermenterRecipe {
        public final Object input;
        public final ItemStack output;
        public final int time;
        public final FluidStack fluid;

        public FermenterRecipe(Object input, int time, FluidStack fluid, ItemStack itemOutput) {
            this.input = input instanceof Item ? new ItemStack((Item)input) : (input instanceof Block ? new ItemStack((Block)input) : input);
            this.output = itemOutput;
            this.time = time;
            this.fluid = fluid;
        }
    }

    public static class SqueezerRecipe {
        public final Object input;
        public final ItemStack output;
        public final int time;
        public final FluidStack fluid;

        public SqueezerRecipe(Object input, int time, FluidStack fluid, ItemStack itemOutput) {
            this.input = input instanceof Item ? new ItemStack((Item)input) : (input instanceof Block ? new ItemStack((Block)input) : input);
            this.output = itemOutput;
            this.time = time;
            this.fluid = fluid;
        }
    }
}

