/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.aquatweaks.api.IAquaConnectable;
import blusunrize.immersiveengineering.client.render.BlockRenderMetalDecoration;
import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.ItemBlockMetalDecorations;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorStructural;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityLantern;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityStructuralArm;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityWallmountMetal;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWallmount;
import blusunrize.immersiveengineering.common.util.Utils;
import cpw.mods.fml.common.Optional;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="blusunrize.aquatweaks.api.IAquaConnectable", modid="AquaTweaks")
public class BlockMetalDecoration
extends BlockIEBase
implements IAquaConnectable {
    public static int META_fence = 0;
    public static int META_scaffolding = 1;
    public static int META_lantern = 2;
    public static int META_structuralArm = 3;
    public static int META_radiator = 4;
    public static int META_heavyEngineering = 5;
    public static int META_generator = 6;
    public static int META_lightEngineering = 7;
    public static int META_connectorStructural = 8;
    public static int META_wallMount = 9;

    public BlockMetalDecoration() {
        super("metalDecoration", Material.field_151573_f, 3, ItemBlockMetalDecorations.class, "fence", "scaffolding", "lantern", "structuralArm", "radiator", "heavyEngineering", "generator", "lightEngineering", "connectorStructural", "wallMount");
        this.func_149711_c(3.0f);
        this.func_149752_b(15.0f);
    }

    public int func_149645_b() {
        return BlockRenderMetalDecoration.renderID;
    }

    @Override
    public int func_149692_a(int meta) {
        return super.func_149692_a(meta);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList ret = super.getDrops(world, x, y, z, metadata, fortune);
        return ret;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == META_lantern) {
            return 15;
        }
        return 0;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity ent) {
        if (world.func_72805_g(x, y, z) == META_scaffolding) {
            float f5 = 0.15f;
            if (ent.field_70159_w < (double)(-f5)) {
                ent.field_70159_w = -f5;
            }
            if (ent.field_70159_w > (double)f5) {
                ent.field_70159_w = f5;
            }
            if (ent.field_70179_y < (double)(-f5)) {
                ent.field_70179_y = -f5;
            }
            if (ent.field_70179_y > (double)f5) {
                ent.field_70179_y = f5;
            }
            ent.field_70143_R = 0.0f;
            if (ent.field_70181_x < -0.15) {
                ent.field_70181_x = -0.15;
            }
            if (ent.field_70181_x < 0.0 && ent instanceof EntityPlayer && ent.func_70093_af()) {
                ent.field_70181_x = 0.05;
                return;
            }
            if (ent.field_70123_F) {
                ent.field_70181_x = 0.2;
            }
        }
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == META_fence) {
            return side == ForgeDirection.UP;
        }
        if (meta == META_scaffolding) {
            return true;
        }
        if (world.func_147438_o(x, y, z) instanceof TileEntityStructuralArm) {
            if (side == ForgeDirection.UP) {
                return ((TileEntityStructuralArm)world.func_147438_o((int)x, (int)y, (int)z)).inverted;
            }
            if (side == ForgeDirection.DOWN) {
                return !((TileEntityStructuralArm)world.func_147438_o((int)x, (int)y, (int)z)).inverted;
            }
            return ((TileEntityStructuralArm)world.func_147438_o((int)x, (int)y, (int)z)).facing == side.getOpposite().ordinal();
        }
        if (meta == META_radiator || meta == META_heavyEngineering || meta == META_generator || meta == META_lightEngineering) {
            return true;
        }
        if (world.func_147438_o(x, y, z) instanceof TileEntityWallmount) {
            if (side == ForgeDirection.UP) {
                return ((TileEntityWallmount)world.func_147438_o((int)x, (int)y, (int)z)).inverted;
            }
            if (side == ForgeDirection.DOWN) {
                return !((TileEntityWallmount)world.func_147438_o((int)x, (int)y, (int)z)).inverted;
            }
            return true;
        }
        return super.isSideSolid(world, x, y, z, side);
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x + (side == 4 ? 1 : (side == 5 ? -1 : 0)), y + (side == 0 ? 1 : (side == 1 ? -1 : 0)), z + (side == 2 ? 1 : (side == 3 ? -1 : 0)));
        if (meta == META_scaffolding) {
            return world.func_147439_a(x, y, z) != this || world.func_72805_g(x, y, z) != 1;
        }
        if (meta == META_fence) {
            return true;
        }
        return super.func_149646_a(world, x, y, z, side);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.icons[BlockMetalDecoration.META_fence][0] = iconRegister.func_94245_a("immersiveengineering:storage_Steel");
        this.icons[BlockMetalDecoration.META_fence][1] = iconRegister.func_94245_a("immersiveengineering:storage_Steel");
        this.icons[BlockMetalDecoration.META_fence][2] = iconRegister.func_94245_a("immersiveengineering:storage_Steel");
        this.icons[BlockMetalDecoration.META_scaffolding][0] = iconRegister.func_94245_a("immersiveengineering:metalDeco_scaffolding_top");
        this.icons[BlockMetalDecoration.META_scaffolding][1] = iconRegister.func_94245_a("immersiveengineering:metalDeco_scaffolding_top");
        this.icons[BlockMetalDecoration.META_scaffolding][2] = iconRegister.func_94245_a("immersiveengineering:metalDeco_scaffolding_side");
        this.icons[BlockMetalDecoration.META_lantern][0] = iconRegister.func_94245_a("immersiveengineering:lantern_0");
        this.icons[BlockMetalDecoration.META_lantern][1] = iconRegister.func_94245_a("immersiveengineering:metalDeco_lantern_top");
        this.icons[BlockMetalDecoration.META_lantern][2] = iconRegister.func_94245_a("immersiveengineering:metalDeco_lantern_side");
        this.icons[BlockMetalDecoration.META_structuralArm][0] = iconRegister.func_94245_a("immersiveengineering:metalDeco_scaffolding_top");
        this.icons[BlockMetalDecoration.META_structuralArm][1] = iconRegister.func_94245_a("immersiveengineering:metalDeco_scaffolding_top");
        this.icons[BlockMetalDecoration.META_structuralArm][2] = iconRegister.func_94245_a("immersiveengineering:metalDeco_scaffolding_side");
        for (int i = 0; i < 3; ++i) {
            this.icons[BlockMetalDecoration.META_radiator][i] = iconRegister.func_94245_a("immersiveengineering:metalDeco_radiator");
            this.icons[BlockMetalDecoration.META_heavyEngineering][i] = iconRegister.func_94245_a("immersiveengineering:metalDeco_engine");
            this.icons[BlockMetalDecoration.META_generator][i] = iconRegister.func_94245_a("immersiveengineering:metalDeco_generator");
            this.icons[BlockMetalDecoration.META_lightEngineering][i] = iconRegister.func_94245_a("immersiveengineering:metalDeco_electricMachine");
            this.icons[BlockMetalDecoration.META_connectorStructural][i] = iconRegister.func_94245_a("immersiveengineering:metalDeco_connectorStructural");
            this.icons[BlockMetalDecoration.META_wallMount][i] = iconRegister.func_94245_a("immersiveengineering:metalDeco_wallmount");
        }
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == META_fence) {
            this.func_149676_a(this.canConnectFenceTo(world, x - 1, y, z) ? 0.0f : 0.375f, 0.0f, this.canConnectFenceTo(world, x, y, z - 1) ? 0.0f : 0.375f, this.canConnectFenceTo(world, x + 1, y, z) ? 1.0f : 0.625f, 1.0f, this.canConnectFenceTo(world, x, y, z + 1) ? 1.0f : 0.625f);
        } else if (world.func_147438_o(x, y, z) instanceof TileEntityLantern) {
            int f = ((TileEntityLantern)world.func_147438_o((int)x, (int)y, (int)z)).facing;
            if (f < 2) {
                this.func_149676_a(0.25f, f == 1 ? 0.0f : 0.125f, 0.25f, 0.75f, f == 1 ? 0.875f : 1.0f, 0.75f);
            } else {
                this.func_149676_a(f == 5 ? 0.0f : 0.25f, 0.0f, f == 3 ? 0.0f : 0.25f, f == 4 ? 1.0f : 0.75f, 0.875f, f == 2 ? 1.0f : 0.75f);
            }
        } else if (world.func_147438_o(x, y, z) instanceof TileEntityConnectorStructural) {
            float length = 0.5f;
            switch (((TileEntityConnectorStructural)world.func_147438_o((int)x, (int)y, (int)z)).facing) {
                case 0: {
                    this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, length, 0.75f);
                    break;
                }
                case 1: {
                    this.func_149676_a(0.25f, 1.0f - length, 0.25f, 0.75f, 1.0f, 0.75f);
                    break;
                }
                case 2: {
                    this.func_149676_a(0.25f, 0.25f, 0.0f, 0.75f, 0.75f, length);
                    break;
                }
                case 3: {
                    this.func_149676_a(0.25f, 0.25f, 1.0f - length, 0.75f, 0.75f, 1.0f);
                    break;
                }
                case 4: {
                    this.func_149676_a(0.0f, 0.25f, 0.25f, length, 0.75f, 0.75f);
                    break;
                }
                case 5: {
                    this.func_149676_a(1.0f - length, 0.25f, 0.25f, 1.0f, 0.75f, 0.75f);
                }
            }
        } else if (world.func_147438_o(x, y, z) instanceof TileEntityWallmount) {
            TileEntityWallmount arm = (TileEntityWallmount)world.func_147438_o(x, y, z);
            int f = arm.facing;
            if (arm.sideAttached > 0) {
                this.func_149676_a(f == 4 ? 0.0f : (f == 5 ? 0.375f : 0.3125f), arm.inverted ? 0.3125f : 0.0f, f == 2 ? 0.0f : (f == 3 ? 0.375f : 0.3125f), f == 5 ? 1.0f : (f == 4 ? 0.625f : 0.6875f), arm.inverted ? 1.0f : 0.6875f, f == 3 ? 1.0f : (f == 2 ? 0.625f : 0.6875f));
            } else {
                this.func_149676_a(f == 5 ? 0.0f : 0.3125f, arm.inverted ? 0.375f : 0.0f, f == 3 ? 0.0f : 0.3125f, f == 4 ? 1.0f : 0.6875f, arm.inverted ? 1.0f : 0.625f, f == 2 ? 1.0f : 0.6875f);
            }
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public boolean canConnectFenceTo(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block != this && block != Blocks.field_150396_be ? (block.func_149688_o().func_76218_k() && block.func_149686_d() ? block.func_149688_o() != Material.field_151572_C : false) : true;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity ent) {
        super.func_149743_a(world, x, y, z, aabb, list, ent);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == META_fence) {
            this.func_149676_a(this.canConnectFenceTo((IBlockAccess)world, x - 1, y, z) ? 0.0f : 0.375f, 0.0f, this.canConnectFenceTo((IBlockAccess)world, x, y, z - 1) ? 0.0f : 0.375f, this.canConnectFenceTo((IBlockAccess)world, x + 1, y, z) ? 1.0f : 0.625f, 1.5f, this.canConnectFenceTo((IBlockAccess)world, x, y, z + 1) ? 1.0f : 0.625f);
        } else if (world.func_72805_g(x, y, z) == META_scaffolding) {
            this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 1.0f, 0.9375f);
        } else {
            this.func_149719_a((IBlockAccess)world, x, y, z);
        }
        return super.func_149668_a(world, x, y, z);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta == META_lantern) {
            return new TileEntityLantern();
        }
        if (meta == META_structuralArm) {
            return new TileEntityStructuralArm();
        }
        if (meta == META_connectorStructural) {
            return new TileEntityConnectorStructural();
        }
        if (meta == META_wallMount) {
            return new TileEntityWallmountMetal();
        }
        return null;
    }

    @Override
    public boolean allowHammerHarvest(int metadata) {
        return true;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.func_147438_o(x, y, z) instanceof TileEntityConnectorStructural && Utils.isHammer(player.func_71045_bC())) {
            ((TileEntityConnectorStructural)world.func_147438_o((int)x, (int)y, (int)z)).rotation += 22.5f;
            ((TileEntityConnectorStructural)world.func_147438_o((int)x, (int)y, (int)z)).rotation %= 360.0f;
            world.func_147438_o(x, y, z).func_70296_d();
            world.func_147471_g(x, y, z);
            return true;
        }
        return false;
    }

    @Optional.Method(modid="AquaTweaks")
    public boolean shouldRenderFluid(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return meta == META_fence || meta == META_lantern || meta == META_connectorStructural || meta == META_wallMount;
    }

    @Optional.Method(modid="AquaTweaks")
    public boolean canConnectTo(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        return meta == META_fence || meta == META_lantern || meta == META_connectorStructural || meta == META_wallMount;
    }
}

