/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockBucketWheel;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityBucketWheel
extends TileEntityMultiblockPart {
    public int facing = 2;
    public float rotation = 0.0f;
    public ItemStack[] digStacks = new ItemStack[8];
    public boolean active = false;

    @Override
    public ItemStack getOriginalBlock() {
        ItemStack s = this.pos < 0 ? null : MultiblockBucketWheel.instance.getStructureManual()[this.pos / 7][this.pos % 7][0];
        return s != null ? s.func_77946_l() : null;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = nbt.func_74762_e("facing");
        this.rotation = nbt.func_74760_g("rotation");
        NBTTagList invList = nbt.func_150295_c("digStacks", 10);
        this.digStacks = new ItemStack[8];
        for (int i = 0; i < invList.func_74745_c(); ++i) {
            NBTTagCompound itemTag = invList.func_150305_b(i);
            int slot = itemTag.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= this.digStacks.length) continue;
            this.digStacks[slot] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
        }
        this.active = nbt.func_74767_n("active");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("facing", this.facing);
        nbt.func_74776_a("rotation", this.rotation);
        NBTTagList invList = new NBTTagList();
        for (int i = 0; i < this.digStacks.length; ++i) {
            if (this.digStacks[i] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            this.digStacks[i].func_77955_b(itemTag);
            invList.func_74742_a((NBTBase)itemTag);
        }
        nbt.func_74782_a("digStacks", (NBTBase)invList);
        nbt.func_74757_a("active", this.active);
    }

    public void func_145845_h() {
        if (!this.formed || this.pos != 24) {
            return;
        }
        if (this.active) {
            this.rotation += (float)Config.getDouble("excavator_speed");
            this.rotation %= 360.0f;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.formed && !this.field_145850_b.field_72995_K) {
            int f = this.facing;
            int startX = this.field_145851_c - this.offset[0];
            int startY = this.field_145848_d - this.offset[1];
            int startZ = this.field_145849_e - this.offset[2];
            for (int w = -3; w <= 3; ++w) {
                for (int h = -3; h <= 3; ++h) {
                    int xx = f == 3 ? -w : (f == 2 ? w : 0);
                    int yy = h;
                    int zz = f == 5 ? -w : (f == 4 ? w : 0);
                    ItemStack s = null;
                    if (this.field_145850_b.func_147438_o(startX + xx, startY + yy, startZ + zz) instanceof TileEntityBucketWheel) {
                        s = ((TileEntityBucketWheel)this.field_145850_b.func_147438_o(startX + xx, startY + yy, startZ + zz)).getOriginalBlock();
                        ((TileEntityBucketWheel)this.field_145850_b.func_147438_o((int)(startX + xx), (int)(startY + yy), (int)(startZ + zz))).formed = false;
                    }
                    if (startX + xx == this.field_145851_c && startY + yy == this.field_145848_d && startZ + zz == this.field_145849_e) {
                        s = this.getOriginalBlock();
                    }
                    if (s == null || Block.func_149634_a((Item)s.func_77973_b()) == null) continue;
                    if (startX + xx == this.field_145851_c && startY + yy == this.field_145848_d && startZ + zz == this.field_145849_e) {
                        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, s));
                        continue;
                    }
                    if (Block.func_149634_a((Item)s.func_77973_b()) == IEContent.blockMetalMultiblocks) {
                        this.field_145850_b.func_147468_f(startX + xx, startY + yy, startZ + zz);
                    }
                    this.field_145850_b.func_147465_d(startX + xx, startY + yy, startZ + zz, Block.func_149634_a((Item)s.func_77973_b()), s.func_77960_j(), 3);
                }
            }
        }
    }

    public boolean func_145842_c(int id, int arg) {
        try {
            if (id < 1) {
                this.active = arg == 1;
            } else if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                if (id == 1) {
                    int meta;
                    Block block = Block.func_149729_e((int)(arg & 0xFFF));
                    ItemStack ss = new ItemStack(block, 1, meta = arg >> 12 & 0xFF);
                    if (ss != null) {
                        ImmersiveEngineering.proxy.spawnBucketWheelFX(this, ss);
                    }
                } else if (id < 10) {
                    int target = id - 2;
                    if (arg <= 0) {
                        this.digStacks[target] = null;
                    } else {
                        ItemStack ss;
                        Block block = Block.func_149729_e((int)(arg & 0xFFF));
                        int meta = arg >> 12 & 0xFF;
                        this.digStacks[target] = ss = new ItemStack(block, 1, meta);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.pos == 24) {
            return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - (this.facing < 4 ? 3 : 0)), (double)(this.field_145848_d - 3), (double)(this.field_145849_e - (this.facing > 3 ? 3 : 0)), (double)(this.field_145851_c + (this.facing < 4 ? 4 : 1)), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + (this.facing > 3 ? 4 : 1)));
        }
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
    }

    public double func_145833_n() {
        return super.func_145833_n() * Config.getDouble("increasedTileRenderdistance");
    }

    @Override
    public float[] getBlockBounds() {
        if (this.pos == 3 || this.pos == 9 || this.pos == 11) {
            return new float[]{0.0f, 0.25f, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        if (this.pos == 45 || this.pos == 37 || this.pos == 39) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f};
        }
        if (this.pos == 21) {
            return new float[]{this.facing == 2 ? 0.25f : 0.0f, 0.0f, this.facing == 4 ? 0.25f : 0.0f, this.facing == 3 ? 0.75f : 1.0f, 1.0f, this.facing == 5 ? 0.75f : 1.0f};
        }
        if (this.pos == 27) {
            return new float[]{this.facing == 3 ? 0.25f : 0.0f, 0.0f, this.facing == 5 ? 0.25f : 0.0f, this.facing == 2 ? 0.75f : 1.0f, 1.0f, this.facing == 4 ? 0.75f : 1.0f};
        }
        if (this.pos == 15 || this.pos == 29) {
            return new float[]{this.facing == 2 ? 0.25f : 0.0f, 0.0f, this.facing == 4 ? 0.25f : 0.0f, this.facing == 3 ? 0.75f : 1.0f, 1.0f, this.facing == 5 ? 0.75f : 1.0f};
        }
        if (this.pos == 19 || this.pos == 33) {
            return new float[]{this.facing == 3 ? 0.25f : 0.0f, 0.0f, this.facing == 5 ? 0.25f : 0.0f, this.facing == 2 ? 0.75f : 1.0f, 1.0f, this.facing == 4 ? 0.75f : 1.0f};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }
}

