/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBucketWheel;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockExcavator;
import blusunrize.immersiveengineering.common.util.FakePlayerUtil;
import blusunrize.immersiveengineering.common.util.Utils;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityExcavator
extends TileEntityMultiblockPart
implements IEnergyReceiver {
    public int facing = 2;
    public EnergyStorage energyStorage = new EnergyStorage(64000);
    public boolean active = false;
    public int process = 0;
    public int lastPowerInput = 0;

    @Override
    public ItemStack getOriginalBlock() {
        try {
            int h = this.pos % 9 / 3;
            int l = this.pos / 9;
            int w = this.pos % 3;
            ItemStack s = MultiblockExcavator.instance.getStructureManual()[h][5 - l][w];
            return s != null ? s.func_77946_l() : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public TileEntityExcavator master() {
        if (this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c - this.offset[0], this.field_145848_d - this.offset[1], this.field_145849_e - this.offset[2]);
        return te instanceof TileEntityExcavator ? (TileEntityExcavator)te : null;
    }

    public void func_145845_h() {
        if (!this.formed || this.pos != 4) {
            return;
        }
        int[] wheelAxis = new int[]{this.field_145851_c + (this.facing == 5 ? -4 : (this.facing == 4 ? 4 : 0)), this.field_145848_d, this.field_145849_e + (this.facing == 3 ? -4 : (this.facing == 2 ? 4 : 0))};
        int ff = ForgeDirection.ROTATION_MATRIX[this.facing][1];
        float rot = 0.0f;
        int target = -1;
        TileEntityBucketWheel wheel = null;
        if (this.field_145850_b.func_147438_o(wheelAxis[0], wheelAxis[1], wheelAxis[2]) instanceof TileEntityBucketWheel && ((TileEntityBucketWheel)this.field_145850_b.func_147438_o((int)wheelAxis[0], (int)wheelAxis[1], (int)wheelAxis[2])).facing == ff) {
            wheel = (TileEntityBucketWheel)this.field_145850_b.func_147438_o(wheelAxis[0], wheelAxis[1], wheelAxis[2]);
            if (this.active != wheel.active) {
                this.field_145850_b.func_147452_c(wheel.field_145851_c, wheel.field_145848_d, wheel.field_145849_e, wheel.func_145838_q(), 0, this.active ? 1 : 0);
            }
            if ((rot = wheel.rotation) % 45.0f > 40.0f) {
                target = Math.round(rot / 360.0f * 8.0f) % 8;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_147438_o(wheelAxis[0], wheelAxis[1], wheelAxis[2]) instanceof TileEntityBucketWheel && (((TileEntityBucketWheel)this.field_145850_b.func_147438_o((int)wheelAxis[0], (int)wheelAxis[1], (int)wheelAxis[2])).facing != ff || ((TileEntityBucketWheel)this.field_145850_b.func_147438_o((int)wheelAxis[0], (int)wheelAxis[1], (int)wheelAxis[2])).mirrored != this.mirrored)) {
                for (int h = -3; h <= 3; ++h) {
                    for (int w = -3; w <= 3; ++w) {
                        TileEntity te = this.field_145850_b.func_147438_o(wheelAxis[0] + (this.facing > 3 ? w : 0), wheelAxis[1] + h, wheelAxis[2] + (this.facing < 4 ? w : 0));
                        if (!(te instanceof TileEntityBucketWheel)) continue;
                        ((TileEntityBucketWheel)te).facing = ff;
                        ((TileEntityBucketWheel)te).mirrored = this.mirrored;
                        te.func_70296_d();
                        this.field_145850_b.func_147471_g(te.field_145851_c, te.field_145848_d, te.field_145849_e);
                    }
                }
            }
            boolean update = false;
            ExcavatorHandler.MineralMix mineral = ExcavatorHandler.getRandomMineral(this.field_145850_b, wheelAxis[0] >> 4, wheelAxis[2] >> 4);
            if (wheel != null && !this.field_145850_b.func_72864_z(this.field_145851_c + (this.facing == 3 ? -1 : (this.facing == 2 ? 1 : 0)) * (this.mirrored ? -1 : 1), this.field_145848_d, this.field_145849_e + (this.facing == 4 ? -1 : (this.facing == 5 ? 1 : 0)) * (this.mirrored ? -1 : 1))) {
                int consumed = Config.getInt("excavator_consumption");
                int extracted = this.energyStorage.extractEnergy(consumed, true);
                if (extracted >= consumed) {
                    this.energyStorage.extractEnergy(consumed, false);
                    this.active = true;
                    update = true;
                    if (target >= 0 && target < 8) {
                        if (wheel.digStacks[(target + 4) % 8] == null) {
                            ItemStack blocking = this.digBlocksInTheWay(wheel);
                            if (blocking != null) {
                                wheel.digStacks[(target + 4) % 8] = blocking;
                                this.field_145850_b.func_147452_c(wheel.field_145851_c, wheel.field_145848_d, wheel.field_145849_e, wheel.func_145838_q(), (target + 4) % 8 + 2, Block.func_149682_b((Block)Block.func_149634_a((Item)blocking.func_77973_b())) + (blocking.func_77960_j() << 12));
                                wheel.func_70296_d();
                            } else if (!(mineral == null || this.field_145850_b.func_147437_c(wheel.field_145851_c + (this.facing == 5 ? 2 : (this.facing == 4 ? -2 : 0)), wheel.field_145848_d - 5, wheel.field_145849_e + (this.facing == 3 ? 2 : (this.facing == 2 ? -2 : 0))) || this.field_145850_b.func_147437_c(wheel.field_145851_c + (this.facing == 5 ? -2 : (this.facing == 4 ? 2 : 0)), wheel.field_145848_d - 5, wheel.field_145849_e + (this.facing == 3 ? -2 : (this.facing == 2 ? 2 : 0))) || this.field_145850_b.func_147437_c(wheel.field_145851_c + (this.facing == 5 ? 1 : (this.facing == 4 ? -1 : 0)), wheel.field_145848_d - 5, wheel.field_145849_e + (this.facing == 3 ? 1 : (this.facing == 2 ? -1 : 0))) || this.field_145850_b.func_147437_c(wheel.field_145851_c + (this.facing == 5 ? -1 : (this.facing == 4 ? 1 : 0)), wheel.field_145848_d - 5, wheel.field_145849_e + (this.facing == 3 ? -1 : (this.facing == 2 ? 1 : 0))) || this.field_145850_b.func_147437_c(wheel.field_145851_c, wheel.field_145848_d - 5, wheel.field_145849_e))) {
                                String ore = mineral.getRandomOre(this.field_145850_b.field_73012_v);
                                ItemStack output = null;
                                if (!OreDictionary.getOres((String)ore).isEmpty()) {
                                    output = (ItemStack)OreDictionary.getOres((String)ore).get(0);
                                }
                                float configChance = this.field_145850_b.field_73012_v.nextFloat();
                                float failChance = this.field_145850_b.field_73012_v.nextFloat();
                                if (output != null && (double)configChance > Config.getDouble("excavator_chance") && failChance > mineral.failChance) {
                                    wheel.digStacks[(target + 4) % 8] = output;
                                    this.field_145850_b.func_147452_c(wheel.field_145851_c, wheel.field_145848_d, wheel.field_145849_e, wheel.func_145838_q(), (target + 4) % 8 + 2, Block.func_149682_b((Block)Block.func_149634_a((Item)output.func_77973_b())) + (output.func_77960_j() << 12));
                                    wheel.func_70296_d();
                                }
                                ExcavatorHandler.depleteMinerals(this.field_145850_b, wheelAxis[0] >> 4, wheelAxis[2] >> 4);
                            }
                        }
                        if (wheel.digStacks[target] != null) {
                            this.outputItem(wheel.digStacks[target].func_77946_l());
                            Block b = Block.func_149634_a((Item)wheel.digStacks[target].func_77973_b());
                            if (b != null && b != Blocks.field_150350_a) {
                                this.field_145850_b.func_147452_c(wheel.field_145851_c, wheel.field_145848_d, wheel.field_145849_e, wheel.func_145838_q(), 1, Block.func_149682_b((Block)b) + (wheel.digStacks[target].func_77960_j() << 12));
                            }
                            wheel.digStacks[target] = null;
                            this.field_145850_b.func_147452_c(wheel.field_145851_c, wheel.field_145848_d, wheel.field_145849_e, wheel.func_145838_q(), target + 2, 0);
                            wheel.func_70296_d();
                        }
                    }
                } else {
                    this.active = false;
                    update = true;
                }
            } else if (this.active) {
                this.active = false;
                update = true;
            }
            if (update) {
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public void outputItem(ItemStack stack) {
        ForgeDirection fd = ForgeDirection.getOrientation((int)this.facing);
        TileEntity inventory = this.field_145850_b.func_147438_o(this.field_145851_c + fd.offsetX, this.field_145848_d, this.field_145849_e + fd.offsetZ);
        if (this.isInventory(inventory, ForgeDirection.OPPOSITES[this.facing])) {
            stack = Utils.insertStackIntoInventory((IInventory)inventory, stack, ForgeDirection.OPPOSITES[this.facing]);
        }
        if (stack != null) {
            EntityItem ei = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5 + (double)fd.offsetX, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5 + (double)fd.offsetZ, stack.func_77946_l());
            ei.field_70159_w = 0.075f * (float)fd.offsetX;
            ei.field_70181_x = 0.025000000372529;
            ei.field_70179_y = 0.075f * (float)fd.offsetZ;
            this.field_145850_b.func_72838_d((Entity)ei);
        }
    }

    boolean isInventory(TileEntity tile, int side) {
        if (tile instanceof ISidedInventory && ((ISidedInventory)tile).func_94128_d(side).length > 0) {
            return true;
        }
        return tile instanceof IInventory && ((IInventory)tile).func_70302_i_() > 0;
    }

    ItemStack digBlocksInTheWay(TileEntityBucketWheel wheel) {
        ItemStack s = this.digBlock(wheel.field_145851_c, wheel.field_145848_d - 4, wheel.field_145849_e);
        if (s != null) {
            return s;
        }
        s = this.digBlock(wheel.field_145851_c + (this.facing == 5 ? 1 : (this.facing == 4 ? -1 : 0)), wheel.field_145848_d - 4, wheel.field_145849_e + (this.facing == 3 ? 1 : (this.facing == 2 ? -1 : 0)));
        if (s != null) {
            return s;
        }
        s = this.digBlock(wheel.field_145851_c + (this.facing == 5 ? 2 : (this.facing == 4 ? -2 : 0)), wheel.field_145848_d - 4, wheel.field_145849_e + (this.facing == 3 ? 2 : (this.facing == 2 ? -2 : 0)));
        if (s != null) {
            return s;
        }
        s = this.digBlock(wheel.field_145851_c + (this.facing == 5 ? -1 : (this.facing == 4 ? 1 : 0)), wheel.field_145848_d - 4, wheel.field_145849_e + (this.facing == 3 ? -1 : (this.facing == 2 ? 1 : 0)));
        if (s != null) {
            return s;
        }
        s = this.digBlock(wheel.field_145851_c + (this.facing == 5 ? -2 : (this.facing == 4 ? 2 : 0)), wheel.field_145848_d - 4, wheel.field_145849_e + (this.facing == 3 ? -2 : (this.facing == 2 ? 2 : 0)));
        if (s != null) {
            return s;
        }
        s = this.digBlock(wheel.field_145851_c + (this.facing == 5 ? 1 : (this.facing == 4 ? -1 : 1)), wheel.field_145848_d - 4, wheel.field_145849_e + (this.facing == 3 ? 1 : (this.facing == 2 ? -1 : 1)));
        if (s != null) {
            return s;
        }
        s = this.digBlock(wheel.field_145851_c + (this.facing == 5 ? 1 : (this.facing == 4 ? -1 : -1)), wheel.field_145848_d - 4, wheel.field_145849_e + (this.facing == 3 ? 1 : (this.facing == 2 ? -1 : -1)));
        if (s != null) {
            return s;
        }
        s = this.digBlock(wheel.field_145851_c + (this.facing < 4 ? 1 : 0), wheel.field_145848_d - 4, wheel.field_145849_e + (this.facing > 3 ? 1 : 0));
        if (s != null) {
            return s;
        }
        s = this.digBlock(wheel.field_145851_c + (this.facing < 4 ? -1 : 0), wheel.field_145848_d - 4, wheel.field_145849_e + (this.facing > 3 ? -1 : 0));
        if (s != null) {
            return s;
        }
        s = this.digBlock(wheel.field_145851_c + (this.facing == 5 ? -1 : (this.facing == 4 ? 1 : 1)), wheel.field_145848_d - 4, wheel.field_145849_e + (this.facing == 3 ? -1 : (this.facing == 2 ? 1 : 1)));
        if (s != null) {
            return s;
        }
        s = this.digBlock(wheel.field_145851_c + (this.facing == 5 ? -1 : (this.facing == 4 ? 1 : -1)), wheel.field_145848_d - 4, wheel.field_145849_e + (this.facing == 3 ? -1 : (this.facing == 2 ? 1 : -1)));
        if (s != null) {
            return s;
        }
        return null;
    }

    ItemStack digBlock(int x, int y, int z) {
        if (!(this.field_145850_b instanceof WorldServer)) {
            return null;
        }
        FakePlayer fakePlayer = FakePlayerUtil.getFakePlayer((WorldServer)this.field_145850_b);
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        int meta = this.field_145850_b.func_72805_g(x, y, z);
        if (block != null && !this.field_145850_b.func_147437_c(x, y, z) && block.func_149737_a((EntityPlayer)fakePlayer, this.field_145850_b, x, y, z) != 0.0f) {
            if (!block.canHarvestBlock((EntityPlayer)fakePlayer, meta)) {
                return null;
            }
            block.func_149681_a(this.field_145850_b, x, y, z, meta, (EntityPlayer)fakePlayer);
            if (block.removedByPlayer(this.field_145850_b, (EntityPlayer)fakePlayer, x, y, z, true)) {
                block.func_149664_b(this.field_145850_b, x, y, z, meta);
                if (block.canSilkHarvest(this.field_145850_b, (EntityPlayer)fakePlayer, x, y, z, meta)) {
                    ItemStack itemstack;
                    ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                    Item bitem = Item.func_150898_a((Block)block);
                    if (bitem == null) {
                        return null;
                    }
                    int m = 0;
                    if (bitem != null && bitem.func_77614_k()) {
                        m = meta;
                    }
                    if ((itemstack = new ItemStack(bitem, 1, m)) != null) {
                        items.add(itemstack);
                    }
                    ForgeEventFactory.fireBlockHarvesting(items, (World)this.field_145850_b, (Block)block, (int)x, (int)y, (int)z, (int)meta, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)fakePlayer);
                    for (int i = 0; i < items.size(); ++i) {
                        if (i == 0) continue;
                        EntityItem ei = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, ((ItemStack)items.get(i)).func_77946_l());
                        this.field_145850_b.func_72838_d((Entity)ei);
                    }
                    this.field_145850_b.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12));
                    if (items.size() > 0) {
                        return (ItemStack)items.get(0);
                    }
                } else {
                    block.func_149636_a(this.field_145850_b, (EntityPlayer)fakePlayer, x, y, z, meta);
                    this.field_145850_b.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12));
                }
            }
        }
        return null;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = nbt.func_74762_e("facing");
        this.active = nbt.func_74767_n("active");
        this.process = nbt.func_74762_e("process");
        this.lastPowerInput = nbt.func_74762_e("lastPowerInput");
        this.energyStorage.readFromNBT(nbt);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("facing", this.facing);
        nbt.func_74757_a("active", this.active);
        nbt.func_74768_a("process", this.process);
        nbt.func_74768_a("lastPowerInput", this.lastPowerInput);
        this.energyStorage.writeToNBT(nbt);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.formed && !this.field_145850_b.field_72995_K) {
            int startZ;
            int startY;
            int startX;
            int[] wheelAxis;
            int f = this.facing;
            int il = this.pos / 9;
            int ih = this.pos % 9 / 3 - 1;
            int iw = this.pos % 3 - 1;
            if (this.mirrored) {
                iw = -iw;
            }
            if (this.field_145850_b.func_147438_o((wheelAxis = new int[]{(startX = this.field_145851_c - (f == 4 ? il : (f == 5 ? -il : (f == 2 ? -iw : iw)))) + (this.facing == 5 ? -4 : (this.facing == 4 ? 4 : 0)), startY = this.field_145848_d - ih, (startZ = this.field_145849_e - (f == 2 ? il : (f == 3 ? -il : (f == 5 ? -iw : iw)))) + (this.facing == 3 ? -4 : (this.facing == 2 ? 4 : 0))})[0], wheelAxis[1], wheelAxis[2]) instanceof TileEntityBucketWheel) {
                ((TileEntityBucketWheel)this.field_145850_b.func_147438_o((int)wheelAxis[0], (int)wheelAxis[1], (int)wheelAxis[2])).active = false;
                this.field_145850_b.func_147438_o(wheelAxis[0], wheelAxis[1], wheelAxis[2]).func_70296_d();
                this.field_145850_b.func_147471_g(wheelAxis[0], wheelAxis[1], wheelAxis[2]);
            }
            for (int l = 0; l < 6; ++l) {
                for (int w = -1; w <= 1; ++w) {
                    for (int h = -1; h <= 1; ++h) {
                        int ww;
                        int n = ww = this.mirrored ? -w : w;
                        int xx = f == 4 ? l : (f == 5 ? -l : (f == 2 ? -ww : ww));
                        int yy = h;
                        int zz = f == 2 ? l : (f == 3 ? -l : (f == 5 ? -ww : ww));
                        ItemStack s = null;
                        if (this.field_145850_b.func_147438_o(startX + xx, startY + yy, startZ + zz) instanceof TileEntityExcavator) {
                            s = ((TileEntityExcavator)this.field_145850_b.func_147438_o(startX + xx, startY + yy, startZ + zz)).getOriginalBlock();
                            ((TileEntityExcavator)this.field_145850_b.func_147438_o((int)(startX + xx), (int)(startY + yy), (int)(startZ + zz))).formed = false;
                        }
                        if (startX + xx == this.field_145851_c && startY + yy == this.field_145848_d && startZ + zz == this.field_145849_e) {
                            s = this.getOriginalBlock();
                        }
                        if (s == null || Block.func_149634_a((Item)s.func_77973_b()) == null) continue;
                        if (startX + xx == this.field_145851_c && startY + yy == this.field_145848_d && startZ + zz == this.field_145849_e) {
                            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, s));
                            continue;
                        }
                        if (Block.func_149634_a((Item)s.func_77973_b()) == IEContent.blockMetalMultiblocks) {
                            this.field_145850_b.func_147468_f(startX + xx, startY + yy, startZ + zz);
                        }
                        this.field_145850_b.func_147465_d(startX + xx, startY + yy, startZ + zz, Block.func_149634_a((Item)s.func_77973_b()), s.func_77960_j(), 3);
                    }
                }
            }
        }
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.formed && (this.pos == 11 || this.pos == 14 || this.pos == 17) && from != ForgeDirection.UP && from != ForgeDirection.DOWN;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.formed && this.master() != null && (this.pos == 11 || this.pos == 14 || this.pos == 17) && from != ForgeDirection.UP && from != ForgeDirection.DOWN) {
            int rec;
            TileEntityExcavator master = this.master();
            this.lastPowerInput = rec = master.energyStorage.receiveEnergy(maxReceive, simulate);
            master.func_70296_d();
            this.field_145850_b.func_147471_g(master.field_145851_c, master.field_145848_d, master.field_145849_e);
            return rec;
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (this.master() != null) {
            return this.master().energyStorage.getEnergyStored();
        }
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.master() != null) {
            return this.master().energyStorage.getMaxEnergyStored();
        }
        return this.energyStorage.getMaxEnergyStored();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.pos == 4) {
            return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - (this.facing == 5 ? 5 : (this.facing == 4 ? 0 : 1))), (double)(this.field_145848_d - 1), (double)(this.field_145849_e - (this.facing == 3 ? 5 : (this.facing == 2 ? 0 : 1))), (double)(this.field_145851_c + (this.facing == 4 ? 6 : (this.facing == 5 ? 1 : 2))), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + (this.facing == 2 ? 6 : (this.facing == 3 ? 1 : 2))));
        }
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
    }

    public double func_145833_n() {
        return super.func_145833_n() * Config.getDouble("increasedTileRenderdistance");
    }

    @Override
    public float[] getBlockBounds() {
        int fl = this.facing;
        int fw = this.facing;
        if (this.mirrored) {
            fw = ForgeDirection.OPPOSITES[fw];
        }
        if (this.pos == 42) {
            return new float[]{fl == 4 || fl == 5 ? -0.5f : 0.0f, 0.0f, fl == 2 || fl == 3 ? -0.5f : 0.0f, fl == 4 || fl == 5 ? 1.5f : 1.0f, 0.5f, fl == 2 || fl == 3 ? 1.5f : 1.0f};
        }
        if (this.pos == 29 || this.pos == 38 || this.pos == 47) {
            return new float[]{fw == 2 ? 0.25f : 0.0f, 0.0f, fw == 5 ? 0.25f : 0.0f, fw == 3 ? 0.75f : 1.0f, 1.0f, fw == 4 ? 0.75f : 1.0f};
        }
        if (this.pos == 44) {
            return new float[]{fw == 3 ? 0.875f : 0.0f, 0.0f, fw == 4 ? 0.875f : 0.0f, fw == 2 ? 0.125f : 1.0f, 1.0f, fw == 5 ? 0.125f : 1.0f};
        }
        if (this.pos == 35) {
            float[] fArray = new float[6];
            fArray[0] = fl == 5 ? 0.375f : (fl == 4 ? 0.5f : 0.0f);
            fArray[1] = 0.0f;
            float f = fl == 3 ? 0.375f : (fArray[2] = fl == 2 ? 0.5f : 0.0f);
            fArray[3] = fl == 5 ? 0.5f : (fl == 4 ? 0.625f : 1.0f);
            fArray[4] = 1.0f;
            fArray[5] = fl == 3 ? 0.5f : (fl == 2 ? 0.625f : 1.0f);
            return fArray;
        }
        if (this.pos == 53) {
            float[] fArray = new float[6];
            fArray[0] = fl == 4 ? 0.375f : (fl == 5 ? 0.5f : 0.0f);
            fArray[1] = 0.0f;
            float f = fl == 2 ? 0.375f : (fArray[2] = fl == 3 ? 0.5f : 0.0f);
            fArray[3] = fl == 4 ? 0.5f : (fl == 5 ? 0.625f : 1.0f);
            fArray[4] = 1.0f;
            fArray[5] = fl == 2 ? 0.5f : (fl == 3 ? 0.625f : 1.0f);
            return fArray;
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }
}

