/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.WireType;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.TileEntityImmersiveConnectable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;

public class TileEntityTransformer
extends TileEntityImmersiveConnectable {
    WireType secondCable;
    public int facing = 0;
    public boolean dummy = false;
    public int postAttached = 0;

    public static boolean _Immovable() {
        return true;
    }

    @Override
    protected boolean canTakeLV() {
        return true;
    }

    @Override
    protected boolean canTakeMV() {
        return true;
    }

    @Override
    public boolean canConnect() {
        return !this.dummy;
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public boolean isEnergyOutput() {
        return false;
    }

    @Override
    public int outputEnergy(int amount, boolean simulate, int energyType) {
        return 0;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("facing", this.facing);
        if (this.secondCable != null) {
            nbt.func_74778_a("secondCable", this.secondCable.getUniqueName());
        }
        nbt.func_74757_a("dummy", this.dummy);
        nbt.func_74768_a("postAttached", this.postAttached);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = nbt.func_74762_e("facing");
        if (nbt.func_74764_b("secondCable")) {
            this.secondCable = ApiUtils.getWireTypeFromNBT(nbt, "secondCable");
        }
        this.dummy = nbt.func_74767_n("dummy");
        this.postAttached = nbt.func_74762_e("postAttached");
    }

    @Override
    public boolean canConnectCable(WireType cableType, TargetingInfo target) {
        if (cableType == WireType.STEEL && !this.canTakeHV()) {
            return false;
        }
        if (this.dummy) {
            if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) instanceof TileEntityTransformer) {
                return ((TileEntityTransformer)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)).canConnectCable(cableType, target);
            }
            return false;
        }
        int tc = this.getTargetedConnector(target);
        switch (tc) {
            case 0: {
                return this.limitType == null && this.secondCable != cableType;
            }
            case 1: {
                return this.secondCable == null && this.limitType != cableType;
            }
        }
        return false;
    }

    @Override
    public void connectCable(WireType cableType, TargetingInfo target) {
        if (this.dummy) {
            if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) instanceof TileEntityTransformer) {
                ((TileEntityTransformer)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)).connectCable(cableType, target);
            } else {
                return;
            }
        }
        switch (this.getTargetedConnector(target)) {
            case 0: {
                if (this.limitType != null) break;
                this.limitType = cableType;
                break;
            }
            case 1: {
                if (this.secondCable != null) break;
                this.secondCable = cableType;
            }
        }
    }

    @Override
    public WireType getCableLimiter(TargetingInfo target) {
        switch (this.getTargetedConnector(target)) {
            case 0: {
                return this.limitType;
            }
            case 1: {
                return this.secondCable;
            }
        }
        return null;
    }

    @Override
    public void removeCable(ImmersiveNetHandler.Connection connection) {
        WireType type;
        WireType wireType = type = connection != null ? connection.cableType : null;
        if (type == null) {
            this.limitType = null;
            this.secondCable = null;
        }
        if (type == this.limitType) {
            this.limitType = null;
        }
        if (type == this.secondCable) {
            this.secondCable = null;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public Vec3 getRaytraceOffset() {
        if (this.postAttached > 0) {
            return Vec3.func_72443_a((double)0.5, (double)1.5, (double)0.5);
        }
        return Vec3.func_72443_a((double)0.5, (double)2.5, (double)0.5);
    }

    @Override
    public Vec3 getConnectionOffset(ImmersiveNetHandler.Connection con) {
        boolean b;
        boolean bl = b = con.cableType == this.limitType;
        if (this.postAttached > 0) {
            if (b) {
                return Vec3.func_72443_a((double)(0.5 + (this.postAttached == 4 ? 0.4375 : (this.postAttached == 5 ? -0.4375 : 0.0))), (double)1.4375, (double)(0.5 + (this.postAttached == 2 ? 0.4375 : (this.postAttached == 3 ? -0.4375 : 0.0))));
            }
            return Vec3.func_72443_a((double)(0.5 + (this.postAttached == 4 ? -0.0625 : (this.postAttached == 5 ? 0.0625 : 0.0))), (double)0.25, (double)(0.5 + (this.postAttached == 2 ? -0.0625 : (this.postAttached == 3 ? 0.0625 : 0.0))));
        }
        double conRadius = con.cableType.getRenderDiameter() / 2.0;
        if (this.facing == 2) {
            return Vec3.func_72443_a((double)(b ? 0.8125 : 0.1875), (double)(1.5 - conRadius), (double)0.5);
        }
        if (this.facing == 3) {
            return Vec3.func_72443_a((double)(b ? 0.1875 : 0.8125), (double)(1.5 - conRadius), (double)0.5);
        }
        if (this.facing == 4) {
            return Vec3.func_72443_a((double)0.5, (double)(1.5 - conRadius), (double)(b ? 0.1875 : 0.8125));
        }
        if (this.facing == 5) {
            return Vec3.func_72443_a((double)0.5, (double)(1.5 - conRadius), (double)(b ? 0.8125 : 0.1875));
        }
        return Vec3.func_72443_a((double)0.5, (double)0.5, (double)0.5);
    }

    public int getTargetedConnector(TargetingInfo target) {
        if (this.postAttached > 0) {
            if ((double)target.hitY >= 0.5) {
                return 0;
            }
            return 1;
        }
        if (this.facing == 2) {
            if ((double)target.hitX < 0.5) {
                return 1;
            }
            return 0;
        }
        if (this.facing == 3) {
            if ((double)target.hitX < 0.5) {
                return 0;
            }
            return 1;
        }
        if (this.facing == 4) {
            if ((double)target.hitZ < 0.5) {
                return 0;
            }
            return 1;
        }
        if (this.facing == 5) {
            if ((double)target.hitZ < 0.5) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public WireType getLimiter(int side) {
        if (side == 0) {
            return this.limitType;
        }
        return this.secondCable;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (Config.getBoolean("increasedRenderboxes")) {
            return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 16), (double)(this.field_145848_d - 16), (double)(this.field_145849_e - 16), (double)(this.field_145851_c + 17), (double)(this.field_145848_d + 17), (double)(this.field_145849_e + 17));
        }
        if (!this.dummy) {
            return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)(this.field_145848_d - 1), (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)((double)this.field_145848_d + 1.5), (double)(this.field_145849_e + 1));
        }
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
    }
}

