/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.entities.EntitySkylineHook;
import blusunrize.immersiveengineering.common.items.ItemSkyhook;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class SkylineHelper {
    public static ImmersiveNetHandler.Connection getTargetConnection(World world, int x, int y, int z, EntityLivingBase living, ImmersiveNetHandler.Connection invalidCon) {
        if (!(world.func_147438_o(x, y, z) instanceof IImmersiveConnectable)) {
            return null;
        }
        List<ImmersiveNetHandler.Connection> outputs = ImmersiveNetHandler.INSTANCE.getConnections(world, new ChunkCoordinates(x, y, z));
        if (outputs.size() > 0) {
            Vec3 vec = living.func_70040_Z();
            vec = vec.func_72432_b();
            ImmersiveNetHandler.Connection line = null;
            for (ImmersiveNetHandler.Connection c : outputs) {
                if (c == null || c.equals(invalidCon)) continue;
                if (line == null) {
                    line = c;
                    continue;
                }
                Vec3 lineVec = Vec3.func_72443_a((double)(line.end.field_71574_a - line.start.field_71574_a), (double)(line.end.field_71572_b - line.start.field_71572_b), (double)(line.end.field_71573_c - line.start.field_71573_c)).func_72432_b();
                Vec3 conVec = Vec3.func_72443_a((double)(c.end.field_71574_a - c.start.field_71574_a), (double)(c.end.field_71572_b - c.start.field_71572_b), (double)(c.end.field_71573_c - c.start.field_71573_c)).func_72432_b();
                if (!(conVec.func_72438_d(vec) < lineVec.func_72438_d(vec))) continue;
                line = c;
            }
            return line;
        }
        return null;
    }

    public static EntitySkylineHook spawnHook(EntityPlayer player, TileEntity start, ImmersiveNetHandler.Connection connection) {
        ChunkCoordinates cc0 = connection.end == Utils.toCC(start) ? connection.start : connection.end;
        ChunkCoordinates cc1 = connection.end == Utils.toCC(start) ? connection.end : connection.start;
        IImmersiveConnectable iicStart = Utils.toIIC(cc1, player.field_70170_p);
        IImmersiveConnectable iicEnd = Utils.toIIC(cc0, player.field_70170_p);
        Vec3 vStart = Vec3.func_72443_a((double)cc1.field_71574_a, (double)cc1.field_71572_b, (double)cc1.field_71573_c);
        Vec3 vEnd = Vec3.func_72443_a((double)cc0.field_71574_a, (double)cc0.field_71572_b, (double)cc0.field_71573_c);
        if (iicStart != null) {
            vStart = Utils.addVectors(vStart, iicStart.getConnectionOffset(connection));
        }
        if (iicEnd != null) {
            vEnd = Utils.addVectors(vEnd, iicEnd.getConnectionOffset(connection));
        }
        Vec3[] steps = SkylineHelper.getConnectionCatenary(connection, vStart, vEnd);
        double dx = steps[0].field_72450_a - vStart.field_72450_a;
        double dy = steps[0].field_72448_b - vStart.field_72448_b;
        double dz = steps[0].field_72449_c - vStart.field_72449_c;
        double d = 1.0;
        EntitySkylineHook hook = new EntitySkylineHook(player.field_70170_p, vStart.field_72450_a, vStart.field_72448_b, vStart.field_72449_c, connection, cc0, steps);
        float speed = 1.0f;
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemSkyhook) {
            speed = ((ItemSkyhook)player.func_71045_bC().func_77973_b()).getSkylineSpeed(player.func_71045_bC());
        }
        Vec3 moveVec = SkylineHelper.getSubMovementVector(vStart, steps[0], speed);
        hook.field_70159_w = moveVec.field_72450_a;
        hook.field_70181_x = moveVec.field_72448_b;
        hook.field_70179_y = moveVec.field_72449_c;
        if (!player.field_70170_p.field_72995_K) {
            player.field_70170_p.func_72838_d((Entity)hook);
        }
        ItemSkyhook.existingHooks.put(player.func_70005_c_(), hook);
        player.func_70078_a((Entity)hook);
        return hook;
    }

    public static Vec3[] getConnectionCatenary(ImmersiveNetHandler.Connection connection, Vec3 start, Vec3 end) {
        boolean vertical;
        boolean bl = vertical = connection.end.field_71574_a == connection.start.field_71574_a && connection.end.field_71573_c == connection.start.field_71573_c;
        if (vertical) {
            return new Vec3[]{Vec3.func_72443_a((double)end.field_72450_a, (double)end.field_72448_b, (double)end.field_72449_c)};
        }
        double dx = end.field_72450_a - start.field_72450_a;
        double dy = end.field_72448_b - start.field_72448_b;
        double dz = end.field_72449_c - start.field_72449_c;
        double dw = Math.sqrt(dx * dx + dz * dz);
        double k = Math.sqrt(dx * dx + dy * dy + dz * dz) * connection.cableType.getSlack();
        double l = 0.0;
        for (int limiter = 0; !vertical && limiter < 300; ++limiter) {
            if (!(Math.sinh(l += 0.01) / l >= Math.sqrt(k * k - dy * dy) / dw)) continue;
        }
        double a = dw / 2.0 / l;
        double p = (0.0 + dw - a * Math.log((k + dy) / (k - dy))) * 0.5;
        double q = (dy + 0.0 - k * Math.cosh(l) / Math.sinh(l)) * 0.5;
        int vertices = 16;
        Vec3[] vex = new Vec3[vertices];
        for (int i = 0; i < vertices; ++i) {
            float n1 = (float)(i + 1) / (float)vertices;
            double x1 = 0.0 + dx * (double)n1;
            double z1 = 0.0 + dz * (double)n1;
            double y1 = a * Math.cosh((Math.sqrt(x1 * x1 + z1 * z1) - p) / a) + q;
            vex[i] = Vec3.func_72443_a((double)(start.field_72450_a + x1), (double)(start.field_72448_b + y1), (double)(start.field_72449_c + z1));
        }
        return vex;
    }

    public static Vec3 getSubMovementVector(Vec3 start, Vec3 target, float speed) {
        Vec3 movementVec = Vec3.func_72443_a((double)(target.field_72450_a - start.field_72450_a), (double)(target.field_72448_b - start.field_72448_b), (double)(target.field_72449_c - start.field_72449_c));
        int lPixel = (int)Math.max(1.0, movementVec.func_72433_c() / (0.125 * (double)speed));
        return Vec3.func_72443_a((double)(movementVec.field_72450_a / (double)lPixel), (double)(movementVec.field_72448_b / (double)lPixel), (double)(movementVec.field_72449_c / (double)lPixel));
    }
}

