/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntityHomingArrow;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.utils.MathUtils;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class ArchangelSmite
extends ItemPE
implements IPedestalItem {
    public ArchangelSmite() {
        this.func_77655_b("archangel_smite");
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        EntityHomingArrow arrow = new EntityHomingArrow(world, (EntityLivingBase)player, 2.0f);
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)arrow);
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a(this.getTexture("rings", "archangel_smite"));
    }

    @Override
    public void updateInPedestal(World world, int x, int y, int z) {
        if (!world.field_72995_K && ProjectEConfig.archangelPedCooldown != -1) {
            DMPedestalTile tile = (DMPedestalTile)world.func_147438_o(x, y, z);
            if (tile.getActivityCooldown() == 0) {
                if (!world.func_72872_a(EntityLiving.class, tile.getEffectBounds()).isEmpty()) {
                    for (int i = 0; i < 3; ++i) {
                        EntityHomingArrow arrow = new EntityHomingArrow(world, (EntityLivingBase)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world)), 2.0f);
                        arrow.field_70165_t = tile.centeredX;
                        arrow.field_70163_u = tile.centeredY + 2.0;
                        arrow.field_70161_v = tile.centeredZ;
                        world.func_72838_d((Entity)arrow);
                    }
                }
                tile.setActivityCooldown(ProjectEConfig.archangelPedCooldown);
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    public List<String> getPedestalDescription() {
        ArrayList list = Lists.newArrayList();
        if (ProjectEConfig.archangelPedCooldown != -1) {
            list.add(EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"pe.archangel.pedestal1"));
            list.add(EnumChatFormatting.BLUE + String.format(StatCollector.func_74838_a((String)"pe.archangel.pedestal2"), MathUtils.tickToSecFormatted(ProjectEConfig.archangelPedCooldown)));
        }
        return list;
    }
}

