/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.tiles;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import moze_intel.projecte.api.item.IItemEmc;
import moze_intel.projecte.api.tile.IEmcAcceptor;
import moze_intel.projecte.gameObjs.blocks.MatterFurnace;
import moze_intel.projecte.gameObjs.tiles.TileEmc;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.Facing;
import net.minecraftforge.common.util.ForgeDirection;

public class RMFurnaceTile
extends TileEmc
implements IInventory,
ISidedInventory,
IEmcAcceptor {
    private final float EMC_CONSUMPTION = 1.6f;
    public ItemStack[] inventory = new ItemStack[27];
    public int outputSlot = 14;
    public int[] inputStorage = new int[]{2, 13};
    public int[] outputStorage = new int[]{15, 26};
    public int ticksBeforeSmelt = 3;
    public int efficiencyBonus = 4;
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    public int furnaceCookTime;

    public RMFurnaceTile() {
        super(64);
    }

    public void func_145845_h() {
        boolean flag = this.furnaceBurnTime > 0;
        boolean flag1 = false;
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.pullFromInventories();
            this.pushSmeltStack();
        }
        if (!this.field_145850_b.field_72995_K) {
            IItemEmc itemEmc;
            if (this.canSmelt() && this.inventory[0] != null && this.inventory[0].func_77973_b() instanceof IItemEmc && (itemEmc = (IItemEmc)this.inventory[0].func_77973_b()).getStoredEmc(this.inventory[0]) >= (double)1.6f) {
                itemEmc.extractEmc(this.inventory[0], 1.6f);
                this.addEMC(1.6f);
            }
            if (this.getStoredEmc() >= (double)1.6f) {
                this.furnaceBurnTime = 1;
                this.removeEMC(1.6f);
            }
            if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                this.currentItemBurnTime = this.furnaceBurnTime = this.getItemBurnTime(this.inventory[0]);
                if (this.furnaceBurnTime > 0) {
                    flag1 = true;
                    if (this.inventory[0] != null) {
                        --this.inventory[0].field_77994_a;
                        if (this.inventory[0].field_77994_a == 0) {
                            this.inventory[0] = this.inventory[0].func_77973_b().getContainerItem(this.inventory[0]);
                        }
                    }
                }
            }
            if (this.furnaceBurnTime > 0 && this.canSmelt()) {
                ++this.furnaceCookTime;
                if (this.furnaceCookTime == this.ticksBeforeSmelt) {
                    this.furnaceCookTime = 0;
                    this.smeltItem();
                    flag1 = true;
                }
            }
            if (flag != this.furnaceBurnTime > 0) {
                flag1 = true;
                Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                if (!this.field_145850_b.field_72995_K && block instanceof MatterFurnace) {
                    ((MatterFurnace)block).updateFurnaceBlockState(this.furnaceBurnTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
        if (!this.field_145850_b.field_72995_K) {
            this.pushOutput();
            this.pushToInventories();
        }
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    private void pushSmeltStack() {
        ItemStack stack = this.inventory[1];
        for (int i = this.inputStorage[0]; i <= this.inputStorage[1]; ++i) {
            ItemStack slotStack = this.inventory[i];
            if (slotStack == null || stack != null && !ItemHelper.areItemStacksEqual(slotStack, stack)) continue;
            if (stack == null) {
                this.inventory[1] = slotStack.func_77946_l();
                this.inventory[i] = null;
                break;
            }
            int remain = stack.func_77976_d() - stack.field_77994_a;
            if (remain == 0) break;
            if (slotStack.field_77994_a <= remain) {
                this.inventory[i] = null;
                this.inventory[1].field_77994_a += slotStack.field_77994_a;
                break;
            }
            this.func_70298_a(i, remain);
            this.inventory[1].field_77994_a += remain;
        }
    }

    private void pushOutput() {
        ItemStack output = this.inventory[this.outputSlot];
        if (output == null) {
            return;
        }
        for (int i = this.outputStorage[0]; i <= this.outputStorage[1]; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null) {
                this.inventory[i] = output;
                this.inventory[this.outputSlot] = null;
                return;
            }
            if (!ItemHelper.areItemStacksEqual(output, stack) || stack.field_77994_a >= stack.func_77976_d()) continue;
            int remain = stack.func_77976_d() - stack.field_77994_a;
            if (output.field_77994_a <= remain) {
                this.inventory[this.outputSlot] = null;
                this.inventory[i].field_77994_a += output.field_77994_a;
                return;
            }
            this.func_70298_a(this.outputSlot, remain);
            this.inventory[i].field_77994_a += remain;
        }
    }

    private void pullFromInventories() {
        block15: {
            TileEntity tile;
            block16: {
                tile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                if (!(tile instanceof ISidedInventory)) break block16;
                boolean side = false;
                ISidedInventory inv = (ISidedInventory)tile;
                int[] slots = inv.func_94128_d(0);
                if (slots.length <= 0) break block15;
                block0: for (int i : slots) {
                    ItemStack stack = inv.func_70301_a(i);
                    if (stack == null || !inv.func_102008_b(i, stack, 0)) continue;
                    if (TileEntityFurnace.func_145954_b((ItemStack)stack) || stack.func_77973_b() instanceof IItemEmc) {
                        if (this.inventory[0] == null) {
                            this.inventory[0] = stack;
                            inv.func_70299_a(i, null);
                            break block15;
                        }
                        if (!ItemHelper.areItemStacksEqual(stack, this.inventory[0])) continue;
                        int remain = this.inventory[0].func_77976_d() - this.inventory[0].field_77994_a;
                        if (stack.field_77994_a <= remain) {
                            this.inventory[0].field_77994_a += stack.field_77994_a;
                            inv.func_70299_a(i, null);
                            break block15;
                        }
                        this.inventory[0].field_77994_a += remain;
                        stack.field_77994_a -= remain;
                        continue;
                    }
                    for (int j = this.inputStorage[0]; j < this.inputStorage[1]; ++j) {
                        ItemStack otherStack = this.inventory[j];
                        if (otherStack == null) {
                            this.inventory[j] = stack;
                            inv.func_70299_a(i, null);
                            continue block0;
                        }
                        if (!ItemHelper.areItemStacksEqual(stack, otherStack)) continue;
                        int remain = otherStack.func_77976_d() - otherStack.field_77994_a;
                        if (stack.field_77994_a <= remain) {
                            this.inventory[j].field_77994_a += stack.field_77994_a;
                            inv.func_70299_a(i, null);
                            continue block0;
                        }
                        this.inventory[j].field_77994_a += remain;
                        stack.field_77994_a -= remain;
                    }
                }
                break block15;
            }
            if (tile instanceof IInventory) {
                IInventory inv = (IInventory)tile;
                block2: for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack stack = inv.func_70301_a(i);
                    if (stack == null) continue;
                    if (TileEntityFurnace.func_145954_b((ItemStack)stack) || stack.func_77973_b() instanceof IItemEmc) {
                        if (this.inventory[0] == null) {
                            this.inventory[0] = stack;
                            inv.func_70299_a(i, null);
                            break;
                        }
                        if (!ItemHelper.areItemStacksEqual(stack, this.inventory[0])) continue;
                        int remain = this.inventory[0].func_77976_d() - this.inventory[0].field_77994_a;
                        if (stack.field_77994_a <= remain) {
                            this.inventory[0].field_77994_a += stack.field_77994_a;
                            inv.func_70299_a(i, null);
                            break;
                        }
                        this.inventory[0].field_77994_a += remain;
                        stack.field_77994_a -= remain;
                        continue;
                    }
                    if (FurnaceRecipes.func_77602_a().func_151395_a(stack) == null) continue;
                    for (int j = this.inputStorage[0]; j < this.inputStorage[1]; ++j) {
                        ItemStack otherStack = this.inventory[j];
                        if (otherStack == null) {
                            this.inventory[j] = stack;
                            inv.func_70299_a(i, null);
                            continue block2;
                        }
                        if (!ItemHelper.areItemStacksEqual(stack, otherStack)) continue;
                        int remain = otherStack.func_77976_d() - otherStack.field_77994_a;
                        if (stack.field_77994_a <= remain) {
                            this.inventory[j].field_77994_a += stack.field_77994_a;
                            inv.func_70299_a(i, null);
                            continue block2;
                        }
                        this.inventory[j].field_77994_a += remain;
                        stack.field_77994_a -= remain;
                    }
                }
            }
        }
    }

    private void pushToInventories() {
        block0: for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int z;
            int y;
            int x;
            TileEntity tile;
            if (dir.offsetY > 0 || (tile = this.field_145850_b.func_147438_o(x = this.field_145851_c + dir.offsetX, y = this.field_145848_d + dir.offsetY, z = this.field_145849_e + dir.offsetZ)) == null) continue;
            if (tile instanceof ISidedInventory) {
                ISidedInventory inv = (ISidedInventory)tile;
                int[] slots = inv.func_94128_d(ForgeDirection.OPPOSITES[dir.ordinal()]);
                if (slots.length <= 0) continue;
                block1: for (int j = this.outputStorage[0]; j < this.outputStorage[1]; ++j) {
                    ItemStack stack = this.inventory[j];
                    if (stack == null) continue;
                    for (int k : slots) {
                        if (!inv.func_102007_a(k, stack, Facing.field_71588_a[dir.ordinal()])) continue;
                        ItemStack otherStack = inv.func_70301_a(k);
                        if (otherStack == null) {
                            inv.func_70299_a(k, stack);
                            this.inventory[j] = null;
                            continue block1;
                        }
                        if (!ItemHelper.areItemStacksEqual(stack, otherStack)) continue;
                        int remain = otherStack.func_77976_d() - otherStack.field_77994_a;
                        if (stack.field_77994_a <= remain) {
                            otherStack.field_77994_a += stack.field_77994_a;
                            this.inventory[j] = null;
                            continue block1;
                        }
                        otherStack.field_77994_a += remain;
                        this.inventory[j].field_77994_a -= remain;
                    }
                }
                continue;
            }
            if (!(tile instanceof IInventory)) continue;
            for (int j = this.outputStorage[0]; j <= this.outputStorage[1]; ++j) {
                ItemStack stack = this.inventory[j];
                if (stack == null) continue;
                ItemStack result = ItemHelper.pushStackInInv((IInventory)tile, stack);
                if (result == null) {
                    this.inventory[j] = null;
                    continue block0;
                }
                this.inventory[j].field_77994_a = result.field_77994_a;
            }
        }
    }

    private void smeltItem() {
        ItemStack toSmelt = this.inventory[1];
        ItemStack smeltResult = FurnaceRecipes.func_77602_a().func_151395_a(toSmelt).func_77946_l();
        ItemStack currentSmelted = this.func_70301_a(this.outputSlot);
        if (ItemHelper.getOreDictionaryName(toSmelt).startsWith("ore")) {
            smeltResult.field_77994_a *= 2;
        }
        if (currentSmelted == null) {
            this.func_70299_a(this.outputSlot, smeltResult);
        } else {
            currentSmelted.field_77994_a += smeltResult.field_77994_a;
        }
        this.func_70298_a(1, 1);
    }

    private boolean canSmelt() {
        ItemStack toSmelt = this.inventory[1];
        if (toSmelt == null) {
            return false;
        }
        ItemStack smeltResult = FurnaceRecipes.func_77602_a().func_151395_a(toSmelt);
        if (smeltResult == null) {
            return false;
        }
        ItemStack currentSmelted = this.func_70301_a(this.outputSlot);
        if (currentSmelted == null) {
            return true;
        }
        if (!smeltResult.func_77969_a(currentSmelted)) {
            return false;
        }
        int result = currentSmelted.field_77994_a + smeltResult.field_77994_a;
        return result <= currentSmelted.func_77976_d();
    }

    private int getItemBurnTime(ItemStack stack) {
        int val = TileEntityFurnace.func_145952_a((ItemStack)stack);
        return val * this.ticksBeforeSmelt / 200 * this.efficiencyBonus;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int value) {
        return (this.furnaceCookTime + (this.isBurning() && this.canSmelt() ? 1 : 0)) * value / this.ticksBeforeSmelt;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int value) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = this.ticksBeforeSmelt;
        }
        return this.furnaceBurnTime * value / this.currentItemBurnTime;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.furnaceBurnTime = nbt.func_74765_d("BurnTime");
        this.furnaceCookTime = nbt.func_74765_d("CookTime");
        this.currentItemBurnTime = this.getItemBurnTime(this.inventory[0]);
        NBTTagList list = nbt.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound subNBT = list.func_150305_b(i);
            byte slot = subNBT.func_74771_c("Slot");
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)subNBT);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        nbt.func_74777_a("CookTime", (short)this.furnaceCookTime);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound subNBT = new NBTTagCompound();
            subNBT.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(subNBT);
            list.func_74742_a((NBTBase)subNBT);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
    }

    public int func_70302_i_() {
        return 27;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int qty) {
        ItemStack stack = this.inventory[slot];
        if (stack != null) {
            if (stack.field_77994_a <= qty) {
                this.inventory[slot] = null;
            } else {
                stack = stack.func_77979_a(qty);
                if (stack.field_77994_a == 0) {
                    this.inventory[slot] = null;
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inventory[slot] != null) {
            ItemStack stack = this.inventory[slot];
            this.inventory[slot] = null;
            return stack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "pe.rmfurnace.shortname";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (slot == 0) {
            return TileEntityFurnace.func_145954_b((ItemStack)stack) || stack.func_77973_b() instanceof IItemEmc;
        }
        if (slot >= 1 && slot <= 13) {
            return FurnaceRecipes.func_77602_a().func_151395_a(stack) != null;
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        switch (side) {
            case 0: {
                return new int[]{15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};
            }
            case 1: {
                return new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return new int[]{0, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};
            }
        }
        return new int[0];
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (side == 0) {
            return false;
        }
        if (side == 1) {
            return slot <= this.inputStorage[1] && slot >= this.inputStorage[0];
        }
        return slot == 0;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot >= this.outputStorage[0];
    }

    @Override
    public double acceptEMC(ForgeDirection side, double toAccept) {
        if (this.getStoredEmc() < (double)1.6f) {
            double needed = (double)1.6f - this.getStoredEmc();
            double accept = Math.min(needed, toAccept);
            this.addEMC(accept);
            return accept;
        }
        return 0.0;
    }
}

