/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.impl;

import com.google.common.base.Preconditions;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.emc.mappers.APICustomEMCMapper;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class EMCProxyImpl
implements IEMCProxy {
    public static final IEMCProxy instance = new EMCProxyImpl();

    private EMCProxyImpl() {
    }

    @Override
    public void registerCustomEMC(ItemStack stack, int value) {
        Preconditions.checkNotNull((Object)stack);
        boolean flag = Loader.instance().isInState(LoaderState.PREINITIALIZATION) || Loader.instance().isInState(LoaderState.INITIALIZATION) || Loader.instance().isInState(LoaderState.POSTINITIALIZATION);
        Preconditions.checkState((boolean)flag, (Object)String.format("Mod %s tried to register EMC at an invalid time!", Loader.instance().activeModContainer().getModId()));
        APICustomEMCMapper.instance.registerCustomEMC(stack, value);
        PELogger.logInfo("Mod %s registered emc value %d for itemstack %s", Loader.instance().activeModContainer().getModId(), value, stack.toString());
    }

    @Override
    public boolean hasValue(Block block) {
        Preconditions.checkNotNull((Object)block);
        return EMCHelper.doesBlockHaveEmc(block);
    }

    @Override
    public boolean hasValue(Item item) {
        Preconditions.checkNotNull((Object)item);
        return EMCHelper.doesItemHaveEmc(item);
    }

    @Override
    public boolean hasValue(ItemStack stack) {
        Preconditions.checkNotNull((Object)stack);
        return this.hasValue(stack.func_77973_b());
    }

    @Override
    public int getValue(Block block) {
        Preconditions.checkNotNull((Object)block);
        return EMCHelper.getEmcValue(block);
    }

    @Override
    public int getValue(Item item) {
        Preconditions.checkNotNull((Object)item);
        return EMCHelper.getEmcValue(item);
    }

    @Override
    public int getValue(ItemStack stack) {
        Preconditions.checkNotNull((Object)stack);
        return EMCHelper.getEmcValue(stack);
    }
}

