/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.NEI;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.Map;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.utils.MetaBlock;
import moze_intel.projecte.utils.WorldTransmutations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class NEIWorldTransmuteHandler
extends TemplateRecipeHandler {
    private static String name = StatCollector.func_74838_a((String)"pe.nei.worldtransmute");
    private static String id = "worldTransmutation";

    public String getRecipeName() {
        return name;
    }

    public String getGuiTexture() {
        return "projecte:textures/gui/nei.png";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(id) && ((Object)((Object)this)).getClass() == NEIWorldTransmuteHandler.class) {
            for (Map.Entry<MetaBlock, MetaBlock[]> entry : WorldTransmutations.MAP.entrySet()) {
                if (entry == null) continue;
                if (entry.getValue()[0] != null) {
                    this.arecipes.add(new CachedTransmutationRecipe(entry.getKey(), false));
                }
                if (entry.getValue()[1] == null) continue;
                this.arecipes.add(new CachedTransmutationRecipe(entry.getKey(), true));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<MetaBlock, MetaBlock[]> entry : WorldTransmutations.MAP.entrySet()) {
            if (NEIServerUtils.areStacksSameTypeCrafting((ItemStack)entry.getValue()[0].toItemStack(), (ItemStack)result)) {
                if (entry == null || entry.getValue() == null) continue;
                this.arecipes.add(new CachedTransmutationRecipe(entry.getKey(), false));
                continue;
            }
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)entry.getValue()[1].toItemStack(), (ItemStack)result) || entry == null || entry.getValue() == null) continue;
            this.arecipes.add(new CachedTransmutationRecipe(entry.getKey(), true));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Map.Entry<MetaBlock, MetaBlock[]> entry : WorldTransmutations.MAP.entrySet()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)entry.getKey().toItemStack(), (ItemStack)ingredient) || entry == null) continue;
            if (entry.getValue()[0] != null) {
                this.arecipes.add(new CachedTransmutationRecipe(entry.getKey(), false));
            }
            if (entry.getValue()[1] == null) continue;
            this.arecipes.add(new CachedTransmutationRecipe(entry.getKey(), true));
        }
    }

    public void drawForeground(int recipe) {
        String sneak = StatCollector.func_74838_a((String)"key.sneak");
        CachedTransmutationRecipe r = (CachedTransmutationRecipe)((Object)this.arecipes.get(recipe));
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        if (r.sneaking) {
            fr.func_78276_b(sneak, 70, 40, 0);
        }
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(83, 23, 25, 10), id, new Object[0]));
    }

    public class CachedTransmutationRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private MetaBlock input;
        private MetaBlock output;
        public boolean sneaking;

        public CachedTransmutationRecipe(MetaBlock in, boolean sneak) {
            super((TemplateRecipeHandler)NEIWorldTransmuteHandler.this);
            this.input = in;
            this.sneaking = sneak;
            this.output = WorldTransmutations.getWorldTransmutation(in, this.sneaking);
        }

        public PositionedStack getIngredient() {
            ItemStack is = this.input.toItemStack();
            return new PositionedStack((Object)is, 22, 23);
        }

        public PositionedStack getResult() {
            ItemStack result = this.output.toItemStack();
            return new PositionedStack((Object)result, 128, 23);
        }

        public PositionedStack getOtherStack() {
            return new PositionedStack((Object)new ItemStack(ObjHandler.philosStone), 60, 23);
        }
    }
}

