/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.playerData;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import moze_intel.projecte.playerData.AlchemicalBags;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class AlchBagProps
implements IExtendedEntityProperties {
    public static final String PROP_NAME = "ProjectEAlchBag";
    private final EntityPlayer player;
    private final Map<Integer, ItemStack[]> bagData = Maps.newHashMap();
    private boolean hasMigrated = false;

    public static void register(EntityPlayer player) {
        player.registerExtendedProperties(PROP_NAME, (IExtendedEntityProperties)new AlchBagProps(player));
    }

    public static AlchBagProps getDataFor(EntityPlayer player) {
        return (AlchBagProps)player.getExtendedProperties(PROP_NAME);
    }

    public AlchBagProps(EntityPlayer player) {
        this.player = player;
    }

    protected ItemStack[] getInv(int color) {
        if (this.bagData.get(color) == null) {
            this.bagData.put(color, new ItemStack[104]);
            PELogger.logInfo("Created new inventory array for color " + color + " and player " + this.player.func_70005_c_());
        }
        ItemStack[] inv = this.bagData.get(color);
        return Arrays.copyOf(inv, inv.length);
    }

    protected void setInv(int color, ItemStack[] inv) {
        this.bagData.put(color, inv);
    }

    protected NBTTagCompound saveForPacket() {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList listOfInventories = new NBTTagList();
        for (int i = 0; i < 16; ++i) {
            if (this.bagData.get(i) == null) continue;
            NBTTagCompound inventory = new NBTTagCompound();
            inventory.func_74768_a("color", i);
            inventory.func_74782_a("inv", (NBTBase)ItemHelper.toIndexedNBTList(this.bagData.get(i)));
            listOfInventories.func_74742_a((NBTBase)inventory);
        }
        compound.func_74782_a("data", (NBTBase)listOfInventories);
        return compound;
    }

    protected NBTTagCompound saveForPartialPacket(int color) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList listOfInventories = new NBTTagList();
        if (this.bagData.get(color) == null) {
            return compound;
        }
        NBTTagCompound inventory = new NBTTagCompound();
        inventory.func_74768_a("color", color);
        inventory.func_74782_a("inv", (NBTBase)ItemHelper.toIndexedNBTList(this.bagData.get(color)));
        listOfInventories.func_74742_a((NBTBase)inventory);
        compound.func_74782_a("data", (NBTBase)listOfInventories);
        return compound;
    }

    public void readFromPacket(NBTTagCompound compound) {
        NBTTagList listOfInventoies = compound.func_150295_c("data", 10);
        for (int i = 0; i < listOfInventoies.func_74745_c(); ++i) {
            NBTTagCompound inventory = listOfInventoies.func_150305_b(i);
            this.bagData.put(inventory.func_74762_e("color"), ItemHelper.copyIndexedNBTToArray(inventory.func_150295_c("inv", 10), new ItemStack[104]));
        }
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = new NBTTagCompound();
        NBTTagList listOfInventories = new NBTTagList();
        for (int i = 0; i < 16; ++i) {
            if (this.bagData.get(i) == null) continue;
            NBTTagCompound inventory = new NBTTagCompound();
            inventory.func_74768_a("color", i);
            inventory.func_74782_a("inv", (NBTBase)ItemHelper.toIndexedNBTList(this.bagData.get(i)));
            listOfInventories.func_74742_a((NBTBase)inventory);
        }
        properties.func_74782_a("data", (NBTBase)listOfInventories);
        properties.func_74757_a("migrated", this.hasMigrated);
        compound.func_74782_a(PROP_NAME, (NBTBase)properties);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = compound.func_74775_l(PROP_NAME);
        NBTTagList listOfInventoies = properties.func_150295_c("data", 10);
        this.hasMigrated = properties.func_74767_n("migrated");
        if (!this.hasMigrated && !this.player.field_70170_p.field_72995_K) {
            if (AlchemicalBags.hasLegacyData(this.player)) {
                listOfInventoies = AlchemicalBags.migratePlayerData(this.player);
                PELogger.logInfo("** MIGRATED BAG DATA for player: " + this.player.func_70005_c_() + " **");
            } else {
                PELogger.logInfo("** LEGACY BAG DATA NOT FOUND. NOW USING NEW SAVING for player: " + this.player.func_70005_c_() + " **");
            }
            this.hasMigrated = true;
        }
        for (int i = 0; i < listOfInventoies.func_74745_c(); ++i) {
            NBTTagCompound inventory = listOfInventoies.func_150305_b(i);
            this.bagData.put(inventory.func_74762_e("color"), ItemHelper.copyIndexedNBTToArray(inventory.func_150295_c("inv", 10), new ItemStack[104]));
        }
    }

    public void init(Entity entity, World world) {
    }
}

