/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.lib.util.helpers.MathHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityHelper {
    private EntityHelper() {
    }

    public static int getEntityFacingCardinal(EntityLivingBase living) {
        int quadrant = MathHelper.floor((double)(living.field_70177_z * 4.0f / 360.0f) + 0.5) & 3;
        switch (quadrant) {
            case 0: {
                return 2;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 3;
            }
        }
        return 4;
    }

    public static ForgeDirection getEntityFacingForgeDirection(EntityLivingBase living) {
        return ForgeDirection.VALID_DIRECTIONS[EntityHelper.getEntityFacingCardinal(living)];
    }

    public static void transferEntityToDimension(Entity entity, int dimension, ServerConfigurationManager manager) {
        if (entity instanceof EntityPlayerMP) {
            EntityHelper.transferPlayerToDimension((EntityPlayerMP)entity, dimension, manager);
            return;
        }
        WorldServer worldserver = manager.func_72365_p().func_71218_a(entity.field_71093_bK);
        entity.field_71093_bK = dimension;
        WorldServer worldserver1 = manager.func_72365_p().func_71218_a(entity.field_71093_bK);
        worldserver.func_72973_f(entity);
        if (entity.field_70153_n != null) {
            entity.field_70153_n.func_70078_a(null);
        }
        if (entity.field_70154_o != null) {
            entity.func_70078_a(null);
        }
        entity.field_70128_L = false;
        EntityHelper.transferEntityToWorld(entity, worldserver, worldserver1);
    }

    public static void transferEntityToWorld(Entity entity, WorldServer oldWorld, WorldServer newWorld) {
        WorldProvider pOld = oldWorld.field_73011_w;
        WorldProvider pNew = newWorld.field_73011_w;
        double moveFactor = pOld.getMovementFactor() / pNew.getMovementFactor();
        double x = entity.field_70165_t * moveFactor;
        double z = entity.field_70161_v * moveFactor;
        oldWorld.field_72984_F.func_76320_a("placing");
        x = net.minecraft.util.MathHelper.func_151237_a((double)x, (double)-2.9999872E7, (double)2.9999872E7);
        z = net.minecraft.util.MathHelper.func_151237_a((double)z, (double)-2.9999872E7, (double)2.9999872E7);
        if (entity.func_70089_S()) {
            entity.func_70012_b(x, entity.field_70163_u, z, entity.field_70177_z, entity.field_70125_A);
            newWorld.func_72838_d(entity);
            newWorld.func_72866_a(entity, false);
        }
        oldWorld.field_72984_F.func_76319_b();
        entity.func_70029_a((World)newWorld);
    }

    public static void transferPlayerToDimension(EntityPlayerMP player, int dimension, ServerConfigurationManager manager) {
        int oldDim = player.field_71093_bK;
        WorldServer worldserver = manager.func_72365_p().func_71218_a(player.field_71093_bK);
        player.field_71093_bK = dimension;
        WorldServer worldserver1 = manager.func_72365_p().func_71218_a(player.field_71093_bK);
        player.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(player.field_71093_bK, player.field_70170_p.field_73013_u, player.field_70170_p.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        worldserver.func_72973_f((Entity)player);
        if (player.field_70153_n != null) {
            player.field_70153_n.func_70078_a(null);
        }
        if (player.field_70154_o != null) {
            player.func_70078_a(null);
        }
        player.field_70128_L = false;
        EntityHelper.transferEntityToWorld((Entity)player, worldserver, worldserver1);
        manager.func_72375_a(player, worldserver);
        player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(worldserver1);
        manager.func_72354_b(player, worldserver1);
        manager.func_72385_f(player);
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, oldDim, dimension);
    }
}

