/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.client.gui;

import chanceCubes.client.gui.CustomExtendedList;
import chanceCubes.config.CustomRewardsLoader;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Keyboard;

public class ConfigGui
extends GuiScreen {
    private ConfigEditState editState;
    private GuiButton buttonNew;
    private String[] prevStage = new String[3];
    private String drawString = "";
    private CustomExtendedList entries;

    public ConfigGui(GuiScreen screen) {
    }

    public void func_73866_w_() {
        this.editState = ConfigEditState.Files;
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.add(new GuiButton(0, 50, this.field_146295_m - 40, 98, 20, "Back"));
        this.buttonNew = new GuiButton(1, this.field_146294_l / 2 - 50, this.field_146295_m - 40, 100, 20, "New");
        this.field_146292_n.add(this.buttonNew);
        this.entries = new CustomExtendedList(this, this.field_146297_k, this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - 64, 36);
        this.loadFiles();
    }

    public void func_146281_b() {
        CustomRewardsLoader.instance.loadCustomRewards();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.entries.func_148128_a(mouseX, mouseY, partialTicks);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.field_146297_k.field_71466_p.func_78276_b(this.drawString, this.field_146294_l / 2 - (int)((double)this.drawString.length() * 2.5), 10, 0xFFFFFF);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 0) {
                this.prevEditStage();
            } else if (button.field_146127_k == 0) {
                // empty if block
            }
        }
    }

    protected void func_73864_a(int x, int y, int mouseEvent) {
        this.entries.func_148179_a(x, y, mouseEvent);
        super.func_73864_a(x, y, mouseEvent);
    }

    public void nextEditStage(String name) {
        switch (this.editState) {
            case Files: {
                this.editState = ConfigEditState.All_Rewards;
                this.loadFileRewards(name);
                this.prevStage[0] = name;
                break;
            }
            case All_Rewards: {
                this.editState = ConfigEditState.Single_Reward;
                this.loadSingleReward(name);
                this.prevStage[1] = name;
                break;
            }
            case Single_Reward: {
                this.editState = ConfigEditState.Reward_Type;
                this.loadRewardType(name);
                this.prevStage[2] = name;
                break;
            }
            case Reward_Type: {
                break;
            }
        }
    }

    public void prevEditStage() {
        switch (this.editState) {
            case Files: {
                break;
            }
            case All_Rewards: {
                this.editState = ConfigEditState.Files;
                this.loadFiles();
                break;
            }
            case Single_Reward: {
                this.editState = ConfigEditState.All_Rewards;
                this.loadFileRewards(this.prevStage[0]);
                break;
            }
            case Reward_Type: {
                this.editState = ConfigEditState.Single_Reward;
                this.loadSingleReward(this.prevStage[1]);
                break;
            }
            case Edit_Reward_Type: {
                this.editState = ConfigEditState.Reward_Type;
            }
        }
    }

    public void loadFiles() {
        this.entries.clearElements();
        this.buttonNew.field_146126_j = "New File";
        this.drawString = "Select the file that you would like to load";
        for (String s : CustomRewardsLoader.instance.getRewardsFiles()) {
            this.entries.addElement(s);
        }
    }

    public void loadFileRewards(String file) {
        this.drawString = "Select the reward that you would like to edit";
        this.entries.clearElements();
        for (String s : CustomRewardsLoader.instance.getRewardsFromFile(file)) {
            this.entries.addElement(s);
        }
    }

    public void loadSingleReward(String reward) {
        this.drawString = "Select the reward type that you would like to edit";
        this.entries.clearElements();
        for (String s : CustomRewardsLoader.instance.getReward(this.prevStage[0], reward)) {
            this.entries.addElement(s);
        }
    }

    public void loadRewardType(String type) {
        this.drawString = "Select the reward type that you would like to edit";
        this.entries.clearElements();
        for (String s : CustomRewardsLoader.instance.getRewardType(this.prevStage[0], this.prevStage[1], type)) {
            this.entries.addElement(s);
        }
    }

    public static enum ConfigEditState {
        Files(0),
        All_Rewards(1),
        Single_Reward(2),
        Reward_Type(3),
        Edit_Reward_Type(4);

        private int posNum;

        private ConfigEditState(int pos) {
            this.posNum = pos;
        }

        public int getPosition() {
            return this.posNum;
        }
    }
}

