/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.IChanceCubeReward;
import chanceCubes.util.Location3I;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.ServerChatEvent;

public class MathReward
implements IChanceCubeReward {
    private Map<EntityPlayer, RewardInfo> inQuestion = new HashMap<EntityPlayer, RewardInfo>();

    @Override
    public void trigger(World world, int x, int y, int z, final EntityPlayer player) {
        if (this.inQuestion.containsKey(player)) {
            return;
        }
        int num1 = world.field_73012_v.nextInt(100);
        int num2 = world.field_73012_v.nextInt(100);
        player.func_145747_a((IChatComponent)new ChatComponentText("Quick, what's " + num1 + "+" + num2 + "?"));
        ArrayList<Location3I> boxBlocks = new ArrayList<Location3I>();
        for (int xx = -2; xx < 3; ++xx) {
            for (int zz = -2; zz < 3; ++zz) {
                for (int yy = 1; yy < 5; ++yy) {
                    if (xx == -2 || xx == 2 || zz == -2 || zz == 2 || yy == 1 || yy == 4) {
                        world.func_147449_b((int)player.field_70165_t + xx, (int)player.field_70163_u + yy, (int)player.field_70161_v + zz, Blocks.field_150357_h);
                        boxBlocks.add(new Location3I((int)player.field_70165_t + xx, (int)player.field_70163_u + yy, (int)player.field_70161_v + zz));
                        continue;
                    }
                    if (xx != -1 && xx != 1 || zz != -1 && zz != 1 || yy != 2) continue;
                    world.func_147449_b((int)player.field_70165_t + xx, (int)player.field_70163_u + yy, (int)player.field_70161_v + zz, Blocks.field_150426_aN);
                    boxBlocks.add(new Location3I((int)player.field_70165_t + xx, (int)player.field_70163_u + yy, (int)player.field_70161_v + zz));
                }
            }
        }
        player.func_70634_a((double)((int)player.field_70165_t), (double)((int)player.field_70163_u + 2), (double)((int)player.field_70161_v));
        if (!world.field_72995_K) {
            ArrayList<Entity> tnt = new ArrayList<Entity>();
            for (int i = 0; i < 5; ++i) {
                EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(world, player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, (EntityLivingBase)player);
                world.func_72838_d((Entity)entitytntprimed);
                world.func_72956_a((Entity)entitytntprimed, "game.tnt.primed", 1.0f, 1.0f);
                entitytntprimed.field_70516_a = 120;
                tnt.add((Entity)entitytntprimed);
            }
            this.inQuestion.put(player, new RewardInfo(num1 + num2, tnt, boxBlocks));
        }
        Task task = new Task("Math", 140){

            @Override
            public void callback() {
                MathReward.this.timeUp(player, false);
            }
        };
        Scheduler.scheduleTask(task);
    }

    private void timeUp(EntityPlayer player, boolean correct) {
        if (!this.inQuestion.containsKey(player)) {
            return;
        }
        RewardInfo info = this.inQuestion.get(player);
        if (correct) {
            player.func_145747_a((IChatComponent)new ChatComponentText("Correct!"));
            for (Entity tnt : info.getTnt()) {
                tnt.func_70106_y();
            }
        }
        for (Location3I b : info.getBlocks()) {
            player.field_70170_p.func_147468_f(b.getX(), b.getY(), b.getZ());
        }
        this.inQuestion.remove(player);
    }

    @Override
    public int getChanceValue() {
        return -35;
    }

    @Override
    public String getName() {
        return "chancecubes:Math";
    }

    @SubscribeEvent
    public void onMessage(ServerChatEvent event) {
        EntityPlayerMP player = event.player;
        if (this.inQuestion.containsKey(player)) {
            int answer = 0;
            try {
                answer = Integer.parseInt(event.message);
            }
            catch (NumberFormatException e) {
                player.func_145747_a((IChatComponent)new ChatComponentText("Incorrect!"));
            }
            if (this.inQuestion.get(player).getAnswer() == answer) {
                this.timeUp((EntityPlayer)player, true);
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText("Incorrect!"));
            }
            event.setCanceled(true);
        }
    }

    private class RewardInfo {
        private int answer;
        private List<Entity> tnt;
        private List<Location3I> blocks;

        public RewardInfo(int answer, List<Entity> tnt, List<Location3I> blocks) {
            this.answer = answer;
            this.tnt = tnt;
            this.blocks = blocks;
        }

        public int getAnswer() {
            return this.answer;
        }

        public List<Entity> getTnt() {
            return this.tnt;
        }

        public List<Location3I> getBlocks() {
            return this.blocks;
        }
    }
}

