/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.api.gastype;

import glenn.gasesframework.api.Combustibility;
import glenn.gasesframework.api.ExtendedGasEffectsBase;
import glenn.gasesframework.api.GasesFrameworkAPI;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GasType {
    private static final GasType[] gasTypesByID = new GasType[256];
    private static final HashMap<String, GasType> gasTypesByName = new HashMap();
    public boolean isRegistered = false;
    public Block block;
    public Block pipeBlock;
    public final boolean isIndustrial;
    public final int gasID;
    public final String name;
    public final int color;
    public final int opacity;
    public final int density;
    public final Combustibility combustibility;
    public int dissipationRate = 0;
    public float damage = 0.0f;
    public boolean destroyLooseBlocks = false;
    private final EnumMap<ExtendedGasEffectsBase.EffectType, Integer> effectRates = new EnumMap(ExtendedGasEffectsBase.EffectType.class);
    public ResourceLocation overlayImage = GasesFrameworkAPI.gasOverlayImage;
    public String textureName = "gasesframework:gas";
    private static final HashSet<String> noisyPeople = new HashSet();
    private static final Random soundRandom = new Random();

    public static GasType getGasTypeByID(int gasID) {
        if (gasID >= 0 && gasID < gasTypesByID.length) {
            return gasTypesByID[gasID];
        }
        return null;
    }

    public static GasType getGasTypeByName(String name) {
        return gasTypesByName.get(name);
    }

    public static GasType[] getAllTypes() {
        ArrayList<GasType> list = new ArrayList<GasType>();
        for (GasType type : gasTypesByID) {
            if (type == null) continue;
            list.add(type);
        }
        GasType[] res = new GasType[list.size()];
        list.toArray(res);
        return res;
    }

    private void map() {
        GasType prev = GasType.getGasTypeByID(this.gasID);
        if (prev != null) {
            throw new RuntimeException("A gas type with name " + this.name + " attempted to override a gas type with name " + prev.name + " with gasID " + this.gasID);
        }
        GasType.gasTypesByID[this.gasID] = this;
        prev = GasType.getGasTypeByName(this.name);
        if (prev != null) {
            throw new RuntimeException("A gas type with name " + this.name + " attempted to override a gas type with the same name");
        }
        gasTypesByName.put(this.name, this);
    }

    public GasType(boolean isIndustrial, int gasID, String name, int color, int opacity, int density, Combustibility combustibility) {
        this.isIndustrial = isIndustrial;
        this.gasID = gasID;
        this.name = name;
        this.color = color;
        this.opacity = opacity;
        this.density = density;
        this.combustibility = combustibility;
        this.map();
    }

    public GasType setEffectRate(ExtendedGasEffectsBase.EffectType effectType, int value) {
        this.effectRates.put(effectType, value);
        return this;
    }

    public int getEffectRate(ExtendedGasEffectsBase.EffectType effectType) {
        Integer res = this.effectRates.get((Object)effectType);
        if (res == null) {
            return 0;
        }
        return res;
    }

    public GasType setDamage(float damage) {
        this.damage = damage;
        return this;
    }

    public GasType setDissipationRate(int dissipationRate) {
        this.dissipationRate = dissipationRate;
        return this;
    }

    public GasType setTextureName(String textureName) {
        this.textureName = textureName;
        return this;
    }

    public GasType setOverlayImage(ResourceLocation overlayImage) {
        this.overlayImage = overlayImage;
        return this;
    }

    public GasType setDestroyLooseBlocks(boolean destroyLooseBlocks) {
        this.destroyLooseBlocks = destroyLooseBlocks;
        return this;
    }

    public ItemStack getBottledItem() {
        return new ItemStack(GasesFrameworkAPI.gasBottle, 1, this.gasID);
    }

    public Block tweakGasBlock(Block block) {
        return block;
    }

    public Block tweakPipeBlock(Block block) {
        return block;
    }

    public void onBreathed(EntityLivingBase entity) {
        entity.func_70097_a(GasesFrameworkAPI.asphyxiationDamageSource, 2.0f);
    }

    public void onTouched(Entity entity) {
        String displayName;
        if (this.damage > 0.0f & !(entity instanceof EntityItem)) {
            entity.func_70097_a(DamageSource.field_76377_j, this.damage);
        }
        if (entity instanceof EntityPlayer && noisyPeople.contains(displayName = ((EntityPlayer)entity).getDisplayName().toLowerCase()) && soundRandom.nextInt(20) == 0) {
            entity.field_70170_p.func_72956_a(entity, "mob.villager.idle", 1.0f, 0.75f + soundRandom.nextFloat() * 0.5f);
        }
    }

    public void onDissipated(World world, int x, int y, int z) {
    }

    public void randomDisplayTick(World world, int x, int y, int z, Random random) {
    }

    public boolean isVisible() {
        return (this.color & 0xFF) != 0;
    }

    public double getMinY(IBlockAccess blockAccess, int x, int y, int z, int metadata) {
        if (this.density > 0) {
            return 0.0;
        }
        if (this.density < 0) {
            return (double)metadata / 16.0;
        }
        if (blockAccess.func_147439_a(x, y - 1, z) == this.block) {
            return 0.0;
        }
        boolean b = blockAccess.func_147439_a(x, y + 1, z) == this.block;
        double d = (0.5 - (double)(16 - metadata) / 8.0) * (b ? 2.0 : 1.0);
        return d < 0.0 ? 0.0 : d;
    }

    public double getMaxY(IBlockAccess blockAccess, int x, int y, int z, int metadata) {
        if (this.density > 0) {
            return 1.0 - (double)metadata / 16.0;
        }
        if (this.density < 0) {
            return 1.0;
        }
        if (blockAccess.func_147439_a(x, y + 1, z) == this.block) {
            return 1.0;
        }
        boolean b = blockAccess.func_147439_a(x, y - 1, z) == this.block;
        double d = 1.0 - (0.5 - (double)(16 - metadata) / 8.0) * (b ? 2.0 : 1.0);
        return d > 1.0 ? 1.0 : d;
    }

    public boolean canBeDestroyedBy(int thisVolume, GasType type, int otherVolume) {
        return false;
    }

    public boolean canFlowHere(int thisVolume, World world, int x, int y, int z) {
        GasType otherGasType = GasesFrameworkAPI.getGasType(world, x, y, z);
        if (otherGasType != null) {
            return otherGasType.canBeDestroyedBy(GasesFrameworkAPI.getGasVolume(world, x, y, z), this, thisVolume);
        }
        Material material = world.func_147439_a(x, y, z).func_149688_o();
        if (this.destroyLooseBlocks) {
            return !material.func_76224_d() && (material.func_76222_j() || material.func_76227_m() == 1);
        }
        return !material.func_76224_d() && material.func_76222_j();
    }

    public int getDissipation(World world, int x, int y, int z, Random random) {
        return this.dissipationRate > 0 && random.nextInt(this.dissipationRate) == 0 ? 1 : 0;
    }

    public void preTick(World world, int x, int y, int z, Random random) {
    }

    public void postTick(World world, int x, int y, int z, Random random) {
    }

    public boolean requiresNewTick(World world, int x, int y, int z, Random random) {
        return false;
    }

    public ResourceLocation getOverlayImage() {
        return this.overlayImage;
    }

    public String getUnlocalizedName() {
        return "gf_gas." + this.name;
    }

    static {
        noisyPeople.add("cyanideepic");
        noisyPeople.add("dethridgecraft");
        noisyPeople.add("wyld");
        noisyPeople.add("crustymustard");
        noisyPeople.add("glenna");
        noisyPeople.add("trentv4");
        noisyPeople.add("username720");
    }
}

