/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.api.gastype;

import glenn.gasesframework.api.Combustibility;
import glenn.gasesframework.api.GasesFrameworkAPI;
import glenn.gasesframework.api.gastype.GasType;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GasTypeFire
extends GasType {
    public GasTypeFire() {
        super(false, 11, "fire", -1, 0, 0, Combustibility.NONE);
        this.setOverlayImage(GasesFrameworkAPI.fireOverlayImage);
        this.setDissipationRate(2);
        this.setTextureName("gasesframework:gas_fire");
        this.setDestroyLooseBlocks(true);
    }

    @Override
    public Block tweakGasBlock(Block block) {
        block.func_149715_a(0.5f);
        return super.tweakGasBlock(block);
    }

    @Override
    public void onTouched(Entity entity) {
        super.onTouched(entity);
        entity.func_70015_d(5);
    }

    @Override
    public void onDissipated(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            if (Blocks.field_150480_ab.func_149742_c(world, x, y, z)) {
                world.func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
            } else if (GasesFrameworkAPI.getFireSmokeAmount() > 0 && world.field_73012_v.nextInt(4) == 0) {
                world.func_147465_d(x, y, z, GasesFrameworkAPI.gasTypeSmoke.block, 16 - GasesFrameworkAPI.getFireSmokeAmount(), 3);
            }
        }
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random random) {
        if (random.nextInt(12) == 0) {
            world.func_72980_b((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "fire.fire", 1.0f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f, false);
        }
        int metadata = world.func_72805_g(x, y, z);
        double minY = this.getMinY((IBlockAccess)world, x, y, z, metadata);
        double maxY = this.getMaxY((IBlockAccess)world, x, y, z, metadata);
        if ((double)random.nextFloat() < maxY - minY) {
            double xd = (double)x + random.nextDouble();
            double yd = (double)y + minY + random.nextDouble() * (maxY - minY);
            double zd = (double)z + random.nextDouble();
            world.func_72869_a("largesmoke", xd, yd, zd, 0.0, 0.0, 0.0);
        }
    }
}

