/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import glenn.gasesframework.api.ExtendedGasEffectsBase;
import glenn.gasesframework.api.GasesFrameworkAPI;
import glenn.gasesframework.api.block.MaterialGas;
import glenn.gasesframework.api.gastype.GasType;
import glenn.gasesframework.common.block.BlockGasPipe;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class ForgeClientEvents {
    private final ResourceLocation flow_indicator = new ResourceLocation("gasesframework", "textures/misc/flow_indicator.png");
    private final ResourceLocation flow_indicator_reverse = new ResourceLocation("gasesframework", "textures/misc/flow_indicator_reverse.png");
    private final ResourceLocation flow_indicator_dual = new ResourceLocation("gasesframework", "textures/misc/flow_indicator_dual.png");

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        ExtendedGasEffectsBase gasEffects = ExtendedGasEffectsBase.get(event.entity);
        float f = (float)gasEffects.get(ExtendedGasEffectsBase.EffectType.BLINDNESS) / 250.0f;
        if (f > 0.0f) {
            event.density = f * f + 0.01f;
            GL11.glFogi((int)2917, (int)2048);
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onFogColor(EntityViewRenderEvent.FogColors event) {
        ExtendedGasEffectsBase gasEffects = ExtendedGasEffectsBase.get(event.entity);
        float f = 1.0f / ((float)gasEffects.get(ExtendedGasEffectsBase.EffectType.BLINDNESS) / 30.0f + 1.0f);
        event.red *= f;
        event.green *= f;
        event.blue *= f;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onFOVUpdate(FOVUpdateEvent event) {
        float f = (float)ExtendedGasEffectsBase.get((EntityLivingBase)event.entity).get(ExtendedGasEffectsBase.EffectType.BLINDNESS) / 500.0f;
        event.newfov = event.fov * (2.0f - f * f) / 2.0f;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPreDrawScreen(RenderGameOverlayEvent event) {
        if (event.type == RenderGameOverlayEvent.ElementType.ALL) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityClientPlayerMP player = mc.field_71439_g;
            if (player != null && player.func_70055_a(MaterialGas.INSTANCE)) {
                int blockX = MathHelper.func_76128_c((double)player.field_70165_t);
                int blockY = MathHelper.func_76128_c((double)(player.field_70163_u + (double)player.func_70047_e()));
                int blockZ = MathHelper.func_76128_c((double)player.field_70161_v);
                GasType type = GasesFrameworkAPI.getGasType(player.field_70170_p, blockX, blockY, blockZ);
                if (type.overlayImage != null && type.isVisible()) {
                    mc.func_110434_K().func_110577_a(type.overlayImage);
                    Tessellator tessellator = Tessellator.field_78398_a;
                    float brightness = player.func_70013_c(event.partialTicks);
                    float red = brightness * (float)(type.color >> 24 & 0xFF) / 255.0f;
                    float green = brightness * (float)(type.color >> 16 & 0xFF) / 255.0f;
                    float blue = brightness * (float)(type.color >> 8 & 0xFF) / 255.0f;
                    float alpha = (float)(type.color & 0xFF) / 255.0f;
                    GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
                    GL11.glEnable((int)3042);
                    OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                    GL11.glPushMatrix();
                    float f2 = 4.0f;
                    float f3 = -1.0f;
                    float f4 = 1.0f;
                    float f5 = -1.0f;
                    float f6 = 1.0f;
                    float f7 = -0.5f;
                    float f8 = -player.field_70177_z / 64.0f + (float)player.field_70165_t / 2.0f;
                    float f9 = player.field_70125_A / 64.0f + (float)player.field_70161_v / 2.0f;
                    tessellator.func_78382_b();
                    tessellator.func_78374_a((double)f3, (double)f5, (double)f7, (double)(f2 + f8), (double)(f2 + f9));
                    tessellator.func_78374_a((double)f4, (double)f5, (double)f7, (double)(0.0f + f8), (double)(f2 + f9));
                    tessellator.func_78374_a((double)f4, (double)f6, (double)f7, (double)(0.0f + f8), (double)(0.0f + f9));
                    tessellator.func_78374_a((double)f3, (double)f6, (double)f7, (double)(f2 + f8), (double)(0.0f + f9));
                    tessellator.func_78381_a();
                    GL11.glPopMatrix();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glDisable((int)3042);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onDrawBlockHighlight(DrawBlockHighlightEvent event) {
        int x = event.target.field_72311_b;
        int y = event.target.field_72312_c;
        int z = event.target.field_72309_d;
        double xd = (double)x - (event.player.field_70142_S + (event.player.field_70165_t - event.player.field_70142_S) * (double)event.partialTicks);
        double yd = (double)y - (event.player.field_70137_T + (event.player.field_70163_u - event.player.field_70137_T) * (double)event.partialTicks);
        double zd = (double)z - (event.player.field_70136_U + (event.player.field_70161_v - event.player.field_70136_U) * (double)event.partialTicks);
        World world = event.player.field_70170_p;
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof BlockGasPipe) {
            BlockGasPipe gasPipe = (BlockGasPipe)block;
            ItemStack currentPlayerItem = event.player.func_71045_bC();
            if (GasesFrameworkAPI.gasTypeAir.pipeBlock != null && currentPlayerItem != null && currentPlayerItem.func_77973_b() == Item.func_150898_a((Block)GasesFrameworkAPI.gasTypeAir.pipeBlock)) {
                byte[] pumpingDirections = gasPipe.getPossiblePropellingDirections(world, x, y, z);
                boolean[] flowSides = new boolean[6];
                boolean[] reverseFlowSides = new boolean[6];
                boolean[] dualFlowSides = new boolean[6];
                block5: for (int side = 0; side < 6; ++side) {
                    switch (pumpingDirections[side]) {
                        case 1: {
                            flowSides[side] = true;
                            continue block5;
                        }
                        case 2: {
                            reverseFlowSides[side] = true;
                            continue block5;
                        }
                        case 3: {
                            dualFlowSides[side] = true;
                        }
                    }
                }
                GL11.glMatrixMode((int)5888);
                GL11.glPushMatrix();
                GL11.glTranslated((double)xd, (double)yd, (double)zd);
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GL11.glEnable((int)3008);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glEnable((int)3553);
                this.drawOverlay(flowSides, this.flow_indicator);
                this.drawOverlay(reverseFlowSides, this.flow_indicator_reverse);
                this.drawOverlay(dualFlowSides, this.flow_indicator_dual);
                GL11.glPopMatrix();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void drawOverlay(boolean[] sideConnections, ResourceLocation texture) {
        double d0 = 0.6875;
        double d1 = 0.3125;
        double uvd0 = 0.59375;
        double[] sideUVs = new double[6];
        double[] sides = new double[6];
        for (int side = 0; side < 6; ++side) {
            double offset;
            double offsetUV = sideConnections[side] ? 1.0 : 0.59375;
            double d = offset = sideConnections[side] ? 1.5 : 0.6875;
            if ((side & 1) == 1) {
                sideUVs[side] = offsetUV;
                sides[side] = offset;
                continue;
            }
            sideUVs[side] = 1.0 - offsetUV;
            sides[side] = 1.0 - offset;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78380_c(15);
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        tessellator.func_78374_a(sides[4], sides[0], 0.6875, sideUVs[4], sideUVs[0]);
        tessellator.func_78374_a(sides[5], sides[0], 0.6875, sideUVs[5], sideUVs[0]);
        tessellator.func_78374_a(sides[5], sides[1], 0.6875, sideUVs[5], sideUVs[1]);
        tessellator.func_78374_a(sides[4], sides[1], 0.6875, sideUVs[4], sideUVs[1]);
        tessellator.func_78374_a(sides[4], sides[1], 0.3125, sideUVs[4], sideUVs[1]);
        tessellator.func_78374_a(sides[5], sides[1], 0.3125, sideUVs[5], sideUVs[1]);
        tessellator.func_78374_a(sides[5], sides[0], 0.3125, sideUVs[5], sideUVs[0]);
        tessellator.func_78374_a(sides[4], sides[0], 0.3125, sideUVs[4], sideUVs[0]);
        tessellator.func_78374_a(0.6875, sides[0], sides[2], sideUVs[0], sideUVs[2]);
        tessellator.func_78374_a(0.6875, sides[1], sides[2], sideUVs[1], sideUVs[2]);
        tessellator.func_78374_a(0.6875, sides[1], sides[3], sideUVs[1], sideUVs[3]);
        tessellator.func_78374_a(0.6875, sides[0], sides[3], sideUVs[0], sideUVs[3]);
        tessellator.func_78374_a(0.3125, sides[0], sides[3], sideUVs[0], sideUVs[3]);
        tessellator.func_78374_a(0.3125, sides[1], sides[3], sideUVs[1], sideUVs[3]);
        tessellator.func_78374_a(0.3125, sides[1], sides[2], sideUVs[1], sideUVs[2]);
        tessellator.func_78374_a(0.3125, sides[0], sides[2], sideUVs[0], sideUVs[2]);
        tessellator.func_78374_a(sides[4], 0.6875, sides[2], sideUVs[2], sideUVs[4]);
        tessellator.func_78374_a(sides[4], 0.6875, sides[3], sideUVs[3], sideUVs[4]);
        tessellator.func_78374_a(sides[5], 0.6875, sides[3], sideUVs[3], sideUVs[5]);
        tessellator.func_78374_a(sides[5], 0.6875, sides[2], sideUVs[2], sideUVs[5]);
        tessellator.func_78374_a(sides[5], 0.3125, sides[2], sideUVs[2], sideUVs[5]);
        tessellator.func_78374_a(sides[5], 0.3125, sides[3], sideUVs[3], sideUVs[5]);
        tessellator.func_78374_a(sides[4], 0.3125, sides[3], sideUVs[3], sideUVs[4]);
        tessellator.func_78374_a(sides[4], 0.3125, sides[2], sideUVs[2], sideUVs[4]);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        tessellator.func_78381_a();
    }
}

