/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.client.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import glenn.gasesframework.api.GasesFrameworkAPI;
import glenn.gasesframework.api.gastype.GasType;
import glenn.gasesframework.common.block.BlockInfiniteGasPump;
import glenn.gasesframework.common.tileentity.TileEntityInfiniteGasPump;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderBlockInfiniteGasPump
implements ISimpleBlockRenderingHandler {
    public static final int RENDER_ID = RenderingRegistry.getNextAvailableRenderId();

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        if (renderer.field_147844_c) {
            int var6 = block.func_149741_i(metadata);
            red = (float)(var6 >> 16 & 0xFF) / 255.0f;
            green = (float)(var6 >> 8 & 0xFF) / 255.0f;
            blue = (float)(var6 & 0xFF) / 255.0f;
        }
        renderer.func_147775_a(block);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 0, metadata));
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 1, metadata));
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 2, metadata));
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 3, metadata));
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 4, metadata));
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 5, metadata));
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    private void getUVs(double[] us, double[] vs, IIcon icon) {
        block6: for (int i = 0; i < 4; ++i) {
            switch (i) {
                case 0: {
                    us[i] = icon.func_94214_a(16.0);
                    vs[i] = icon.func_94207_b(0.0);
                    continue block6;
                }
                case 1: {
                    us[i] = icon.func_94214_a(0.0);
                    vs[i] = icon.func_94207_b(0.0);
                    continue block6;
                }
                case 2: {
                    us[i] = icon.func_94214_a(0.0);
                    vs[i] = icon.func_94207_b(16.0);
                    continue block6;
                }
                case 3: {
                    us[i] = icon.func_94214_a(16.0);
                    vs[i] = icon.func_94207_b(16.0);
                }
            }
        }
    }

    private void renderDown(Tessellator tessellator, double[] us, double[] vs, IIcon icon, float r, float g, float b) {
        tessellator.func_78386_a(0.6f * r, 0.6f * g, 0.6f * b);
        this.getUVs(us, vs, icon);
        tessellator.func_78374_a(1.0, 0.0, 0.0, us[1], vs[1]);
        tessellator.func_78374_a(1.0, 0.0, 1.0, us[2], vs[2]);
        tessellator.func_78374_a(0.0, 0.0, 1.0, us[3], vs[3]);
        tessellator.func_78374_a(0.0, 0.0, 0.0, us[0], vs[0]);
    }

    private void renderUp(Tessellator tessellator, double[] us, double[] vs, IIcon icon, float r, float g, float b) {
        tessellator.func_78386_a(1.0f * r, 1.0f * g, 1.0f * b);
        this.getUVs(us, vs, icon);
        tessellator.func_78374_a(0.0, 1.0, 0.0, us[1], vs[1]);
        tessellator.func_78374_a(0.0, 1.0, 1.0, us[2], vs[2]);
        tessellator.func_78374_a(1.0, 1.0, 1.0, us[3], vs[3]);
        tessellator.func_78374_a(1.0, 1.0, 0.0, us[0], vs[0]);
    }

    private void renderNorth(Tessellator tessellator, double[] us, double[] vs, IIcon icon, float r, float g, float b) {
        tessellator.func_78386_a(0.8f * r, 0.8f * g, 0.8f * b);
        this.getUVs(us, vs, icon);
        tessellator.func_78374_a(0.0, 1.0, 0.0, us[0], vs[0]);
        tessellator.func_78374_a(1.0, 1.0, 0.0, us[1], vs[1]);
        tessellator.func_78374_a(1.0, 0.0, 0.0, us[2], vs[2]);
        tessellator.func_78374_a(0.0, 0.0, 0.0, us[3], vs[3]);
    }

    private void renderSouth(Tessellator tessellator, double[] us, double[] vs, IIcon icon, float r, float g, float b) {
        tessellator.func_78386_a(0.8f * r, 0.8f * g, 0.8f * b);
        this.getUVs(us, vs, icon);
        tessellator.func_78374_a(0.0, 0.0, 1.0, us[2], vs[2]);
        tessellator.func_78374_a(1.0, 0.0, 1.0, us[3], vs[3]);
        tessellator.func_78374_a(1.0, 1.0, 1.0, us[0], vs[0]);
        tessellator.func_78374_a(0.0, 1.0, 1.0, us[1], vs[1]);
    }

    private void renderEast(Tessellator tessellator, double[] us, double[] vs, IIcon icon, float r, float g, float b) {
        tessellator.func_78386_a(0.8f * r, 0.8f * g, 0.8f * b);
        this.getUVs(us, vs, icon);
        tessellator.func_78374_a(1.0, 0.0, 0.0, us[3], vs[3]);
        tessellator.func_78374_a(1.0, 1.0, 0.0, us[0], vs[0]);
        tessellator.func_78374_a(1.0, 1.0, 1.0, us[1], vs[1]);
        tessellator.func_78374_a(1.0, 0.0, 1.0, us[2], vs[2]);
    }

    private void renderWest(Tessellator tessellator, double[] us, double[] vs, IIcon icon, float r, float g, float b) {
        tessellator.func_78386_a(0.8f * r, 0.8f * g, 0.8f * b);
        this.getUVs(us, vs, icon);
        tessellator.func_78374_a(0.0, 0.0, 1.0, us[3], vs[3]);
        tessellator.func_78374_a(0.0, 1.0, 1.0, us[0], vs[0]);
        tessellator.func_78374_a(0.0, 1.0, 0.0, us[1], vs[1]);
        tessellator.func_78374_a(0.0, 0.0, 0.0, us[2], vs[2]);
    }

    private void renderFace(BlockInfiniteGasPump block, IBlockAccess blockAccess, int x, int y, int z, Tessellator tessellator, double[] us, double[] vs, ForgeDirection faceDirection, IIcon icon, float r, float g, float b) {
        switch (faceDirection) {
            case DOWN: {
                tessellator.func_78380_c(block.func_149677_c(blockAccess, x, y - 1, z));
                this.renderDown(tessellator, us, vs, icon, r, g, b);
                break;
            }
            case UP: {
                tessellator.func_78380_c(block.func_149677_c(blockAccess, x, y + 1, z));
                this.renderUp(tessellator, us, vs, icon, r, g, b);
                break;
            }
            case NORTH: {
                tessellator.func_78380_c(block.func_149677_c(blockAccess, x, y, z - 1));
                this.renderNorth(tessellator, us, vs, icon, r, g, b);
                break;
            }
            case SOUTH: {
                tessellator.func_78380_c(block.func_149677_c(blockAccess, x, y, z + 1));
                this.renderSouth(tessellator, us, vs, icon, r, g, b);
                break;
            }
            case WEST: {
                tessellator.func_78380_c(block.func_149677_c(blockAccess, x - 1, y, z));
                this.renderWest(tessellator, us, vs, icon, r, g, b);
                break;
            }
            case EAST: {
                tessellator.func_78380_c(block.func_149677_c(blockAccess, x + 1, y, z));
                this.renderEast(tessellator, us, vs, icon, r, g, b);
                break;
            }
        }
    }

    public boolean renderWorldBlock(IBlockAccess blockAccess, int x, int y, int z, Block bblock, int modelId, RenderBlocks renderer) {
        BlockInfiniteGasPump block = (BlockInfiniteGasPump)bblock;
        TileEntityInfiniteGasPump tileEntity = (TileEntityInfiniteGasPump)blockAccess.func_147438_o(x, y, z);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78372_c((float)x, (float)y, (float)z);
        double[] us = new double[4];
        double[] vs = new double[4];
        for (ForgeDirection faceDirection : ForgeDirection.VALID_DIRECTIONS) {
            IIcon icon;
            GasType type = tileEntity.getType(faceDirection);
            if (type != null && type != GasesFrameworkAPI.gasTypeAir) {
                int color = type.color;
                float gasRed = 0.25f + (float)(color >> 24 & 0xFF) / 510.0f;
                float gasGreen = 0.25f + (float)(color >> 16 & 0xFF) / 510.0f;
                float gasBlue = 0.25f + (float)(color >> 8 & 0xFF) / 510.0f;
                this.renderFace(block, blockAccess, x, y, z, tessellator, us, vs, faceDirection, block.indicatorIcon, gasRed, gasGreen, gasBlue);
                icon = block.typeIcon;
            } else {
                icon = block.func_149733_h(faceDirection.ordinal());
            }
            this.renderFace(block, blockAccess, x, y, z, tessellator, us, vs, faceDirection, icon, 1.0f, 1.0f, 1.0f);
        }
        tessellator.func_78372_c((float)(-x), (float)(-y), (float)(-z));
        return true;
    }

    public boolean shouldRender3DInInventory(int i) {
        return true;
    }

    public int getRenderId() {
        return RENDER_ID;
    }
}

