/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.common.tileentity;

import glenn.gasesframework.api.GasesFrameworkAPI;
import glenn.gasesframework.api.block.IGasReceptor;
import glenn.gasesframework.api.block.IGasSource;
import glenn.gasesframework.api.gastype.GasType;
import glenn.gasesframework.api.mechanical.IGasTransposerExtractHandler;
import glenn.gasesframework.api.mechanical.IGasTransposerHandler;
import glenn.gasesframework.api.mechanical.IGasTransposerInsertHandler;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityGasTransposer
extends TileEntity
implements ISidedInventory {
    private ItemStack[] itemStacks = new ItemStack[2];
    private String customName;
    public Mode mode = Mode.INSERT;
    public int time = 0;
    public int totalTime = 0;
    public GasType containedType = null;
    public GasType pendingType = null;
    private IGasTransposerHandler currentHandler;

    public static void registerHandler(IGasTransposerHandler handler) {
        for (Mode mode : Mode.values()) {
            mode.registerHandler(handler);
        }
    }

    private void setHandler(IGasTransposerHandler handler, int totalTime) {
        if (this.currentHandler != handler) {
            this.currentHandler = handler;
            this.time = 0;
            this.totalTime = totalTime;
            this.pendingType = null;
        }
    }

    public void toggleMode() {
        int modeOrdinal = (this.mode.ordinal() + 1) % Mode.values().length;
        this.setMode(modeOrdinal);
    }

    public int getScaledProgress(int max) {
        if (this.totalTime > 0) {
            return max * this.time / this.totalTime;
        }
        return 0;
    }

    public void setMode(int ordinal) {
        TileEntityGasTransposer tileEntityGasTransposer = this;
        Mode[] modes = tileEntityGasTransposer.mode.values();
        if (ordinal >= 0 && ordinal < modes.length) {
            this.mode = modes[ordinal];
        }
        this.setHandler(null, 0);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.currentHandler != null) {
                ++this.time;
                if (this.time >= this.totalTime) {
                    if (this.mode.complete(this)) {
                        this.setHandler(null, 0);
                    } else {
                        this.time = this.totalTime;
                    }
                }
            }
            this.mode.tick(this);
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList nbttaglist = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound itemCompound = nbttaglist.func_150305_b(i);
            byte slot = itemCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.itemStacks[slot] = ItemStack.func_77949_a((NBTTagCompound)itemCompound);
        }
        try {
            this.mode = Mode.valueOf(tagCompound.func_74779_i("Mode"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.time = tagCompound.func_74762_e("time");
        this.containedType = GasType.getGasTypeByID(tagCompound.func_74762_e("containedType"));
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        NBTTagList itemTags = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.itemStacks[i] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            this.itemStacks[i].func_77955_b(itemTag);
            itemTags.func_74742_a((NBTBase)itemTag);
        }
        tagCompound.func_74782_a("Items", (NBTBase)itemTags);
        tagCompound.func_74778_a("Mode", this.mode.toString());
        tagCompound.func_74768_a("time", this.time);
        tagCompound.func_74768_a("containedType", this.containedType != null ? this.containedType.gasID : -1);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return entityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public int func_70302_i_() {
        return this.itemStacks.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.itemStacks[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stackInSlot = this.itemStacks[slot];
        ItemStack result = null;
        if (stackInSlot != null) {
            if (stackInSlot.field_77994_a < amount) {
                this.itemStacks[slot] = null;
                result = stackInSlot;
            } else {
                result = stackInSlot.func_77979_a(amount);
                if (stackInSlot.field_77994_a <= 0) {
                    this.itemStacks[slot] = null;
                }
            }
        }
        this.mode.validate(this);
        return result;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stackInSlot = this.itemStacks[slot];
        if (stackInSlot != null) {
            this.itemStacks[slot] = null;
            this.mode.validate(this);
            return stackInSlot;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.itemStacks[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.mode.validate(this);
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : this.mode.getUnlocalizedName();
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return slot == this.mode.inputSlot && this.mode.isValidInput(itemstack);
    }

    public int[] func_94128_d(int side) {
        if (side == 0) {
            return new int[]{this.mode.outputSlot};
        }
        return new int[]{this.mode.inputSlot};
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int side) {
        return this.func_94041_b(slot, itemstack);
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        return slot == this.mode.outputSlot;
    }

    public static enum Mode {
        INSERT(0, 1){
            private final LinkedList<IGasTransposerInsertHandler> handlers = new LinkedList();

            @Override
            public void registerHandler(IGasTransposerHandler handler) {
                if (handler instanceof IGasTransposerInsertHandler) {
                    this.handlers.add((IGasTransposerInsertHandler)handler);
                }
            }

            @Override
            public void validate(TileEntityGasTransposer tileEntity) {
                IGasTransposerInsertHandler handler = (IGasTransposerInsertHandler)tileEntity.currentHandler;
                if (!(handler == null || tileEntity.itemStacks[this.inputSlot] != null && handler.isValidInsertionInput(tileEntity.itemStacks[this.inputSlot]) && handler.isValidInsertionInput(tileEntity.itemStacks[this.inputSlot], tileEntity.containedType))) {
                    tileEntity.setHandler(null, 0);
                }
            }

            @Override
            public boolean isValidInput(ItemStack inputStack) {
                if (inputStack != null) {
                    return !this.getHandlersForItem(inputStack).isEmpty();
                }
                return false;
            }

            @Override
            public String getUnlocalizedName() {
                return "container.gasTransposer.insert.name";
            }

            @Override
            public void tick(TileEntityGasTransposer tileEntity) {
                if (tileEntity.currentHandler == null && tileEntity.itemStacks[this.inputSlot] != null) {
                    for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                        IGasTransposerInsertHandler handler;
                        IGasSource gasSource;
                        GasType gasType;
                        int x = tileEntity.field_145851_c + direction.offsetX;
                        int y = tileEntity.field_145848_d + direction.offsetY;
                        int z = tileEntity.field_145849_e + direction.offsetZ;
                        Block block = tileEntity.field_145850_b.func_147439_a(x, y, z);
                        if (!(block instanceof IGasSource) || (gasType = (gasSource = (IGasSource)block).getGasTypeFromSide(tileEntity.field_145850_b, x, y, z, direction.getOpposite())) == null || (handler = this.getHandlerForItemAndGasType(tileEntity.itemStacks[this.inputSlot], gasType)) == null) continue;
                        gasType = gasSource.takeGasTypeFromSide(tileEntity.field_145850_b, x, y, z, direction.getOpposite());
                        tileEntity.setHandler(handler, handler.getInsertionTime());
                        tileEntity.containedType = gasType;
                        return;
                    }
                }
            }

            @Override
            public boolean complete(TileEntityGasTransposer tileEntity) {
                IGasTransposerInsertHandler handler = (IGasTransposerInsertHandler)tileEntity.currentHandler;
                if (handler.completeInsertion(tileEntity.itemStacks[this.inputSlot], tileEntity.itemStacks[this.outputSlot], tileEntity.containedType)) {
                    ((TileEntityGasTransposer)tileEntity).itemStacks[this.inputSlot] = handler.getInsertionInputStack(tileEntity.itemStacks[this.inputSlot], tileEntity.itemStacks[this.outputSlot], tileEntity.containedType);
                    ((TileEntityGasTransposer)tileEntity).itemStacks[this.outputSlot] = handler.getInsertionOutputStack(tileEntity.itemStacks[this.inputSlot], tileEntity.itemStacks[this.outputSlot], tileEntity.containedType);
                    tileEntity.containedType = null;
                    return true;
                }
                return false;
            }

            @Override
            public boolean canReceiveGas(TileEntityGasTransposer tileEntity, GasType gasType) {
                IGasTransposerInsertHandler handler = this.getHandlerForItemAndGasType(tileEntity.itemStacks[this.inputSlot], gasType);
                if (handler != null) {
                    return handler != tileEntity.currentHandler;
                }
                return gasType == null || gasType == GasesFrameworkAPI.gasTypeAir;
            }

            @Override
            public boolean receiveGas(TileEntityGasTransposer tileEntity, GasType gasType) {
                IGasTransposerInsertHandler handler = this.getHandlerForItemAndGasType(tileEntity.itemStacks[this.inputSlot], gasType);
                if (handler != null) {
                    if (handler != tileEntity.currentHandler) {
                        tileEntity.setHandler(handler, handler.getInsertionTime());
                        tileEntity.containedType = gasType;
                        return true;
                    }
                    return false;
                }
                return gasType == null || gasType == GasesFrameworkAPI.gasTypeAir;
            }

            @Override
            public boolean canPropelGas(TileEntityGasTransposer tileEntity) {
                return false;
            }

            private Collection<IGasTransposerInsertHandler> getHandlersForItem(ItemStack inputStack) {
                LinkedList<IGasTransposerInsertHandler> itemHandlers = new LinkedList<IGasTransposerInsertHandler>();
                if (inputStack != null) {
                    for (IGasTransposerInsertHandler handler : this.handlers) {
                        if (!handler.isValidInsertionInput(inputStack)) continue;
                        itemHandlers.push(handler);
                    }
                }
                return itemHandlers;
            }

            private IGasTransposerInsertHandler getHandlerForItemAndGasType(ItemStack inputStack, GasType gasType) {
                for (IGasTransposerInsertHandler handler : this.getHandlersForItem(inputStack)) {
                    if (!handler.isValidInsertionInput(inputStack, gasType)) continue;
                    return handler;
                }
                return null;
            }

            @Override
            public int getGuiArrowColor(TileEntityGasTransposer tileEntity) {
                if (tileEntity.containedType != null) {
                    return tileEntity.containedType.color >> 8;
                }
                return 0xFFFFFF;
            }
        }
        ,
        EXTRACT(1, 0){
            private final LinkedList<IGasTransposerExtractHandler> handlers = new LinkedList();

            @Override
            public void registerHandler(IGasTransposerHandler handler) {
                if (handler instanceof IGasTransposerExtractHandler) {
                    this.handlers.add((IGasTransposerExtractHandler)handler);
                }
            }

            @Override
            public void validate(TileEntityGasTransposer tileEntity) {
                IGasTransposerExtractHandler handler = (IGasTransposerExtractHandler)tileEntity.currentHandler;
                if (handler != null && (tileEntity.itemStacks[this.inputSlot] == null || handler.getExtractionOutputGasType(tileEntity.itemStacks[this.inputSlot]) == null)) {
                    tileEntity.setHandler(null, 0);
                }
            }

            @Override
            public boolean isValidInput(ItemStack inputStack) {
                if (inputStack != null) {
                    return !this.getHandlersForItem(inputStack).isEmpty();
                }
                return false;
            }

            @Override
            public String getUnlocalizedName() {
                return "container.gasTransposer.extract.name";
            }

            @Override
            public void tick(TileEntityGasTransposer tileEntity) {
                ItemStack itemstack;
                if (tileEntity.currentHandler == null && (itemstack = tileEntity.itemStacks[this.inputSlot]) != null) {
                    for (IGasTransposerExtractHandler handler : this.getHandlersForItem(itemstack)) {
                        GasType gasType = handler.getExtractionOutputGasType(itemstack);
                        if (gasType == null) continue;
                        tileEntity.setHandler(handler, handler.getExtractionTime());
                        tileEntity.pendingType = gasType;
                        break;
                    }
                }
            }

            @Override
            public boolean complete(TileEntityGasTransposer tileEntity) {
                IGasTransposerExtractHandler handler = (IGasTransposerExtractHandler)tileEntity.currentHandler;
                if (handler.completeExtraction(tileEntity.itemStacks[1], tileEntity.itemStacks[this.outputSlot], tileEntity.pendingType)) {
                    ForgeDirection direction = ForgeDirection.getOrientation((int)tileEntity.field_145850_b.func_72805_g(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e));
                    int x = tileEntity.field_145851_c + direction.offsetX;
                    int y = tileEntity.field_145848_d + direction.offsetY;
                    int z = tileEntity.field_145849_e + direction.offsetZ;
                    Block block = tileEntity.field_145850_b.func_147439_a(x, y, z);
                    if (block instanceof IGasReceptor) {
                        if (((IGasReceptor)block).receiveGas(tileEntity.field_145850_b, x, y, z, direction.getOpposite(), tileEntity.pendingType)) {
                            ((TileEntityGasTransposer)tileEntity).itemStacks[this.inputSlot] = handler.getExtractionInputStack(tileEntity.itemStacks[this.inputSlot], tileEntity.itemStacks[this.outputSlot], tileEntity.pendingType);
                            ((TileEntityGasTransposer)tileEntity).itemStacks[this.outputSlot] = handler.getExtractionOutputStack(tileEntity.itemStacks[this.inputSlot], tileEntity.itemStacks[this.outputSlot], tileEntity.pendingType);
                            return true;
                        }
                    } else if (GasesFrameworkAPI.fillWithGas(tileEntity.field_145850_b, ((TileEntityGasTransposer)tileEntity).field_145850_b.field_73012_v, x, y, z, tileEntity.pendingType)) {
                        ((TileEntityGasTransposer)tileEntity).itemStacks[this.inputSlot] = handler.getExtractionInputStack(tileEntity.itemStacks[this.inputSlot], tileEntity.itemStacks[this.outputSlot], tileEntity.pendingType);
                        ((TileEntityGasTransposer)tileEntity).itemStacks[this.outputSlot] = handler.getExtractionOutputStack(tileEntity.itemStacks[this.inputSlot], tileEntity.itemStacks[this.outputSlot], tileEntity.pendingType);
                        return true;
                    }
                }
                return false;
            }

            @Override
            public boolean canReceiveGas(TileEntityGasTransposer tileEntity, GasType gasType) {
                return false;
            }

            @Override
            public boolean receiveGas(TileEntityGasTransposer tileEntity, GasType gasType) {
                return this.canReceiveGas(tileEntity, gasType);
            }

            @Override
            public boolean canPropelGas(TileEntityGasTransposer tileEntity) {
                return true;
            }

            @Override
            public int getGuiArrowColor(TileEntityGasTransposer tileEntity) {
                if (tileEntity.pendingType != null) {
                    return tileEntity.pendingType.color >> 8;
                }
                return 0xFFFFFF;
            }

            private Collection<IGasTransposerExtractHandler> getHandlersForItem(ItemStack inputStack) {
                LinkedList<IGasTransposerExtractHandler> itemHandlers = new LinkedList<IGasTransposerExtractHandler>();
                for (IGasTransposerExtractHandler handler : this.handlers) {
                    if (!handler.isValidExtractionInput(inputStack)) continue;
                    itemHandlers.push(handler);
                }
                return itemHandlers;
            }
        };

        public final int inputSlot;
        public final int outputSlot;

        private Mode(int inputSlot, int outputSlot) {
            this.inputSlot = inputSlot;
            this.outputSlot = outputSlot;
        }

        public abstract void registerHandler(IGasTransposerHandler var1);

        public abstract void validate(TileEntityGasTransposer var1);

        public abstract boolean isValidInput(ItemStack var1);

        public abstract String getUnlocalizedName();

        public abstract void tick(TileEntityGasTransposer var1);

        public abstract boolean complete(TileEntityGasTransposer var1);

        public abstract boolean canReceiveGas(TileEntityGasTransposer var1, GasType var2);

        public abstract boolean receiveGas(TileEntityGasTransposer var1, GasType var2);

        public abstract boolean canPropelGas(TileEntityGasTransposer var1);

        public abstract int getGuiArrowColor(TileEntityGasTransposer var1);
    }
}

