/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.util;

import glenn.gasesframework.util.PipeBranch;
import glenn.moddingutils.IVec;
import java.util.ArrayList;
import java.util.Random;

public abstract class PipeBranchIterator {
    private static final IVec[] offsets = new IVec[]{new IVec(0, -1, 0), new IVec(0, 1, 0), new IVec(0, 0, -1), new IVec(0, 0, 1), new IVec(-1, 0, 0), new IVec(1, 0, 0)};
    protected final PipeBranch begin;
    private ArrayList<Iteration> currentQueue;
    private int currentIndex = 0;
    private ArrayList<Iteration> nextQueue = new ArrayList();

    protected PipeBranchIterator(PipeBranch begin) {
        this.begin = begin;
        this.iterate(begin, begin.getPosition());
        this.swapQueue();
    }

    public Iteration next() {
        Iteration iteration = this.get(this.currentIndex++);
        if (this.currentIndex == this.currentQueue.size()) {
            this.swapQueue();
        }
        return iteration;
    }

    public Iteration narrowNext(Random random) {
        Iteration iteration = this.get(this.currentQueue.size() > 1 ? random.nextInt(this.currentQueue.size()) : 0);
        this.swapQueue();
        return iteration;
    }

    private Iteration get(int index) {
        if (!this.currentQueue.isEmpty()) {
            Iteration iteration = this.currentQueue.get(index);
            this.iterate(iteration.current, iteration.currentPosition);
            return iteration;
        }
        return null;
    }

    private void swapQueue() {
        this.currentIndex = 0;
        this.currentQueue = this.nextQueue;
        this.nextQueue = new ArrayList();
    }

    private void queue(Iteration iteration) {
        if (!this.nextQueue.contains(iteration)) {
            this.nextQueue.add(iteration);
        }
    }

    private void iterate(PipeBranch previous, IVec previousPosition) {
        for (int i = 0; i < 6; ++i) {
            PipeBranch next = previous.connections[i];
            if (next == null || !this.validate(previous, next)) continue;
            this.queue(new Iteration(previous, previousPosition, next, previousPosition.added(offsets[i]), i));
        }
    }

    protected abstract boolean validate(PipeBranch var1, PipeBranch var2);

    public static class Iteration {
        public final PipeBranch previous;
        public final IVec previousPosition;
        public final PipeBranch current;
        public final IVec currentPosition;
        public final int direction;

        public Iteration(PipeBranch previous, IVec previousPosition, PipeBranch current, IVec currentPosition, int direction) {
            this.previous = previous;
            this.previousPosition = previousPosition;
            this.current = current;
            this.currentPosition = currentPosition;
            this.direction = direction;
        }
    }

    public static class DescendingPipeBranchIterator
    extends PipeBranchIterator {
        public DescendingPipeBranchIterator(PipeBranch begin) {
            super(begin);
        }

        @Override
        protected boolean validate(PipeBranch previous, PipeBranch next) {
            return previous.depth > next.depth;
        }
    }

    public static class AscendingPipeBranchIterator
    extends PipeBranchIterator {
        public AscendingPipeBranchIterator(PipeBranch begin) {
            super(begin);
        }

        @Override
        protected boolean validate(PipeBranch previous, PipeBranch next) {
            return previous.depth < next.depth;
        }
    }
}

