/*
 * Decompiled with CFR 0.152.
 */
package glenn.moddingutils;

import cpw.mods.fml.common.FMLLog;
import glenn.moddingutils.AbstractMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Field;

public abstract class AbstractSerialMessage
extends AbstractMessage {
    @Override
    public void toBytes(ByteBuf buffer) {
        for (Field field : this.getClass().getFields()) {
            Class<?> c = field.getType();
            try {
                Object[] valArray;
                if (c == Character.TYPE) {
                    buffer.writeChar((int)field.getChar(this));
                    continue;
                }
                if (c == Byte.TYPE) {
                    buffer.writeByte((int)field.getByte(this));
                    continue;
                }
                if (c == Short.TYPE) {
                    buffer.writeShort((int)field.getShort(this));
                    continue;
                }
                if (c == Integer.TYPE) {
                    buffer.writeInt(field.getInt(this));
                    continue;
                }
                if (c == Long.TYPE) {
                    buffer.writeLong(field.getLong(this));
                    continue;
                }
                if (c == Boolean.TYPE) {
                    buffer.writeBoolean(field.getBoolean(this));
                    continue;
                }
                if (c == Float.TYPE) {
                    buffer.writeFloat(field.getFloat(this));
                    continue;
                }
                if (c == Double.TYPE) {
                    buffer.writeDouble(field.getDouble(this));
                    continue;
                }
                if (c == String.class) {
                    byte[] val = ((String)field.get(this)).getBytes();
                    buffer.writeShort(val.length);
                    buffer.writeBytes(val);
                    continue;
                }
                if (!c.isArray()) continue;
                Class<?> arrayC = c.getComponentType();
                int arraySize = 0;
                ByteBuf valBuffer = Unpooled.buffer();
                if (arrayC == Character.TYPE) {
                    for (char c2 : valArray = (char[])field.get(this)) {
                        valBuffer.writeChar((int)c2);
                    }
                } else if (arrayC == Byte.TYPE) {
                    for (char c3 : valArray = (Object[])((byte[])field.get(this))) {
                        valBuffer.writeByte((int)c3);
                    }
                } else if (arrayC == Short.TYPE) {
                    for (char c4 : valArray = (Object[])((short[])field.get(this))) {
                        valBuffer.writeShort((int)c4);
                    }
                } else if (arrayC == Integer.TYPE) {
                    for (char c5 : valArray = (Object[])((int[])field.get(this))) {
                        valBuffer.writeInt((int)c5);
                    }
                } else if (arrayC == Long.TYPE) {
                    for (char c6 : valArray = (Object[])((long[])field.get(this))) {
                        valBuffer.writeLong((long)c6);
                    }
                } else if (arrayC == Boolean.TYPE) {
                    for (boolean bl : valArray = (Object[])((boolean[])field.get(this))) {
                        valBuffer.writeBoolean(bl);
                    }
                } else if (arrayC == Float.TYPE) {
                    for (char c7 : valArray = (Object[])((float[])field.get(this))) {
                        valBuffer.writeFloat((float)c7);
                    }
                } else if (arrayC == Double.TYPE) {
                    for (char c8 : valArray = (Object[])((double[])field.get(this))) {
                        valBuffer.writeDouble((double)c8);
                    }
                }
                valBuffer.writeShort(arraySize);
                valBuffer.writeBytes(valBuffer);
            }
            catch (Exception e) {
                FMLLog.severe((String)"%s while writing packet %s.", (Object[])new Object[]{e.toString(), this.getClass().getCanonicalName()});
            }
        }
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        for (Field field : this.getClass().getFields()) {
            Class<?> c = field.getType();
            try {
                int i;
                Object[] valArray;
                if (c == Character.TYPE) {
                    field.setChar(this, buffer.readChar());
                    continue;
                }
                if (c == Byte.TYPE) {
                    field.setByte(this, buffer.readByte());
                    continue;
                }
                if (c == Short.TYPE) {
                    field.setShort(this, buffer.readShort());
                    continue;
                }
                if (c == Integer.TYPE) {
                    field.setInt(this, buffer.readInt());
                    continue;
                }
                if (c == Long.TYPE) {
                    field.setLong(this, buffer.readLong());
                    continue;
                }
                if (c == Boolean.TYPE) {
                    field.setBoolean(this, buffer.readBoolean());
                    continue;
                }
                if (c == Float.TYPE) {
                    field.setFloat(this, buffer.readFloat());
                    continue;
                }
                if (c == Double.TYPE) {
                    field.setDouble(this, buffer.readDouble());
                    continue;
                }
                if (c == String.class) {
                    byte[] val = new byte[buffer.readShort()];
                    buffer.readBytes(val);
                    field.set(this, new String(val, "UTF-16"));
                    continue;
                }
                if (!c.isArray()) continue;
                Class<?> arrayC = c.getComponentType();
                int arraySize = buffer.readShort();
                Object val = null;
                if (arrayC == Character.TYPE) {
                    valArray = new char[arraySize];
                    for (i = 0; i < arraySize; ++i) {
                        valArray[i] = buffer.readChar();
                    }
                } else if (arrayC == Byte.TYPE) {
                    valArray = new byte[arraySize];
                    for (i = 0; i < arraySize; ++i) {
                        valArray[i] = (char)buffer.readByte();
                    }
                } else if (arrayC == Short.TYPE) {
                    valArray = new short[arraySize];
                    for (i = 0; i < arraySize; ++i) {
                        valArray[i] = buffer.readShort();
                    }
                } else if (arrayC == Integer.TYPE) {
                    valArray = new int[arraySize];
                    for (i = 0; i < arraySize; ++i) {
                        valArray[i] = buffer.readInt();
                    }
                } else if (arrayC == Long.TYPE) {
                    valArray = new long[arraySize];
                    for (i = 0; i < arraySize; ++i) {
                        valArray[i] = (char)buffer.readLong();
                    }
                } else if (arrayC == Boolean.TYPE) {
                    valArray = new boolean[arraySize];
                    for (i = 0; i < arraySize; ++i) {
                        valArray[i] = (char)(buffer.readBoolean() ? 1 : 0);
                    }
                } else if (arrayC == Float.TYPE) {
                    valArray = new float[arraySize];
                    for (i = 0; i < arraySize; ++i) {
                        valArray[i] = (char)buffer.readFloat();
                    }
                } else if (arrayC == Double.TYPE) {
                    valArray = new double[arraySize];
                    for (i = 0; i < arraySize; ++i) {
                        valArray[i] = (char)buffer.readDouble();
                    }
                }
                field.set(this, val);
            }
            catch (Exception e) {
                FMLLog.severe((String)"%s while writing packet %s.", (Object[])new Object[]{e.toString(), this.getClass().getCanonicalName()});
            }
        }
    }
}

