/*
 * Decompiled with CFR 0.152.
 */
package glenn.moddingutils;

import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public abstract class Configurations {
    public Configurations(File configurationsFile) {
        Configuration config = new Configuration(configurationsFile);
        config.load();
        for (Field field : this.getClass().getFields()) {
            ConfigField configField = field.getAnnotation(ConfigField.class);
            if (configField == null) continue;
            String fieldPath = configField.path();
            int lastDot = fieldPath.lastIndexOf(46);
            String category = lastDot != -1 ? fieldPath.substring(0, lastDot) : "other";
            String name = fieldPath.substring(lastDot + 1);
            String comment = configField.comment();
            String defaultValue = configField.defaultValue();
            try {
                Property property;
                Class<?> c = field.getType();
                Object[] fieldValue = null;
                if (c == Integer.TYPE) {
                    int def = 0;
                    try {
                        def = Integer.parseInt(defaultValue);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Invalid default value for field " + fieldPath);
                    }
                    property = config.get(category, name, def, comment);
                    fieldValue = new Integer(property.getInt(def));
                    if (configField.autoReset()) {
                        property.set(def);
                    }
                } else if (c == Float.TYPE) {
                    float def = 0.0f;
                    try {
                        def = Float.parseFloat(defaultValue);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Invalid default value for field " + fieldPath);
                    }
                    property = config.get(category, name, (double)def, comment);
                    fieldValue = new Float((float)property.getDouble((double)def));
                    if (configField.autoReset()) {
                        property.set((double)def);
                    }
                } else if (c == Double.TYPE) {
                    double def = 0.0;
                    try {
                        def = Double.parseDouble(defaultValue);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Invalid default value for field " + fieldPath);
                    }
                    Property property2 = config.get(category, name, def, comment);
                    fieldValue = new Double(property2.getDouble(def));
                    if (configField.autoReset()) {
                        property2.set(def);
                    }
                } else if (c == Boolean.TYPE) {
                    boolean def = false;
                    try {
                        def = Boolean.parseBoolean(defaultValue);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Invalid default value for field " + fieldPath);
                    }
                    property = config.get(category, name, def, comment);
                    fieldValue = new Boolean(property.getBoolean(def));
                    if (configField.autoReset()) {
                        property.set(def);
                    }
                } else if (c == String.class) {
                    Property property3 = config.get(category, name, defaultValue, comment);
                    fieldValue = config.get(category, name, defaultValue, comment).getString();
                    if (configField.autoReset()) {
                        property3.set(defaultValue);
                    }
                } else if (c.isArray()) {
                    int i;
                    Object[] typeValues;
                    Class<?> arrayC = c.getComponentType();
                    String[] defStrings = defaultValue.equals("") ? new String[]{} : defaultValue.split("\n");
                    String[] stringValues = config.getStringList(name, category, defStrings, comment);
                    if (arrayC == Integer.class) {
                        typeValues = new int[stringValues.length];
                        for (i = 0; i < stringValues.length; ++i) {
                            try {
                                typeValues[i] = Integer.parseInt(stringValues[i]);
                                continue;
                            }
                            catch (Exception e) {
                                typeValues[i] = 0;
                            }
                        }
                        fieldValue = typeValues;
                    } else if (arrayC == Float.class) {
                        typeValues = new float[stringValues.length];
                        for (i = 0; i < stringValues.length; ++i) {
                            try {
                                typeValues[i] = (int)Float.parseFloat(stringValues[i]);
                                continue;
                            }
                            catch (Exception e) {
                                typeValues[i] = (int)0.0f;
                            }
                        }
                        fieldValue = typeValues;
                    } else if (arrayC == Double.class) {
                        typeValues = new double[stringValues.length];
                        for (i = 0; i < stringValues.length; ++i) {
                            try {
                                typeValues[i] = (int)Double.parseDouble(stringValues[i]);
                                continue;
                            }
                            catch (Exception e) {
                                typeValues[i] = (int)0.0;
                            }
                        }
                        fieldValue = typeValues;
                    } else if (arrayC == Boolean.class) {
                        typeValues = new boolean[stringValues.length];
                        for (i = 0; i < stringValues.length; ++i) {
                            try {
                                typeValues[i] = Boolean.parseBoolean(stringValues[i]) ? 1 : 0;
                                continue;
                            }
                            catch (Exception e) {
                                typeValues[i] = 0;
                            }
                        }
                        fieldValue = typeValues;
                    } else if (arrayC == String.class) {
                        fieldValue = stringValues;
                    }
                }
                if (fieldValue == null) {
                    throw new RuntimeException("Failed to read config field " + fieldPath + " because of unknown value type " + c.getName());
                }
                field.set(this, fieldValue);
            }
            catch (Exception e) {
                System.out.println(e.toString() + " Failed to set value for configuration field " + fieldPath);
            }
        }
        config.save();
        this.onLoaded();
    }

    protected abstract void onLoaded();

    public class ItemRepresentation {
        public String name;
        public int metadata = 0;
        public int amount = 1;

        public ItemStack getItemStack() {
            return new ItemStack((Item)Item.field_150901_e.func_82594_a(this.name), this.amount == 0 ? 1 : this.amount, this.metadata);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface ConfigField {
        public String path();

        public String comment() default "";

        public String defaultValue() default "";

        public boolean autoReset() default false;
    }
}

