/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.parser.json;

import com.github.lunatrius.ingameinfo.Alignment;
import com.github.lunatrius.ingameinfo.parser.IParser;
import com.github.lunatrius.ingameinfo.reference.Reference;
import com.github.lunatrius.ingameinfo.value.Value;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JsonParser
implements IParser {
    private JsonElement element;

    @Override
    public boolean load(InputStream inputStream) {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            com.google.gson.JsonParser parser = new com.google.gson.JsonParser();
            this.element = parser.parse((Reader)inputStreamReader);
            inputStreamReader.close();
        }
        catch (Exception e) {
            Reference.logger.fatal("Could not read json configuration file!", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean parse(Map<Alignment, List<List<Value>>> format) {
        if (!this.element.isJsonObject()) {
            return false;
        }
        JsonObject config = this.element.getAsJsonObject();
        Set entries = config.entrySet();
        for (Map.Entry entry : entries) {
            Alignment alignment = Alignment.parse((String)entry.getKey());
            if (alignment == null) continue;
            format.put(alignment, this.getLines((JsonElement)entry.getValue()));
        }
        return true;
    }

    private List<List<Value>> getLines(JsonElement elementLines) {
        ArrayList<List<Value>> listLines = new ArrayList<List<Value>>();
        JsonArray arrayLines = elementLines.getAsJsonArray();
        for (JsonElement elementLine : arrayLines) {
            if (elementLine == null || !elementLine.isJsonArray()) continue;
            listLines.add(this.getValues(elementLine.getAsJsonArray()));
        }
        return listLines;
    }

    private List<Value> getValues(JsonArray arrayValues) {
        ArrayList<Value> values = new ArrayList<Value>();
        for (JsonElement elementValue : arrayValues) {
            if (elementValue == null || !elementValue.isJsonObject()) continue;
            JsonObject object = elementValue.getAsJsonObject();
            Set entries = object.entrySet();
            for (Map.Entry entry : entries) {
                String type = (String)entry.getKey();
                Value value = Value.fromString(type);
                if (!value.isValid()) continue;
                if (value.isSimple()) {
                    value.setRawValue(((JsonElement)entry.getValue()).getAsString(), false);
                } else if (((JsonElement)entry.getValue()).isJsonArray()) {
                    value.values.addAll(this.getValues(((JsonElement)entry.getValue()).getAsJsonArray()));
                }
                values.add(value);
            }
        }
        return values;
    }
}

